/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.binary.BinReader;
import com.powsybl.commons.binary.BinWriter;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.exceptions.UncheckedSaxException;
import com.powsybl.commons.exceptions.UncheckedXmlStreamException;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.extensions.ExtensionProviders;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.commons.io.TreeDataFormat;
import com.powsybl.commons.io.TreeDataHeader;
import com.powsybl.commons.io.TreeDataReader;
import com.powsybl.commons.io.TreeDataWriter;
import com.powsybl.commons.json.JsonReader;
import com.powsybl.commons.json.JsonWriter;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.commons.report.ReportNodeAdder;
import com.powsybl.commons.xml.XmlReader;
import com.powsybl.commons.xml.XmlWriter;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Container;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableType;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.VoltageAngleLimit;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.serde.AbstractOptions;
import com.powsybl.iidm.serde.AliasesSerDe;
import com.powsybl.iidm.serde.BusFilter;
import com.powsybl.iidm.serde.DeserializerReports;
import com.powsybl.iidm.serde.ExportOptions;
import com.powsybl.iidm.serde.HvdcLineSerDe;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.ImportOptions;
import com.powsybl.iidm.serde.LineSerDe;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.PropertiesSerDe;
import com.powsybl.iidm.serde.SubstationSerDe;
import com.powsybl.iidm.serde.TieLineSerDe;
import com.powsybl.iidm.serde.VoltageAngleLimitSerDe;
import com.powsybl.iidm.serde.VoltageLevelSerDe;
import com.powsybl.iidm.serde.anonymizer.Anonymizer;
import com.powsybl.iidm.serde.anonymizer.SimpleAnonymizer;
import com.powsybl.iidm.serde.extensions.AbstractVersionableNetworkExtensionSerDe;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class NetworkSerDe {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetworkSerDe.class);
    private static final String EXTENSION_CATEGORY_NAME = "network";
    static final String NETWORK_ROOT_ELEMENT_NAME = "network";
    static final String NETWORK_ARRAY_ELEMENT_NAME = "networks";
    private static final String EXTENSION_ROOT_ELEMENT_NAME = "extension";
    private static final String EXTENSION_ARRAY_ELEMENT_NAME = "extensions";
    private static final String CASE_DATE = "caseDate";
    private static final String FORECAST_DISTANCE = "forecastDistance";
    private static final String SOURCE_FORMAT = "sourceFormat";
    private static final String ID = "id";
    private static final String MINIMUM_VALIDATION_LEVEL = "minimumValidationLevel";
    static final byte[] BIIDM_MAGIC_NUMBER = new byte[]{66, 105, 110, 97, 114, 121, 32, 73, 73, 68, 77};
    private static final Supplier<ExtensionProviders<ExtensionSerDe>> EXTENSIONS_SUPPLIER = Suppliers.memoize(() -> ExtensionProviders.createProvider(ExtensionSerDe.class, (String)"network"));
    private static final Supplier<Schema> SCHEMA_SUPPLIER = Suppliers.memoize(NetworkSerDe::createSchema);

    private NetworkSerDe() {
        ExtensionProviders.createProvider(ExtensionSerDe.class, (String)"network");
    }

    public static void validate(InputStream is) {
        Validator validator = SCHEMA_SUPPLIER.get().newValidator();
        try {
            validator.validate(new StreamSource(is));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (SAXException e) {
            throw new UncheckedSaxException(e);
        }
    }

    public static void validate(Path file) {
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            NetworkSerDe.validate(is);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Schema createSchema() {
        ArrayList additionalSchemas = new ArrayList();
        for (ExtensionSerDe e : EXTENSIONS_SUPPLIER.get().getProviders()) {
            e.getXsdAsStreamList().forEach(xsd -> additionalSchemas.add(new StreamSource((InputStream)xsd)));
        }
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            int length = IidmVersion.values().length + (int)Arrays.stream(IidmVersion.values()).filter(IidmVersion::supportEquipmentValidationLevel).count();
            Source[] sources = new Source[additionalSchemas.size() + length];
            int i = 0;
            int j = 0;
            for (IidmVersion version : IidmVersion.values()) {
                sources[i] = new StreamSource(NetworkSerDe.class.getResourceAsStream("/xsd/" + version.getXsd()));
                if (version.supportEquipmentValidationLevel()) {
                    sources[j + IidmVersion.values().length] = new StreamSource(NetworkSerDe.class.getResourceAsStream("/xsd/" + version.getXsd(false)));
                    ++j;
                }
                ++i;
            }
            for (int k = 0; k < additionalSchemas.size(); ++k) {
                sources[k + length] = (Source)additionalSchemas.get(k);
            }
            return factory.newSchema(sources);
        }
        catch (SAXException e) {
            throw new UncheckedSaxException(e);
        }
    }

    private static void throwExceptionIfOption(AbstractOptions<?> options, String message) {
        if (options.isThrowExceptionIfExtensionNotFound()) {
            throw new PowsyblException(message);
        }
        LOGGER.warn(message);
    }

    private static void writeExtension(Extension<? extends Identifiable<?>> extension, NetworkSerializerContext context) {
        TreeDataWriter writer = context.getWriter();
        ExtensionSerDe extensionSerDe = NetworkSerDe.getExtensionSerializer(context.getOptions(), extension);
        if (extensionSerDe == null) {
            throw new IllegalStateException("Extension Serializer of " + extension.getName() + " should not be null");
        }
        String namespaceUri = NetworkSerDe.getNamespaceUri(extensionSerDe, context.getOptions());
        writer.writeStartNode(namespaceUri, extension.getName());
        context.getExtensionVersion(extension.getName()).ifPresent(arg_0 -> ((ExtensionSerDe)extensionSerDe).checkExtensionVersionSupported(arg_0));
        extensionSerDe.write(extension, (SerializerContext)context);
        writer.writeEndNode();
    }

    private static ExtensionSerDe getExtensionSerializer(ExportOptions options, Extension<? extends Identifiable<?>> extension) {
        if (options.withExtension(extension.getName())) {
            ExtensionSerDe extensionSerDe;
            ExtensionSerDe extensionSerDe2 = extensionSerDe = options.isThrowExceptionIfExtensionNotFound() ? (ExtensionSerDe)EXTENSIONS_SUPPLIER.get().findProviderOrThrowException(extension.getName()) : (ExtensionSerDe)EXTENSIONS_SUPPLIER.get().findProvider(extension.getName());
            if (extensionSerDe == null) {
                String message = "XmlSerializer for " + extension.getName() + " not found";
                NetworkSerDe.throwExceptionIfOption(options, message);
            } else if (!extensionSerDe.isSerializable(extension)) {
                return null;
            }
            return extensionSerDe;
        }
        return null;
    }

    private static String getNamespaceUri(ExtensionSerDe<?, ?> extensionSerDe, ExportOptions options) {
        String extensionVersion = NetworkSerDe.getExtensionVersion(extensionSerDe, options);
        return extensionSerDe.getNamespaceUri(extensionVersion);
    }

    private static void writeVoltageAngleLimits(Network n, NetworkSerializerContext context) {
        if (n.getVoltageAngleLimitsStream().findAny().isPresent()) {
            context.getWriter().writeStartNodes();
            for (VoltageAngleLimit voltageAngleLimit : n.getVoltageAngleLimits()) {
                VoltageAngleLimitSerDe.write(voltageAngleLimit, context);
            }
            context.getWriter().writeEndNodes();
        }
    }

    private static void writeExtensions(Network n, NetworkSerializerContext context) {
        context.getWriter().writeStartNodes();
        for (Identifiable identifiable : IidmSerDeUtil.sorted(n.getIdentifiables(), context.getOptions())) {
            List<Extension> extensions;
            if (!context.isExportedEquipment(identifiable) || !NetworkSerDe.isElementWrittenInsideNetwork(identifiable, n, context) || (extensions = identifiable.getExtensions().stream().filter(e -> NetworkSerDe.canTheExtensionBeWritten(NetworkSerDe.getExtensionSerializer(context.getOptions(), e), context.getVersion(), context.getOptions())).toList()).isEmpty()) continue;
            context.getWriter().writeStartNode(context.getNamespaceURI(), EXTENSION_ROOT_ELEMENT_NAME);
            context.getWriter().writeStringAttribute(ID, context.getAnonymizer().anonymizeString(identifiable.getId()));
            for (Extension<? extends Identifiable<?>> extension : IidmSerDeUtil.sortedExtensions(extensions, context.getOptions())) {
                NetworkSerDe.writeExtension(extension, context);
            }
            context.getWriter().writeEndNode();
        }
        context.getWriter().writeEndNodes();
    }

    private static boolean canTheExtensionBeWritten(ExtensionSerDe extensionSerDe, IidmVersion version, ExportOptions options) {
        if (extensionSerDe == null) {
            return false;
        }
        boolean versionExist = true;
        if (extensionSerDe instanceof AbstractVersionableNetworkExtensionSerDe) {
            AbstractVersionableNetworkExtensionSerDe networkExtensionSerializer = (AbstractVersionableNetworkExtensionSerDe)extensionSerDe;
            versionExist = networkExtensionSerializer.versionExists(version);
        }
        if (!versionExist) {
            String message = String.format("Version %s does not support %s extension", new Object[]{version, extensionSerDe.getExtensionName()});
            NetworkSerDe.throwExceptionIfOption(options, message);
        }
        return versionExist;
    }

    private static void writeMainAttributes(Network n, NetworkSerializerContext context) {
        context.getWriter().writeStringAttribute(ID, context.getAnonymizer().anonymizeString(n.getId()));
        context.getWriter().writeStringAttribute(CASE_DATE, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").format(n.getCaseDate()));
        context.getWriter().writeIntAttribute(FORECAST_DISTANCE, n.getForecastDistance());
        context.getWriter().writeStringAttribute(SOURCE_FORMAT, n.getSourceFormat());
    }

    private static XmlWriter createXmlWriter(Network n, OutputStream os, ExportOptions options) {
        try {
            String iidmNamespace = options.getVersion().getNamespaceURI(n.getValidationLevel() == ValidationLevel.STEADY_STATE_HYPOTHESIS);
            String indent = options.isIndent() ? "    " : null;
            XmlWriter xmlWriter = new XmlWriter(os, indent, options.getCharset(), iidmNamespace, "iidm");
            Set<ExtensionSerDe<?, ?>> serializers = NetworkSerDe.getExtensionSerializers(n, options);
            for (ExtensionSerDe<?, ?> extensionSerDe : serializers) {
                String extensionVersion = NetworkSerDe.getExtensionVersion(extensionSerDe, options);
                xmlWriter.setExtensionNamespace(extensionSerDe.getName(), extensionSerDe.getNamespaceUri(extensionVersion), extensionSerDe.getNamespacePrefix());
            }
            NetworkSerDe.checkNamespaceCollisions(options, serializers);
            return xmlWriter;
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    private static JsonWriter createJsonWriter(OutputStream os, ExportOptions options) {
        try {
            return new JsonWriter(os, options.isIndent(), options.getVersion().toString("."), NetworkSerDe.createSingleNameToArrayNameMap(options));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static TreeDataWriter createBinWriter(OutputStream os, ExportOptions options) {
        LOGGER.warn("BETA feature, the resulting binary file is not guaranteed to still be readable in the next releases");
        return new BinWriter(os, BIIDM_MAGIC_NUMBER, options.getVersion().toString("."));
    }

    private static void writeRootElement(Network n, NetworkSerializerContext context) {
        IidmSerDeUtil.assertMinimumVersionIfNotDefault(n.getValidationLevel() != ValidationLevel.STEADY_STATE_HYPOTHESIS, "network", MINIMUM_VALIDATION_LEVEL, IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_7, context.getVersion());
        context.getWriter().writeStartNode(context.getNamespaceURI(), "network");
        NetworkSerDe.writeMainAttributes(n, context);
    }

    private static Map<String, String> getExtensionVersions(Network n, ExportOptions options) {
        LinkedHashMap<String, String> extensionVersionsMap = new LinkedHashMap<String, String>();
        for (ExtensionSerDe<?, ?> extensionSerDe : NetworkSerDe.getExtensionSerializers(n, options)) {
            String version = NetworkSerDe.getExtensionVersion(extensionSerDe, options);
            extensionVersionsMap.put(extensionSerDe.getExtensionName(), version);
        }
        return extensionVersionsMap;
    }

    private static String getExtensionVersion(ExtensionSerDe<?, ?> extensionSerDe, ExportOptions options) {
        Optional<String> specifiedVersion = options.getExtensionVersion(extensionSerDe.getExtensionName());
        if (extensionSerDe instanceof AbstractVersionableNetworkExtensionSerDe) {
            AbstractVersionableNetworkExtensionSerDe versionable = (AbstractVersionableNetworkExtensionSerDe)extensionSerDe;
            return specifiedVersion.filter(v -> versionable.checkWritingCompatibility((String)v, options.getVersion())).orElseGet(() -> versionable.getVersion(options.getVersion()));
        }
        return specifiedVersion.orElseGet(() -> extensionSerDe.getVersion());
    }

    private static Set<ExtensionSerDe<?, ?>> getExtensionSerializers(Network n, ExportOptions options) {
        if (options.withNoExtension()) {
            return Collections.emptySet();
        }
        IidmVersion networkVersion = options.getVersion();
        return n.getIdentifiables().stream().flatMap(identifiable -> identifiable.getExtensions().stream().map(extension -> NetworkSerDe.getExtensionSerializer(options, extension)).filter(exs -> NetworkSerDe.canTheExtensionBeWritten(exs, networkVersion, options))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static void checkNamespaceCollisions(ExportOptions options, Set<ExtensionSerDe<?, ?>> serializers) {
        HashSet<String> extensionUris = new HashSet<String>();
        HashSet<String> extensionPrefixes = new HashSet<String>();
        for (ExtensionSerDe<?, ?> extensionSerDe : serializers) {
            String namespaceUri = NetworkSerDe.getNamespaceUri(extensionSerDe, options);
            if (extensionUris.contains(namespaceUri)) {
                throw new PowsyblException("Extension namespace URI collision");
            }
            extensionUris.add(namespaceUri);
            if (extensionPrefixes.contains(extensionSerDe.getNamespacePrefix())) {
                throw new PowsyblException("Extension namespace prefix collision");
            }
            extensionPrefixes.add(extensionSerDe.getNamespacePrefix());
        }
    }

    private static void writeBaseNetwork(Network n, NetworkSerializerContext context) {
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_7, context, () -> context.getWriter().writeEnumAttribute(MINIMUM_VALIDATION_LEVEL, (Enum)n.getValidationLevel()));
        AliasesSerDe.write(n, "network", context);
        PropertiesSerDe.write(n, context);
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_11, context, () -> NetworkSerDe.writeSubnetworks(n, context));
        NetworkSerDe.writeVoltageLevels(n, context);
        NetworkSerDe.writeSubstations(n, context);
        NetworkSerDe.writeLines(n, context);
        NetworkSerDe.writeTieLines(n, context);
        NetworkSerDe.writeHvdcLines(n, context);
    }

    private static void writeSubnetworks(Network n, NetworkSerializerContext context) {
        context.getWriter().writeStartNodes();
        for (Network subnetwork : IidmSerDeUtil.sorted(n.getSubnetworks(), context.getOptions())) {
            IidmSerDeUtil.assertMinimumVersion("network", "voltageLevel", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_11, context);
            NetworkSerDe.write(subnetwork, context);
        }
        context.getWriter().writeEndNodes();
    }

    private static void writeVoltageLevels(Network n, NetworkSerializerContext context) {
        context.getWriter().writeStartNodes();
        for (VoltageLevel voltageLevel : IidmSerDeUtil.sorted(n.getVoltageLevels(), context.getOptions())) {
            if (!NetworkSerDe.isElementWrittenInsideNetwork(voltageLevel, n, context) || !voltageLevel.getSubstation().isEmpty()) continue;
            IidmSerDeUtil.assertMinimumVersion("network", "voltageLevel", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_6, context);
            VoltageLevelSerDe.INSTANCE.write(voltageLevel, n, context);
        }
        context.getWriter().writeEndNodes();
    }

    private static void writeSubstations(Network n, NetworkSerializerContext context) {
        context.getWriter().writeStartNodes();
        for (Substation s : IidmSerDeUtil.sorted(n.getSubstations(), context.getOptions())) {
            if (!NetworkSerDe.isElementWrittenInsideNetwork(s, n, context)) continue;
            SubstationSerDe.INSTANCE.write(s, n, context);
        }
        context.getWriter().writeEndNodes();
    }

    private static void writeLines(Network n, NetworkSerializerContext context) {
        BusFilter filter = context.getFilter();
        context.getWriter().writeStartNodes();
        for (Line l : IidmSerDeUtil.sorted(n.getLines(), context.getOptions())) {
            if (!NetworkSerDe.isElementWrittenInsideNetwork(l, n, context) || !filter.test((Connectable<?>)l)) continue;
            LineSerDe.INSTANCE.write(l, n, context);
        }
        context.getWriter().writeEndNodes();
    }

    private static void writeTieLines(Network n, NetworkSerializerContext context) {
        BusFilter filter = context.getFilter();
        context.getWriter().writeStartNodes();
        for (TieLine l : IidmSerDeUtil.sorted(n.getTieLines(), context.getOptions())) {
            if (!NetworkSerDe.isElementWrittenInsideNetwork(l, n, context) || !filter.test(l)) continue;
            TieLineSerDe.INSTANCE.write(l, n, context);
        }
        context.getWriter().writeEndNodes();
    }

    private static void writeHvdcLines(Network n, NetworkSerializerContext context) {
        BusFilter filter = context.getFilter();
        context.getWriter().writeStartNodes();
        for (HvdcLine l : IidmSerDeUtil.sorted(n.getHvdcLines(), context.getOptions())) {
            if (!NetworkSerDe.isElementWrittenInsideNetwork(l, n, context) || !filter.test((Connectable<?>)l.getConverterStation1()) || !filter.test((Connectable<?>)l.getConverterStation2())) continue;
            HvdcLineSerDe.INSTANCE.write(l, n, context);
        }
        context.getWriter().writeEndNodes();
    }

    private static TreeDataWriter createTreeDataWriter(Network n, ExportOptions options, OutputStream os) {
        return switch (options.getFormat()) {
            default -> throw new IncompatibleClassChangeError();
            case TreeDataFormat.XML -> NetworkSerDe.createXmlWriter(n, os, options);
            case TreeDataFormat.JSON -> NetworkSerDe.createJsonWriter(os, options);
            case TreeDataFormat.BIN -> NetworkSerDe.createBinWriter(os, options);
        };
    }

    private static void write(Network network, NetworkSerializerContext context) {
        context.addExportedEquipment((Identifiable<?>)network);
        NetworkSerDe.writeRootElement(network, context);
        NetworkSerDe.writeBaseNetwork(network, context);
        NetworkSerDe.writeVoltageAngleLimits(network, context);
        NetworkSerDe.writeExtensions(network, context);
        context.getWriter().writeEndNode();
    }

    public static Anonymizer write(Network n, ExportOptions options, OutputStream os) {
        try (TreeDataWriter writer = NetworkSerDe.createTreeDataWriter(n, options, os);){
            NetworkSerializerContext context = NetworkSerDe.createContext(n, options, writer);
            writer.setVersions(NetworkSerDe.getExtensionVersions(n, options));
            NetworkSerDe.write(n, context);
            Anonymizer anonymizer = context.getAnonymizer();
            return anonymizer;
        }
    }

    private static boolean isElementWrittenInsideNetwork(Identifiable<?> element, Network n, NetworkSerializerContext context) {
        if (!NetworkSerDe.supportSubnetworksExport(context)) {
            return true;
        }
        if (n.getId().equals(element.getId())) {
            return true;
        }
        return element.getParentNetwork() == n && element.getType() != IdentifiableType.NETWORK;
    }

    private static boolean supportSubnetworksExport(NetworkSerializerContext context) {
        return context.getVersion().compareTo(IidmVersion.V_1_11) >= 0;
    }

    private static NetworkSerializerContext createContext(Network n, ExportOptions options, TreeDataWriter writer) {
        BusFilter filter = BusFilter.create(n, options);
        SimpleAnonymizer anonymizer = options.isAnonymized() ? new SimpleAnonymizer() : null;
        return new NetworkSerializerContext(anonymizer, writer, options, filter, options.getVersion(), n.getValidationLevel() == ValidationLevel.STEADY_STATE_HYPOTHESIS);
    }

    public static Anonymizer write(Network n, OutputStream os) {
        return NetworkSerDe.write(n, new ExportOptions(), os);
    }

    public static Anonymizer write(Network n, ExportOptions options, Path xmlFile) {
        Anonymizer anonymizer;
        BufferedOutputStream os = new BufferedOutputStream(Files.newOutputStream(xmlFile, new OpenOption[0]));
        try {
            anonymizer = NetworkSerDe.write(n, options, os);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((OutputStream)os).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        ((OutputStream)os).close();
        return anonymizer;
    }

    public static Anonymizer write(Network n, Path xmlFile) {
        return NetworkSerDe.write(n, new ExportOptions(), xmlFile);
    }

    public static Anonymizer write(Network network, ExportOptions options, DataSource dataSource, String dataSourceExt) throws IOException {
        try (OutputStream osb = dataSource.newOutputStream("", dataSourceExt, false);){
            Anonymizer anonymizer;
            try (BufferedOutputStream bosb = new BufferedOutputStream(osb);){
                Anonymizer anonymizer2 = NetworkSerDe.write(network, options, bosb);
                if (options.isAnonymized()) {
                    try (BufferedWriter writer2 = new BufferedWriter(new OutputStreamWriter(dataSource.newOutputStream("_mapping", "csv", false), StandardCharsets.UTF_8));){
                        anonymizer2.write(writer2);
                    }
                }
                anonymizer = anonymizer2;
            }
            return anonymizer;
        }
    }

    public static Network read(InputStream is) {
        return NetworkSerDe.read(is, new ImportOptions(), null);
    }

    public static Network read(InputStream is, ImportOptions config, Anonymizer anonymizer) {
        return NetworkSerDe.read(is, config, anonymizer, NetworkFactory.findDefault(), ReportNode.NO_OP);
    }

    public static Network read(InputStream is, ImportOptions config, Anonymizer anonymizer, NetworkFactory networkFactory, ReportNode reportNode) {
        try (TreeDataReader reader = NetworkSerDe.createTreeDataReader(is, config);){
            Network network = NetworkSerDe.read(reader, config, anonymizer, networkFactory, reportNode);
            return network;
        }
    }

    private static TreeDataReader createTreeDataReader(InputStream is, ImportOptions config) {
        return switch (config.getFormat()) {
            default -> throw new IncompatibleClassChangeError();
            case TreeDataFormat.XML -> NetworkSerDe.createXmlReader(is, config);
            case TreeDataFormat.JSON -> NetworkSerDe.createJsonReader(is, config);
            case TreeDataFormat.BIN -> new BinReader(is, BIIDM_MAGIC_NUMBER);
        };
    }

    private static TreeDataReader createJsonReader(InputStream is, ImportOptions config) {
        try {
            return new JsonReader(is, "network", NetworkSerDe.createArrayNameToSingleNameMap(config));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static TreeDataReader createXmlReader(InputStream is, ImportOptions config) {
        try {
            return new XmlReader(is, NetworkSerDe.getNamespaceVersionMap(), config.withNoExtension() ? Collections.emptyList() : EXTENSIONS_SUPPLIER.get().getProviders());
        }
        catch (XMLStreamException e) {
            throw new UncheckedXmlStreamException(e);
        }
    }

    private static Map<String, String> createSingleNameToArrayNameMap(ExportOptions config) {
        return NetworkSerDe.createArrayNameSingleNameBiMap(!config.withNoExtension()).inverse();
    }

    private static Map<String, String> createArrayNameToSingleNameMap(ImportOptions config) {
        return NetworkSerDe.createArrayNameSingleNameBiMap(!config.withNoExtension());
    }

    private static BiMap<String, String> createArrayNameSingleNameBiMap(boolean withExtensions) {
        Map basicMap = Map.ofEntries(Map.entry(NETWORK_ARRAY_ELEMENT_NAME, "network"), Map.entry(EXTENSION_ARRAY_ELEMENT_NAME, EXTENSION_ROOT_ELEMENT_NAME), Map.entry("switches", "switch"), Map.entry("steps", "step"), Map.entry("aliases", "alias"), Map.entry("batteries", "battery"), Map.entry("buses", "bus"), Map.entry("busbarSections", "busbarSection"), Map.entry("temporaryLimits", "temporaryLimit"), Map.entry("danglingLines", "danglingLine"), Map.entry("generators", "generator"), Map.entry("hvdcLines", "hvdcLine"), Map.entry("lccConverterStations", "lccConverterStation"), Map.entry("lines", "line"), Map.entry("loads", "load"), Map.entry("internalConnections", "internalConnection"), Map.entry("overloadManagementSystems", "overloadManagementSystem"), Map.entry("properties", "property"), Map.entry("points", "point"), Map.entry("shunts", "shunt"), Map.entry("sections", "section"), Map.entry("staticVarCompensators", "staticVarCompensator"), Map.entry("substations", "substation"), Map.entry("threeWindingsTransformers", "threeWindingsTransformer"), Map.entry("tieLines", "tieLine"), Map.entry("twoWindingsTransformers", "twoWindingsTransformer"), Map.entry("voltageAngleLimits", "voltageAngleLimit"), Map.entry("voltageLevels", "voltageLevel"), Map.entry("fictitiousInjections", "inj"), Map.entry("vscConverterStations", "vscConverterStation"), Map.entry("grounds", "ground"), Map.entry("operationalLimitsGroups", "operationalLimitsGroup"), Map.entry("operationalLimitsGroups1", "operationalLimitsGroup1"), Map.entry("operationalLimitsGroups2", "operationalLimitsGroup2"), Map.entry("operationalLimitsGroups3", "operationalLimitsGroup3"));
        HashMap extensionsMap = new HashMap();
        if (withExtensions) {
            for (ExtensionSerDe e : EXTENSIONS_SUPPLIER.get().getProviders()) {
                extensionsMap.putAll(e.getArrayNameToSingleNameMap());
            }
        }
        HashBiMap biMergedMap = HashBiMap.create();
        biMergedMap.putAll(basicMap);
        biMergedMap.putAll(extensionsMap);
        return biMergedMap;
    }

    private static Map<String, String> getNamespaceVersionMap() {
        HashMap<String, String> namespaceVersionMap = new HashMap<String, String>();
        Arrays.stream(IidmVersion.values()).forEach(v -> namespaceVersionMap.put(v.getNamespaceURI(), v.toString(".")));
        Arrays.stream(IidmVersion.values()).filter(IidmVersion::supportEquipmentValidationLevel).forEach(v -> namespaceVersionMap.put(v.getNamespaceURI(false), v.toString(".")));
        return namespaceVersionMap;
    }

    private static void readNetworkElement(String elementName, Deque<Network> networks, NetworkFactory networkFactory, NetworkDeserializerContext context, Set<String> extensionNamesImported, Set<String> extensionNamesNotFound) {
        switch (elementName) {
            case "alias": {
                NetworkSerDe.checkSupportedAndReadAlias(networks.peek(), context);
                break;
            }
            case "property": {
                PropertiesSerDe.read((Identifiable)networks.peek(), context);
                break;
            }
            case "network": {
                NetworkSerDe.checkSupportedAndReadSubnetwork(networks, networkFactory, context, extensionNamesImported, extensionNamesNotFound);
                break;
            }
            case "voltageLevel": {
                NetworkSerDe.checkSupportedAndReadVoltageLevel(context, networks);
                break;
            }
            case "substation": {
                SubstationSerDe.INSTANCE.read(networks.peek(), context);
                break;
            }
            case "line": {
                LineSerDe.INSTANCE.read(networks.peek(), context);
                break;
            }
            case "tieLine": {
                TieLineSerDe.INSTANCE.read(networks.peek(), context);
                break;
            }
            case "hvdcLine": {
                HvdcLineSerDe.INSTANCE.read(networks.peek(), context);
                break;
            }
            case "voltageAngleLimit": {
                VoltageAngleLimitSerDe.read(networks.peek(), context);
                break;
            }
            case "extension": {
                NetworkSerDe.findExtendableAndReadExtension(networks.getFirst(), context, extensionNamesImported, extensionNamesNotFound);
                break;
            }
            default: {
                throw new PowsyblException("Unknown element name '" + elementName + "' in 'network'");
            }
        }
    }

    private static void checkSupportedAndReadAlias(Network network, NetworkDeserializerContext context) {
        IidmSerDeUtil.assertMinimumVersion("network", "alias", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_3, context);
        AliasesSerDe.read(network, context);
    }

    private static void checkSupportedAndReadSubnetwork(Deque<Network> networks, NetworkFactory networkFactory, NetworkDeserializerContext context, Set<String> extensionNamesImported, Set<String> extensionNamesNotFound) {
        IidmSerDeUtil.assertMinimumVersion("network", "network", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_11, context);
        if (networks.size() > 1) {
            throw new PowsyblException("Only one level of subnetworks is currently supported.");
        }
        Network subnetwork = NetworkSerDe.initNetwork(networkFactory, context, context.getReader(), networks.peek());
        networks.push(subnetwork);
        context.getReader().readChildNodes(elementName -> NetworkSerDe.readNetworkElement(elementName, networks, networkFactory, context, extensionNamesImported, extensionNamesNotFound));
        networks.pop();
    }

    private static void checkSupportedAndReadVoltageLevel(NetworkDeserializerContext context, Deque<Network> networks) {
        IidmSerDeUtil.assertMinimumVersion("network", "voltageLevel", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_6, context);
        VoltageLevelSerDe.INSTANCE.read((Container)networks.peek(), context);
    }

    private static void findExtendableAndReadExtension(Network network, NetworkDeserializerContext context, Set<String> extensionNamesImported, Set<String> extensionNamesNotFound) {
        String id2 = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute(ID));
        Identifiable identifiable = network.getIdentifiable(id2);
        if (identifiable == null) {
            throw new PowsyblException("Identifiable " + id2 + " not found");
        }
        NetworkSerDe.readExtensions(identifiable, context, extensionNamesImported, extensionNamesNotFound);
    }

    private static Network initNetwork(NetworkFactory networkFactory, NetworkDeserializerContext context, TreeDataReader reader, Network rootNetwork) {
        ValidationLevel minValidationLevel;
        String id = context.getAnonymizer().deanonymizeString(reader.readStringAttribute(ID));
        ZonedDateTime date = ZonedDateTime.parse(reader.readStringAttribute(CASE_DATE));
        int forecastDistance = reader.readIntAttribute(FORECAST_DISTANCE, 0);
        String sourceFormat = reader.readStringAttribute(SOURCE_FORMAT);
        Network network = rootNetwork == null ? networkFactory.createNetwork(id, sourceFormat) : rootNetwork.createSubnetwork(id, id, sourceFormat);
        network.setCaseDate(date);
        network.setForecastDistance(forecastDistance);
        Optional<ValidationLevel> optMinimalValidationLevel = context.getOptions().getMinimalValidationLevel();
        if (optMinimalValidationLevel.isPresent()) {
            minValidationLevel = optMinimalValidationLevel.get();
            IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_7, context, () -> reader.readEnumAttribute(MINIMUM_VALIDATION_LEVEL, ValidationLevel.class));
        } else {
            ValidationLevel[] fileMinValidationLevel = new ValidationLevel[]{ValidationLevel.STEADY_STATE_HYPOTHESIS};
            IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_7, context, () -> {
                fileMinValidationLevel[0] = (ValidationLevel)reader.readEnumAttribute(MINIMUM_VALIDATION_LEVEL, ValidationLevel.class);
            });
            IidmSerDeUtil.assertMinimumVersionIfNotDefault(fileMinValidationLevel[0] != ValidationLevel.STEADY_STATE_HYPOTHESIS, "network", MINIMUM_VALIDATION_LEVEL, IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_7, context);
            minValidationLevel = fileMinValidationLevel[0];
            context.setNetworkValidationLevel(minValidationLevel);
        }
        network.setMinimumAcceptableValidationLevel(minValidationLevel);
        return network;
    }

    private static void logExtensionsImported(ReportNode reportNode, Set<String> extensionNamesImported) {
        DeserializerReports.importedExtension(reportNode, extensionNamesImported);
    }

    private static void logExtensionsNotFound(ReportNode reportNode, Set<String> extensionNamesNotFound) {
        DeserializerReports.extensionNotFound(reportNode, extensionNamesNotFound);
    }

    public static Network read(TreeDataReader reader, ImportOptions config, Anonymizer anonymizer, NetworkFactory networkFactory, ReportNode reportNode) {
        Objects.requireNonNull(reader);
        Objects.requireNonNull(networkFactory);
        Objects.requireNonNull(reportNode);
        TreeDataHeader header = reader.readHeader();
        IidmVersion iidmVersion = IidmVersion.of(header.rootVersion(), ".");
        NetworkDeserializerContext context = new NetworkDeserializerContext(anonymizer, reader, config, iidmVersion, header.extensionVersions());
        Network network = NetworkSerDe.initNetwork(networkFactory, context, reader, null);
        network.getReportNodeContext().pushReportNode(reportNode);
        TreeSet<String> extensionNamesImported = new TreeSet<String>();
        TreeSet<String> extensionNamesNotFound = new TreeSet<String>();
        ArrayDeque<Network> networks = new ArrayDeque<Network>(2);
        networks.push(network);
        ReportNode validationReportNode = ((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("validationWarnings", "Validation warnings")).add();
        reader.readChildNodes(elementName -> NetworkSerDe.readNetworkElement(elementName, networks, networkFactory, context, extensionNamesImported, extensionNamesNotFound));
        if (!extensionNamesImported.isEmpty()) {
            ReportNode importedExtensionReportNode = ((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("importedExtensions", "Imported extensions")).add();
            NetworkSerDe.logExtensionsImported(importedExtensionReportNode, extensionNamesImported);
        }
        if (!extensionNamesNotFound.isEmpty()) {
            ReportNode extensionsNotFoundReportNode = ((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("extensionsNotFound", "Not found extensions")).add();
            NetworkSerDe.throwExceptionIfOption(context.getOptions(), "Extensions " + extensionNamesNotFound + " not found !");
            NetworkSerDe.logExtensionsNotFound(extensionsNotFoundReportNode, extensionNamesNotFound);
        }
        context.executeEndTasks(network, validationReportNode);
        return network;
    }

    public static Network read(Path xmlFile) {
        return NetworkSerDe.read(xmlFile, new ImportOptions());
    }

    public static Network read(ReadOnlyDataSource dataSource, NetworkFactory networkFactory, ImportOptions options, String dataSourceExt, ReportNode reportNode) throws IOException {
        Network network;
        Objects.requireNonNull(dataSource);
        Objects.requireNonNull(reportNode);
        SimpleAnonymizer anonymizer = null;
        if (dataSource.exists("_mapping", "csv")) {
            anonymizer = new SimpleAnonymizer();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(dataSource.newInputStream("_mapping", "csv"), StandardCharsets.UTF_8));){
                anonymizer.read(reader);
            }
        }
        try (InputStream isb = dataSource.newInputStream(null, dataSourceExt);){
            network = NetworkSerDe.read(isb, options, (Anonymizer)anonymizer, networkFactory, reportNode);
        }
        return network;
    }

    public static Network read(Path xmlFile, ImportOptions options) {
        Network network;
        block8: {
            InputStream is = Files.newInputStream(xmlFile, new OpenOption[0]);
            try {
                network = NetworkSerDe.read(is, options, null);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            is.close();
        }
        return network;
    }

    public static Network validateAndRead(Path xmlFile, ImportOptions options) {
        if (options.getFormat() == TreeDataFormat.XML) {
            NetworkSerDe.validate(xmlFile);
        } else {
            LOGGER.warn("Non-XML file {} (format {}) could not be validated", (Object)xmlFile, (Object)options.getFormat());
        }
        return NetworkSerDe.read(xmlFile, options);
    }

    public static Network validateAndRead(Path xmlFile) {
        return NetworkSerDe.validateAndRead(xmlFile, new ImportOptions());
    }

    private static void readExtensions(Identifiable identifiable, NetworkDeserializerContext context, Set<String> extensionNamesImported, Set<String> extensionNamesNotFound) {
        context.getReader().readChildNodes(extensionName -> {
            if (context.getOptions().withExtension(extensionName)) {
                ExtensionSerDe extensionXmlSerializer = (ExtensionSerDe)EXTENSIONS_SUPPLIER.get().findProvider(extensionName);
                if (extensionXmlSerializer != null) {
                    Extension extension = extensionXmlSerializer.read((Extendable)identifiable, (DeserializerContext)context);
                    identifiable.addExtension(extensionXmlSerializer.getExtensionClass(), extension);
                    extensionNamesImported.add(extensionName);
                } else {
                    extensionNamesNotFound.add(extensionName);
                    context.getReader().skipChildNodes();
                }
            } else {
                context.getReader().skipChildNodes();
            }
        });
    }

    public static byte[] gzip(Network network) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try (GZIPOutputStream gzos = new GZIPOutputStream(bos);){
            NetworkSerDe.write(network, gzos);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return bos.toByteArray();
    }

    public static Network gunzip(byte[] networkXmlGz) {
        Network network;
        GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(networkXmlGz));
        try {
            network = NetworkSerDe.read(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        ((InputStream)is).close();
        return network;
    }

    public static Network copy(Network network) {
        return NetworkSerDe.copy(network, NetworkFactory.findDefault());
    }

    public static Network copy(Network network, NetworkFactory networkFactory) {
        return NetworkSerDe.copy(network, networkFactory, ForkJoinPool.commonPool());
    }

    public static Network copy(Network network, NetworkFactory networkFactory, ExecutorService executor) {
        Network network2;
        Objects.requireNonNull(network);
        Objects.requireNonNull(networkFactory);
        Objects.requireNonNull(executor);
        PipedOutputStream pos = new PipedOutputStream();
        PipedInputStream is = new PipedInputStream(pos);
        try {
            executor.execute(() -> {
                try {
                    NetworkSerDe.write(network, pos);
                }
                catch (Exception t) {
                    LOGGER.error(t.toString(), (Throwable)t);
                }
                finally {
                    try {
                        pos.close();
                    }
                    catch (IOException e) {
                        LOGGER.error(e.toString(), (Throwable)e);
                    }
                }
            });
            network2 = NetworkSerDe.read(is, new ImportOptions(), null, networkFactory, ReportNode.NO_OP);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        ((InputStream)is).close();
        return network2;
    }
}

