/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.Boundary;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineAdder;
import com.powsybl.iidm.network.FlowsLimitsHolder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TieLine;
import com.powsybl.iidm.network.TieLineAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.serde.AbstractSimpleIdentifiableSerDe;
import com.powsybl.iidm.serde.ConnectableSerDeUtil;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;
import java.util.OptionalDouble;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TieLineSerDe
extends AbstractSimpleIdentifiableSerDe<TieLine, TieLineAdder, Network> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TieLineSerDe.class);
    static final TieLineSerDe INSTANCE = new TieLineSerDe();
    static final String ROOT_ELEMENT_NAME = "tieLine";
    static final String ARRAY_ELEMENT_NAME = "tieLines";

    TieLineSerDe() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    private static void writeDanglingLine(DanglingLine danglingLine, NetworkSerializerContext context, int side) {
        Boundary boundary = danglingLine.getBoundary();
        context.getWriter().writeStringAttribute("id_" + side, context.getAnonymizer().anonymizeString(danglingLine.getId()));
        context.getWriter().writeStringAttribute("name_" + side, (String)danglingLine.getOptionalName().map(n -> context.getAnonymizer().anonymizeString((String)n)).orElse(null));
        context.getWriter().writeDoubleAttribute("r_" + side, danglingLine.getR());
        context.getWriter().writeDoubleAttribute("x_" + side, danglingLine.getX());
        context.getWriter().writeDoubleAttribute("g1_" + side, danglingLine.getG() / 2.0);
        context.getWriter().writeDoubleAttribute("b1_" + side, danglingLine.getB() / 2.0);
        context.getWriter().writeDoubleAttribute("g2_" + side, danglingLine.getG() / 2.0);
        context.getWriter().writeDoubleAttribute("b2_" + side, danglingLine.getB() / 2.0);
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_4, context, () -> {
            context.getWriter().writeDoubleAttribute("xnodeP_" + side, boundary.getP());
            context.getWriter().writeDoubleAttribute("xnodeQ_" + side, boundary.getQ());
        });
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_3, context, () -> context.getWriter().writeBooleanAttribute("fictitious_" + side, danglingLine.isFictitious(), false));
    }

    @Override
    protected void writeRootElementAttributes(TieLine tl, Network n, NetworkSerializerContext context) {
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_10, context, () -> {
            context.getWriter().writeStringAttribute("danglingLineId1", context.getAnonymizer().anonymizeString(tl.getDanglingLine1().getId()));
            context.getWriter().writeStringAttribute("danglingLineId2", context.getAnonymizer().anonymizeString(tl.getDanglingLine2().getId()));
        });
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_9, context, () -> {
            if (tl.getPairingKey() != null) {
                context.getWriter().writeStringAttribute("ucteXnodeCode", tl.getPairingKey());
            }
            ConnectableSerDeUtil.writeNodeOrBus(1, tl.getDanglingLine1().getTerminal(), context);
            ConnectableSerDeUtil.writeNodeOrBus(2, tl.getDanglingLine2().getTerminal(), context);
            ConnectableSerDeUtil.writeOptionalPQ(1, tl.getDanglingLine1().getTerminal(), context.getWriter(), context.getOptions()::isWithBranchSV);
            ConnectableSerDeUtil.writeOptionalPQ(2, tl.getDanglingLine2().getTerminal(), context.getWriter(), context.getOptions()::isWithBranchSV);
            TieLineSerDe.writeDanglingLine(tl.getDanglingLine1(), context, 1);
            TieLineSerDe.writeDanglingLine(tl.getDanglingLine2(), context, 2);
        });
    }

    @Override
    protected void writeSubElements(TieLine tl, Network n, NetworkSerializerContext context) {
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_9, context, () -> {
            ConnectableSerDeUtil.writeLimits(context, 1, ROOT_ELEMENT_NAME, tl.getSelectedOperationalLimitsGroup1().orElse(null), tl.getOperationalLimitsGroups1());
            ConnectableSerDeUtil.writeLimits(context, 2, ROOT_ELEMENT_NAME, tl.getSelectedOperationalLimitsGroup2().orElse(null), tl.getOperationalLimitsGroups2());
        });
    }

    @Override
    protected TieLineAdder createAdder(Network n) {
        return n.newTieLine();
    }

    private static DanglingLine readDanglingLine(DanglingLineAdder adder, String pairingKey, NetworkDeserializerContext context, int side) {
        String id = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute("id_" + side));
        String name = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute("name_" + side));
        double r = context.getReader().readDoubleAttribute("r_" + side);
        double x = context.getReader().readDoubleAttribute("x_" + side);
        double g1 = context.getReader().readDoubleAttribute("g1_" + side);
        double b1 = context.getReader().readDoubleAttribute("b1_" + side);
        double g2 = context.getReader().readDoubleAttribute("g2_" + side);
        double b2 = context.getReader().readDoubleAttribute("b2_" + side);
        ((DanglingLineAdder)((DanglingLineAdder)adder.setId(id)).setName(name)).setPairingKey(pairingKey).setR(r).setX(x).setG(g1 + g2).setB(b1 + b2).setP0(0.0).setQ0(0.0);
        double[] halfBoundaryP = new double[1];
        double[] halfBoundaryQ = new double[1];
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_4, context, () -> {
            halfBoundaryP[0] = context.getReader().readDoubleAttribute("xnodeP_" + side);
            halfBoundaryQ[0] = context.getReader().readDoubleAttribute("xnodeQ_" + side);
        });
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_3, context, () -> {
            boolean fictitious = context.getReader().readBooleanAttribute("fictitious_" + side, false);
            adder.setFictitious(fictitious);
        });
        DanglingLine dl = adder.add();
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_4, context, () -> {
            TieLineSerDe.checkBoundaryValue(halfBoundaryP[0], dl.getBoundary().getP(), "xnodeP_" + side, pairingKey);
            TieLineSerDe.checkBoundaryValue(halfBoundaryQ[0], dl.getBoundary().getQ(), "xnodeQ_" + side, pairingKey);
        });
        return dl;
    }

    @Override
    protected TieLine readRootElementAttributes(TieLineAdder adder, Network network, NetworkDeserializerContext context) {
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_9, context, () -> {
            String pairingKey = context.getReader().readStringAttribute("ucteXnodeCode");
            DanglingLineAdder adderDl1 = TieLineSerDe.readVlAndNodeOrBus(context, network, 1);
            DanglingLineAdder adderDl2 = TieLineSerDe.readVlAndNodeOrBus(context, network, 2);
            OptionalDouble p1 = context.getReader().readOptionalDoubleAttribute("p1");
            OptionalDouble q1 = context.getReader().readOptionalDoubleAttribute("q1");
            OptionalDouble p2 = context.getReader().readOptionalDoubleAttribute("p2");
            OptionalDouble q2 = context.getReader().readOptionalDoubleAttribute("q2");
            DanglingLine dl1 = TieLineSerDe.readDanglingLine(adderDl1, pairingKey, context, 1);
            DanglingLine dl2 = TieLineSerDe.readDanglingLine(adderDl2, pairingKey, context, 2);
            p1.ifPresent(arg_0 -> ((Terminal)dl1.getTerminal()).setP(arg_0));
            q1.ifPresent(arg_0 -> ((Terminal)dl1.getTerminal()).setQ(arg_0));
            p2.ifPresent(arg_0 -> ((Terminal)dl2.getTerminal()).setP(arg_0));
            q2.ifPresent(arg_0 -> ((Terminal)dl2.getTerminal()).setQ(arg_0));
            adder.setDanglingLine1(dl1.getId()).setDanglingLine2(dl2.getId());
        });
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_10, context, () -> {
            String dl1Id = context.getReader().readStringAttribute("danglingLineId1");
            String dl2Id = context.getReader().readStringAttribute("danglingLineId2");
            adder.setDanglingLine1(dl1Id).setDanglingLine2(dl2Id);
        });
        return adder.add();
    }

    private static DanglingLineAdder readVlAndNodeOrBus(NetworkDeserializerContext context, Network network, int side) {
        String voltageLevelId = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute("voltageLevelId" + side));
        VoltageLevel voltageLevel = network.getVoltageLevel(voltageLevelId);
        DanglingLineAdder adderDl1 = voltageLevel.newDanglingLine();
        ConnectableSerDeUtil.readNodeOrBus(adderDl1, String.valueOf(side), context, voltageLevel.getTopologyKind());
        return adderDl1;
    }

    @Override
    protected void readSubElements(TieLine tl, NetworkDeserializerContext context) {
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "operationalLimitsGroup1": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "operationalLimitsGroup1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_12, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> ConnectableSerDeUtil.readLoadingLimitsGroups((FlowsLimitsHolder)tl.getDanglingLine1(), "operationalLimitsGroup1", context));
                    break;
                }
                case "activePowerLimits1": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.assertMaximumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_9, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readActivePowerLimits(tl.getDanglingLine1().newActivePowerLimits(), context));
                    break;
                }
                case "apparentPowerLimits1": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.assertMaximumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_9, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readApparentPowerLimits(tl.getDanglingLine1().newApparentPowerLimits(), context));
                    break;
                }
                case "currentLimits1": {
                    IidmSerDeUtil.assertMaximumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_9, context);
                    ConnectableSerDeUtil.readCurrentLimits(tl.getDanglingLine1().newCurrentLimits(), context);
                    break;
                }
                case "operationalLimitsGroup2": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "operationalLimitsGroup2", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_12, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> ConnectableSerDeUtil.readLoadingLimitsGroups((FlowsLimitsHolder)tl.getDanglingLine2(), "operationalLimitsGroup2", context));
                    break;
                }
                case "activePowerLimits2": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits2", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.assertMaximumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_9, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readActivePowerLimits(tl.getDanglingLine2().newActivePowerLimits(), context));
                    break;
                }
                case "apparentPowerLimits2": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits2", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.assertMaximumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_9, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readApparentPowerLimits(tl.getDanglingLine2().newApparentPowerLimits(), context));
                    break;
                }
                case "currentLimits2": {
                    IidmSerDeUtil.assertMaximumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_9, context);
                    ConnectableSerDeUtil.readCurrentLimits(tl.getDanglingLine2().newCurrentLimits(), context);
                    break;
                }
                default: {
                    this.readSubElement(elementName, tl, context);
                }
            }
        });
    }

    private static void checkBoundaryValue(double imported, double calculated, String name, String ucteXnodeCode) {
        if (!Double.isNaN(imported) && imported != calculated) {
            LOGGER.info("{} of the TieLine with ucteXnodeCode {} is recalculated. Its imported value is not used (imported value = {}; calculated value = {})", new Object[]{name, ucteXnodeCode, imported, calculated});
        }
    }
}

