/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformerAdder;
import com.powsybl.iidm.serde.AbstractTransformerSerDe;
import com.powsybl.iidm.serde.ConnectableSerDeUtil;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;

class TwoWindingsTransformerSerDe
extends AbstractTransformerSerDe<TwoWindingsTransformer, TwoWindingsTransformerAdder> {
    static final TwoWindingsTransformerSerDe INSTANCE = new TwoWindingsTransformerSerDe();
    static final String ROOT_ELEMENT_NAME = "twoWindingsTransformer";
    static final String ARRAY_ELEMENT_NAME = "twoWindingsTransformers";

    TwoWindingsTransformerSerDe() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected void writeRootElementAttributes(TwoWindingsTransformer twt, Substation s, NetworkSerializerContext context) {
        context.getWriter().writeDoubleAttribute("r", twt.getR());
        context.getWriter().writeDoubleAttribute("x", twt.getX());
        context.getWriter().writeDoubleAttribute("g", twt.getG());
        context.getWriter().writeDoubleAttribute("b", twt.getB());
        context.getWriter().writeDoubleAttribute("ratedU1", twt.getRatedU1());
        context.getWriter().writeDoubleAttribute("ratedU2", twt.getRatedU2());
        TwoWindingsTransformerSerDe.writeRatedS("ratedS", twt.getRatedS(), context);
        ConnectableSerDeUtil.writeNodeOrBus(1, twt.getTerminal1(), context);
        ConnectableSerDeUtil.writeNodeOrBus(2, twt.getTerminal2(), context);
        ConnectableSerDeUtil.writeOptionalPQ(1, twt.getTerminal1(), context.getWriter(), context.getOptions()::isWithBranchSV);
        ConnectableSerDeUtil.writeOptionalPQ(2, twt.getTerminal2(), context.getWriter(), context.getOptions()::isWithBranchSV);
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> {
            ConnectableSerDeUtil.writeSelectedGroupId(1, twt.getSelectedOperationalLimitsGroupId1().orElse(null), context.getWriter());
            ConnectableSerDeUtil.writeSelectedGroupId(2, twt.getSelectedOperationalLimitsGroupId2().orElse(null), context.getWriter());
        });
    }

    @Override
    protected void writeSubElements(TwoWindingsTransformer twt, Substation s, NetworkSerializerContext context) {
        PhaseTapChanger ptc;
        RatioTapChanger rtc = twt.getRatioTapChanger();
        if (rtc != null) {
            TwoWindingsTransformerSerDe.writeRatioTapChanger("ratioTapChanger", rtc, context);
        }
        if ((ptc = twt.getPhaseTapChanger()) != null) {
            TwoWindingsTransformerSerDe.writePhaseTapChanger("phaseTapChanger", ptc, context);
        }
        ConnectableSerDeUtil.writeLimits(context, 1, ROOT_ELEMENT_NAME, twt.getSelectedOperationalLimitsGroup1().orElse(null), twt.getOperationalLimitsGroups1());
        ConnectableSerDeUtil.writeLimits(context, 2, ROOT_ELEMENT_NAME, twt.getSelectedOperationalLimitsGroup2().orElse(null), twt.getOperationalLimitsGroups2());
    }

    @Override
    protected TwoWindingsTransformerAdder createAdder(Substation s) {
        return s.newTwoWindingsTransformer();
    }

    @Override
    protected TwoWindingsTransformer readRootElementAttributes(TwoWindingsTransformerAdder adder, Substation s, NetworkDeserializerContext context) {
        double r = context.getReader().readDoubleAttribute("r");
        double x = context.getReader().readDoubleAttribute("x");
        double g = context.getReader().readDoubleAttribute("g");
        double b = context.getReader().readDoubleAttribute("b");
        double ratedU1 = context.getReader().readDoubleAttribute("ratedU1");
        double ratedU2 = context.getReader().readDoubleAttribute("ratedU2");
        adder.setR(r).setX(x).setG(g).setB(b).setRatedU1(ratedU1).setRatedU2(ratedU2);
        TwoWindingsTransformerSerDe.readRatedS("ratedS", context, arg_0 -> ((TwoWindingsTransformerAdder)adder).setRatedS(arg_0));
        ConnectableSerDeUtil.readVoltageLevelAndNodeOrBus(adder, s.getNetwork(), context);
        TwoWindingsTransformer twt = adder.add();
        ConnectableSerDeUtil.readOptionalPQ(1, twt.getTerminal1(), context.getReader());
        ConnectableSerDeUtil.readOptionalPQ(2, twt.getTerminal2(), context.getReader());
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> {
            ConnectableSerDeUtil.readSelectedGroupId(1, arg_0 -> ((TwoWindingsTransformer)twt).setSelectedOperationalLimitsGroup1(arg_0), context);
            ConnectableSerDeUtil.readSelectedGroupId(2, arg_0 -> ((TwoWindingsTransformer)twt).setSelectedOperationalLimitsGroup2(arg_0), context);
        });
        return twt;
    }

    @Override
    protected void readSubElements(TwoWindingsTransformer twt, NetworkDeserializerContext context) {
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "operationalLimitsGroup1": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "operationalLimitsGroup1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_12, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> ConnectableSerDeUtil.readLoadingLimitsGroup(arg_0 -> ((TwoWindingsTransformer)twt).newOperationalLimitsGroup1(arg_0), "operationalLimitsGroup1", context));
                    break;
                }
                case "activePowerLimits1": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readActivePowerLimits(twt.newActivePowerLimits1(), context));
                    break;
                }
                case "apparentPowerLimits1": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readApparentPowerLimits(twt.newApparentPowerLimits1(), context));
                    break;
                }
                case "currentLimits1": {
                    ConnectableSerDeUtil.readCurrentLimits(twt.newCurrentLimits1(), context);
                    break;
                }
                case "operationalLimitsGroup2": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "operationalLimitsGroup2", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_12, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> ConnectableSerDeUtil.readLoadingLimitsGroup(arg_0 -> ((TwoWindingsTransformer)twt).newOperationalLimitsGroup2(arg_0), "operationalLimitsGroup2", context));
                    break;
                }
                case "activePowerLimits2": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits2", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readActivePowerLimits(twt.newActivePowerLimits2(), context));
                    break;
                }
                case "apparentPowerLimits2": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits2", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readApparentPowerLimits(twt.newApparentPowerLimits2(), context));
                    break;
                }
                case "currentLimits2": {
                    ConnectableSerDeUtil.readCurrentLimits(twt.newCurrentLimits2(), context);
                    break;
                }
                case "ratioTapChanger": {
                    TwoWindingsTransformerSerDe.readRatioTapChanger(twt, context);
                    break;
                }
                case "phaseTapChanger": {
                    TwoWindingsTransformerSerDe.readPhaseTapChanger(twt, context);
                    break;
                }
                default: {
                    this.readSubElement(elementName, twt, context);
                }
            }
        });
    }
}

