/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.google.common.base.Joiner;
import com.google.common.base.Suppliers;
import com.google.common.io.ByteStreams;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.config.PlatformConfig;
import com.powsybl.commons.datasource.DataSource;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.extensions.ExtensionProvider;
import com.powsybl.commons.extensions.ExtensionProviders;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.parameters.Parameter;
import com.powsybl.commons.parameters.ParameterDefaultValueConfig;
import com.powsybl.commons.parameters.ParameterType;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.commons.report.ReportNodeAdder;
import com.powsybl.iidm.network.Importer;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.serde.DeserializerReports;
import com.powsybl.iidm.serde.ImportOptions;
import com.powsybl.iidm.serde.NetworkSerDe;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTreeDataImporter
implements Importer {
    private static final Supplier<ExtensionProviders<ExtensionSerDe>> EXTENSIONS_SUPPLIER = Suppliers.memoize(() -> ExtensionProviders.createProvider(ExtensionSerDe.class, (String)"network"));
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTreeDataImporter.class);
    public static final String THROW_EXCEPTION_IF_EXTENSION_NOT_FOUND = "iidm.import.xml.throw-exception-if-extension-not-found";
    public static final String EXTENSIONS_LIST = "iidm.import.xml.extensions";
    public static final String WITH_AUTOMATION_SYSTEMS = "iidm.import.xml.with-automation-systems";
    public static final String MISSING_PERMANENT_LIMIT_PERCENTAGE = "iidm.import.xml.missing-permanent-limit-percentage";
    public static final String MINIMAL_VALIDATION_LEVEL = "iidm.import.minimal-validation-level";
    private static final Parameter THROW_EXCEPTION_IF_EXTENSION_NOT_FOUND_PARAMETER = new Parameter("iidm.import.xml.throw-exception-if-extension-not-found", ParameterType.BOOLEAN, "Throw exception if extension not found", (Object)Boolean.FALSE).addAdditionalNames(new String[]{"throwExceptionIfExtensionNotFound"});
    private static final Parameter EXTENSIONS_LIST_PARAMETER = new Parameter("iidm.import.xml.extensions", ParameterType.STRING_LIST, "The list of extension files ", null, EXTENSIONS_SUPPLIER.get().getProviders().stream().map(ExtensionProvider::getExtensionName).collect(Collectors.toList()));
    private static final Parameter WITH_AUTOMATION_SYSTEMS_PARAMETER = new Parameter("iidm.import.xml.with-automation-systems", ParameterType.BOOLEAN, "Import network with automation systems", (Object)Boolean.TRUE);
    public static final Parameter MISSING_PERMANENT_LIMIT_PERCENTAGE_PARAMETER = new Parameter("iidm.import.xml.missing-permanent-limit-percentage", ParameterType.DOUBLE, "Percentage applied to lowest temporary limit to compute the permanent limit when missing (for IIDM < 1.12 only)", (Object)100.0);
    public static final Parameter MINIMAL_VALIDATION_LEVEL_PARAMETER = new Parameter("iidm.import.minimal-validation-level", ParameterType.STRING, "Minimal validation level accepted", null);
    private final ParameterDefaultValueConfig defaultValueConfig;
    static final String SUFFIX_MAPPING = "_mapping";

    protected AbstractTreeDataImporter() {
        this(PlatformConfig.defaultConfig());
    }

    protected AbstractTreeDataImporter(PlatformConfig platformConfig) {
        this.defaultValueConfig = new ParameterDefaultValueConfig(platformConfig);
    }

    public List<Parameter> getParameters() {
        return List.of(THROW_EXCEPTION_IF_EXTENSION_NOT_FOUND_PARAMETER, EXTENSIONS_LIST_PARAMETER, WITH_AUTOMATION_SYSTEMS_PARAMETER, MISSING_PERMANENT_LIMIT_PERCENTAGE_PARAMETER, MINIMAL_VALIDATION_LEVEL_PARAMETER);
    }

    private String findExtension(ReadOnlyDataSource dataSource) throws IOException {
        for (String ext : this.getExtensions()) {
            if (!dataSource.exists(null, ext)) continue;
            return ext;
        }
        return null;
    }

    protected abstract String[] getExtensions();

    public boolean exists(ReadOnlyDataSource dataSource) {
        try {
            String ext = this.findExtension(dataSource);
            return this.exists(dataSource, ext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected abstract boolean exists(ReadOnlyDataSource var1, String var2) throws IOException;

    public void copy(ReadOnlyDataSource fromDataSource, DataSource toDataSource) {
        block28: {
            try {
                OutputStream os;
                String ext = this.findExtension(fromDataSource);
                if (!this.exists(fromDataSource, ext)) {
                    throw new PowsyblException("From data source is not importable");
                }
                try (InputStream is = fromDataSource.newInputStream(null, ext);){
                    os = toDataSource.newOutputStream(null, ext, false);
                    try {
                        ByteStreams.copy((InputStream)is, (OutputStream)os);
                    }
                    finally {
                        if (os != null) {
                            os.close();
                        }
                    }
                }
                if (!fromDataSource.exists(SUFFIX_MAPPING, "csv")) break block28;
                is = fromDataSource.newInputStream(SUFFIX_MAPPING, "csv");
                try {
                    os = toDataSource.newOutputStream(SUFFIX_MAPPING, "csv", false);
                    try {
                        ByteStreams.copy((InputStream)is, (OutputStream)os);
                    }
                    finally {
                        if (os != null) {
                            os.close();
                        }
                    }
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public Network importData(ReadOnlyDataSource dataSource, NetworkFactory networkFactory, Properties parameters, ReportNode reportNode) {
        Network network;
        Objects.requireNonNull(dataSource);
        Objects.requireNonNull(reportNode);
        ImportOptions options = this.createImportOptions(parameters);
        long startTime = System.currentTimeMillis();
        try {
            String ext = this.findExtension(dataSource);
            if (ext == null) {
                throw new PowsyblException("File " + dataSource.getBaseName() + "." + Joiner.on((String)"|").join((Object[])this.getExtensions()) + " not found");
            }
            network = NetworkSerDe.read(dataSource, networkFactory, options, ext, reportNode);
            ReportNode subReportNode = ((ReportNodeAdder)reportNode.newReportNode().withMessageTemplate("xiidmImportDone", "XIIDM import done")).add();
            DeserializerReports.importedNetworkReport(subReportNode, network.getId(), options.getFormat().toString());
            LOGGER.debug("{} import done in {} ms", (Object)this.getFormat(), (Object)(System.currentTimeMillis() - startTime));
        }
        catch (IOException e) {
            throw new PowsyblException((Throwable)e);
        }
        return network;
    }

    protected ImportOptions createImportOptions(Properties parameters) {
        return ((ImportOptions)new ImportOptions().setThrowExceptionIfExtensionNotFound(Parameter.readBoolean((String)this.getFormat(), (Properties)parameters, (Parameter)THROW_EXCEPTION_IF_EXTENSION_NOT_FOUND_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).setExtensions((Set)(Parameter.readStringList((String)this.getFormat(), (Properties)parameters, (Parameter)EXTENSIONS_LIST_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig) != null ? new HashSet(Parameter.readStringList((String)this.getFormat(), (Properties)parameters, (Parameter)EXTENSIONS_LIST_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)) : null))).setWithAutomationSystems(Parameter.readBoolean((String)this.getFormat(), (Properties)parameters, (Parameter)WITH_AUTOMATION_SYSTEMS_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).setMissingPermanentLimitPercentage(Parameter.readDouble((String)this.getFormat(), (Properties)parameters, (Parameter)MISSING_PERMANENT_LIMIT_PERCENTAGE_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig)).setMinimalValidationLevel(Parameter.readString((String)this.getFormat(), (Properties)parameters, (Parameter)MINIMAL_VALIDATION_LEVEL_PARAMETER, (ParameterDefaultValueConfig)this.defaultValueConfig));
    }
}

