/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.io.TreeDataWriter;
import com.powsybl.iidm.network.Area;
import com.powsybl.iidm.network.AreaBoundary;
import com.powsybl.iidm.network.AreaBoundaryAdder;
import com.powsybl.iidm.serde.BoundaryRefSerDe;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.TerminalRefSerDe;

public class AreaBoundarySerDe {
    static final AreaBoundarySerDe INSTANCE = new AreaBoundarySerDe();
    static final String ROOT_ELEMENT_NAME = "areaBoundary";
    static final String ARRAY_ELEMENT_NAME = "areaBoundaries";
    public static final String TERMINAL_REF = "terminalRef";

    protected void write(Area holder, NetworkSerializerContext context) {
        TreeDataWriter writer = context.getWriter();
        writer.writeStartNodes();
        for (AreaBoundary boundary : holder.getAreaBoundaries()) {
            writer.writeStartNode(context.getVersion().getNamespaceURI(context.isValid()), ROOT_ELEMENT_NAME);
            writer.writeBooleanAttribute("ac", boundary.isAc());
            boundary.getTerminal().ifPresent(terminal -> {
                writer.writeStringAttribute("type", TERMINAL_REF);
                TerminalRefSerDe.writeTerminalRefAttribute(terminal, context, writer);
            });
            boundary.getBoundary().ifPresent(danglingLineBoundary -> {
                writer.writeStringAttribute("type", "boundaryRef");
                BoundaryRefSerDe.writeBoundaryRefAttributes(danglingLineBoundary, context);
            });
            writer.writeEndNode();
        }
        writer.writeEndNodes();
    }

    protected void read(Area holder, NetworkDeserializerContext context) {
        String type;
        boolean ac = context.getReader().readBooleanAttribute("ac");
        AreaBoundaryAdder adder = holder.newAreaBoundary().setAc(ac);
        switch (type = context.getReader().readStringAttribute("type")) {
            case "terminalRef": {
                TerminalRefSerDe.readTerminalRef(context, holder.getNetwork(), arg_0 -> ((AreaBoundaryAdder)adder).setTerminal(arg_0));
                break;
            }
            case "boundaryRef": {
                BoundaryRefSerDe.readBoundaryRef(context, holder.getNetwork(), arg_0 -> ((AreaBoundaryAdder)adder).setBoundary(arg_0));
                break;
            }
            default: {
                throw new PowsyblException("Unexpected element for AreaBoundary: " + type + ". Should be boundaryRef or terminalRef");
            }
        }
        context.getEndTasks().add(() -> ((AreaBoundaryAdder)adder).add());
    }
}

