/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.TreeDataReader;
import com.powsybl.commons.report.ReportNode;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.util.Networks;
import com.powsybl.iidm.serde.AbstractNetworkSerDeContext;
import com.powsybl.iidm.serde.IidmSerDeConstants;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.ImportOptions;
import com.powsybl.iidm.serde.anonymizer.Anonymizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NetworkDeserializerContext
extends AbstractNetworkSerDeContext<ImportOptions>
implements DeserializerContext {
    private final TreeDataReader reader;
    private final List<Runnable> endTasks = new ArrayList<Runnable>();
    private final ImportOptions options;
    private final Map<String, String> extensionVersions;
    private ValidationLevel networkValidationLevel;

    public NetworkDeserializerContext(Anonymizer anonymizer, TreeDataReader reader) {
        this(anonymizer, reader, new ImportOptions(), IidmSerDeConstants.CURRENT_IIDM_VERSION, Collections.emptyMap());
    }

    public NetworkDeserializerContext(Anonymizer anonymizer, TreeDataReader reader, ImportOptions options, IidmVersion version, Map<String, String> extensionVersions) {
        super(anonymizer, version);
        this.reader = Objects.requireNonNull(reader);
        this.options = Objects.requireNonNull(options);
        this.extensionVersions = extensionVersions;
    }

    public TreeDataReader getReader() {
        return this.reader;
    }

    public List<Runnable> getEndTasks() {
        return this.endTasks;
    }

    public void executeEndTasks(Network network, ReportNode reportNode) {
        Networks.executeWithReportNode((Network)network, (ReportNode)reportNode, () -> this.getEndTasks().forEach(Runnable::run));
    }

    @Override
    public ImportOptions getOptions() {
        return this.options;
    }

    public boolean containsExtensionVersion(String extensionName, String version) {
        return version != null && version.equals(this.extensionVersions.get(extensionName));
    }

    public Optional<String> getExtensionVersion(ExtensionSerDe<?, ?> extensionSerDe) {
        return Optional.ofNullable(this.extensionVersions.get(extensionSerDe.getExtensionName()));
    }

    public NetworkDeserializerContext setNetworkValidationLevel(ValidationLevel validationLevel) {
        this.networkValidationLevel = validationLevel;
        return this;
    }

    public ValidationLevel getNetworkValidationLevel() {
        return this.networkValidationLevel;
    }
}

