/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.OverloadManagementSystem;
import com.powsybl.iidm.network.OverloadManagementSystemAdder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.ThreeSides;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.serde.AbstractComplexIdentifiableSerDe;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

class OverloadManagementSystemSerDe
extends AbstractComplexIdentifiableSerDe<OverloadManagementSystem, OverloadManagementSystemAdder, Substation> {
    static final OverloadManagementSystemSerDe INSTANCE = new OverloadManagementSystemSerDe();
    static final String ROOT_ELEMENT_NAME = "overloadManagementSystem";
    static final String ARRAY_ELEMENT_NAME = "overloadManagementSystems";
    private static final String BRANCH_TRIPPING_TAG = "branchTripping";
    private static final String SWITCH_TRIPPING_TAG = "switchTripping";
    private static final String THREE_WINDINGS_TRANSFORMER_TRIPPING_TAG = "threeWindingsTransformerTripping";

    OverloadManagementSystemSerDe() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected void writeRootElementAttributes(OverloadManagementSystem oms, Substation substation, NetworkSerializerContext context) {
        context.getWriter().writeBooleanAttribute("enabled", oms.isEnabled());
        context.getWriter().writeStringAttribute("monitoredElementId", context.getAnonymizer().anonymizeString(oms.getMonitoredElementId()));
        context.getWriter().writeEnumAttribute("side", (Enum)oms.getMonitoredSide());
    }

    @Override
    protected void writeSubElements(OverloadManagementSystem oms, Substation substation, NetworkSerializerContext context) {
        oms.getTrippings().forEach(t -> this.writeTripping((OverloadManagementSystem.Tripping)t, context));
    }

    private void writeTripping(OverloadManagementSystem.Tripping tripping, NetworkSerializerContext context) {
        switch (tripping.getType()) {
            case BRANCH_TRIPPING: {
                OverloadManagementSystem.BranchTripping branchTripping = (OverloadManagementSystem.BranchTripping)tripping;
                context.getWriter().writeStartNode(context.getVersion().getNamespaceURI(context.isValid()), BRANCH_TRIPPING_TAG);
                this.writeTrippingCommonAttributes(tripping, context);
                context.getWriter().writeStringAttribute("branchId", context.getAnonymizer().anonymizeString(branchTripping.getBranchToOperateId()));
                context.getWriter().writeEnumAttribute("side", (Enum)branchTripping.getSideToOperate());
                context.getWriter().writeEndNode();
                break;
            }
            case SWITCH_TRIPPING: {
                OverloadManagementSystem.SwitchTripping switchTripping = (OverloadManagementSystem.SwitchTripping)tripping;
                context.getWriter().writeStartNode(context.getVersion().getNamespaceURI(context.isValid()), SWITCH_TRIPPING_TAG);
                this.writeTrippingCommonAttributes(tripping, context);
                context.getWriter().writeStringAttribute("switchId", context.getAnonymizer().anonymizeString(switchTripping.getSwitchToOperateId()));
                context.getWriter().writeEndNode();
                break;
            }
            case THREE_WINDINGS_TRANSFORMER_TRIPPING: {
                OverloadManagementSystem.ThreeWindingsTransformerTripping twtTripping = (OverloadManagementSystem.ThreeWindingsTransformerTripping)tripping;
                context.getWriter().writeStartNode(context.getVersion().getNamespaceURI(context.isValid()), THREE_WINDINGS_TRANSFORMER_TRIPPING_TAG);
                this.writeTrippingCommonAttributes(tripping, context);
                context.getWriter().writeStringAttribute("threeWindingsTransformerId", context.getAnonymizer().anonymizeString(twtTripping.getThreeWindingsTransformerToOperateId()));
                context.getWriter().writeEnumAttribute("side", (Enum)twtTripping.getSideToOperate());
                context.getWriter().writeEndNode();
                break;
            }
            default: {
                throw new PowsyblException("Unexpected tripping type: " + tripping.getType());
            }
        }
    }

    private void writeTrippingCommonAttributes(OverloadManagementSystem.Tripping tripping, NetworkSerializerContext context) {
        context.getWriter().writeStringAttribute("key", tripping.getKey());
        String nameOrKey = tripping.getNameOrKey();
        if (nameOrKey != null && !nameOrKey.equals(tripping.getKey())) {
            context.getWriter().writeStringAttribute("name", nameOrKey);
        }
        context.getWriter().writeDoubleAttribute("currentLimit", tripping.getCurrentLimit());
        context.getWriter().writeBooleanAttribute("openAction", tripping.isOpenAction());
    }

    @Override
    protected OverloadManagementSystemAdder createAdder(Substation s) {
        return s.newOverloadManagementSystem();
    }

    @Override
    protected void readRootElementAttributes(OverloadManagementSystemAdder adder, Substation parent, List<Consumer<OverloadManagementSystem>> toApply, NetworkDeserializerContext context) {
        boolean enabled = context.getReader().readBooleanAttribute("enabled", true);
        String monitoredElementId = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute("monitoredElementId"));
        ThreeSides monitoredSide = (ThreeSides)context.getReader().readEnumAttribute("side", ThreeSides.class, (Enum)ThreeSides.ONE);
        if (adder != null) {
            adder.setEnabled(enabled).setMonitoredElementId(monitoredElementId).setMonitoredElementSide(monitoredSide);
        }
    }

    @Override
    protected void readSubElements(String id, OverloadManagementSystemAdder adder, List<Consumer<OverloadManagementSystem>> toApply, NetworkDeserializerContext context) {
        context.getReader().readChildNodes(elementName -> {
            String key = context.getReader().readStringAttribute("key");
            String name = context.getReader().readStringAttribute("name");
            double currentLimit = context.getReader().readDoubleAttribute("currentLimit");
            boolean openAction = context.getReader().readBooleanAttribute("openAction");
            switch (elementName) {
                case "branchTripping": {
                    OverloadManagementSystemSerDe.readBranchTripping(adder, context, key, name, currentLimit, openAction);
                    break;
                }
                case "switchTripping": {
                    OverloadManagementSystemSerDe.readSwitchTripping(adder, context, key, name, currentLimit, openAction);
                    break;
                }
                case "threeWindingsTransformerTripping": {
                    OverloadManagementSystemSerDe.readThreeWindingsTransformerTripping(adder, context, key, name, currentLimit, openAction);
                    break;
                }
                default: {
                    this.readSubElement(elementName, id, toApply, context);
                }
            }
        });
    }

    private static void readBranchTripping(OverloadManagementSystemAdder adder, NetworkDeserializerContext context, String key, String name, double currentLimit, boolean openAction) {
        String branchId = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute("branchId"));
        TwoSides sideToOperate = (TwoSides)context.getReader().readEnumAttribute("side", TwoSides.class, (Enum)TwoSides.ONE);
        context.getReader().readEndNode();
        if (adder != null) {
            ((OverloadManagementSystemAdder.BranchTrippingAdder)((OverloadManagementSystemAdder.BranchTrippingAdder)((OverloadManagementSystemAdder.BranchTrippingAdder)((OverloadManagementSystemAdder.BranchTrippingAdder)adder.newBranchTripping().setKey(key)).setName(name)).setCurrentLimit(currentLimit)).setOpenAction(openAction)).setBranchToOperateId(branchId).setSideToOperate(sideToOperate).add();
        }
    }

    private static void readSwitchTripping(OverloadManagementSystemAdder adder, NetworkDeserializerContext context, String key, String name, double currentLimit, boolean openAction) {
        String switchId = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute("switchId"));
        context.getReader().readEndNode();
        if (adder != null) {
            ((OverloadManagementSystemAdder.SwitchTrippingAdder)((OverloadManagementSystemAdder.SwitchTrippingAdder)((OverloadManagementSystemAdder.SwitchTrippingAdder)((OverloadManagementSystemAdder.SwitchTrippingAdder)adder.newSwitchTripping().setKey(key)).setName(name)).setCurrentLimit(currentLimit)).setOpenAction(openAction)).setSwitchToOperateId(switchId).add();
        }
    }

    private static void readThreeWindingsTransformerTripping(OverloadManagementSystemAdder adder, NetworkDeserializerContext context, String key, String name, double currentLimit, boolean openAction) {
        String twtId = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute("threeWindingsTransformerId"));
        ThreeSides sideToOperate = (ThreeSides)context.getReader().readEnumAttribute("side", ThreeSides.class, (Enum)ThreeSides.ONE);
        context.getReader().readEndNode();
        if (adder != null) {
            ((OverloadManagementSystemAdder.ThreeWindingsTransformerTrippingAdder)((OverloadManagementSystemAdder.ThreeWindingsTransformerTrippingAdder)((OverloadManagementSystemAdder.ThreeWindingsTransformerTrippingAdder)((OverloadManagementSystemAdder.ThreeWindingsTransformerTrippingAdder)adder.newThreeWindingsTransformerTripping().setKey(key)).setName(name)).setCurrentLimit(currentLimit)).setOpenAction(openAction)).setThreeWindingsTransformerToOperateId(twtId).setSideToOperate(sideToOperate).add();
        }
    }

    @Override
    protected boolean postponeElementCreation() {
        return true;
    }

    public final void skip(Substation s, NetworkDeserializerContext context) {
        ArrayList<Consumer<OverloadManagementSystem>> toApply = new ArrayList<Consumer<OverloadManagementSystem>>();
        String id = this.readIdentifierAttributes(null, context);
        this.readRootElementAttributes(null, s, toApply, context);
        this.readSubElements(id, (OverloadManagementSystemAdder)null, (List<Consumer<OverloadManagementSystem>>)toApply, context);
    }
}

