/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.AbstractExtensionSerDe;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.commons.io.TreeDataWriter;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.extensions.InjectionObservability;
import com.powsybl.iidm.network.extensions.InjectionObservabilityAdder;
import com.powsybl.iidm.network.extensions.ObservabilityQuality;

@AutoService(value={ExtensionSerDe.class})
public class InjectionObservabilitySerDe<T extends Injection<T>>
extends AbstractExtensionSerDe<T, InjectionObservability<T>> {
    private static final String QUALITY_P = "qualityP";
    private static final String QUALITY_Q = "qualityQ";
    private static final String QUALITY_V = "qualityV";
    private static final String STANDARD_DEVIATION = "standardDeviation";
    private static final String REDUNDANT = "redundant";

    public InjectionObservabilitySerDe() {
        super("injectionObservability", "network", InjectionObservability.class, "injectionObservability.xsd", "http://www.itesla_project.eu/schema/iidm/ext/injection_observability/1_0", "io");
    }

    public void write(InjectionObservability<T> injectionObservability, SerializerContext context) {
        context.getWriter().writeBooleanAttribute("observable", injectionObservability.isObservable(), false);
        this.writeOptionalQuality(QUALITY_P, injectionObservability.getQualityP(), context.getWriter());
        this.writeOptionalQuality(QUALITY_Q, injectionObservability.getQualityQ(), context.getWriter());
        this.writeOptionalQuality(QUALITY_V, injectionObservability.getQualityV(), context.getWriter());
    }

    private void writeOptionalQuality(String elementName, ObservabilityQuality<T> quality, TreeDataWriter writer) {
        if (quality != null) {
            writer.writeStartNode(this.getNamespaceUri(), elementName);
            writer.writeDoubleAttribute(STANDARD_DEVIATION, quality.getStandardDeviation());
            writer.writeOptionalBooleanAttribute(REDUNDANT, (Boolean)quality.isRedundant().orElse(null));
            writer.writeEndNode();
        }
    }

    public InjectionObservability<T> read(T identifiable, DeserializerContext context) {
        boolean observable = context.getReader().readBooleanAttribute("observable", false);
        InjectionObservabilityAdder adder = ((InjectionObservabilityAdder)identifiable.newExtension(InjectionObservabilityAdder.class)).withObservable(observable);
        context.getReader().readChildNodes(elementName -> {
            double standardDeviation = context.getReader().readDoubleAttribute(STANDARD_DEVIATION);
            boolean redundant = context.getReader().readOptionalBooleanAttribute(REDUNDANT).orElse(false);
            context.getReader().readEndNode();
            switch (elementName) {
                case "qualityP": {
                    adder.withStandardDeviationP(standardDeviation).withRedundantP(Boolean.valueOf(redundant));
                    break;
                }
                case "qualityQ": {
                    adder.withStandardDeviationQ(standardDeviation).withRedundantQ(Boolean.valueOf(redundant));
                    break;
                }
                case "qualityV": {
                    adder.withStandardDeviationV(standardDeviation).withRedundantV(Boolean.valueOf(redundant));
                    break;
                }
                default: {
                    throw new PowsyblException("Unknown element name '" + elementName + "' in 'injectionObservability'");
                }
            }
        });
        return (InjectionObservability)adder.add();
    }
}

