/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.google.auto.service.AutoService;
import com.powsybl.commons.datasource.ReadOnlyDataSource;
import com.powsybl.commons.io.TreeDataFormat;
import com.powsybl.iidm.network.Importer;
import com.powsybl.iidm.serde.AbstractTreeDataImporter;
import com.powsybl.iidm.serde.IidmSerDeConstants;
import com.powsybl.iidm.serde.ImportOptions;
import com.powsybl.iidm.serde.NetworkSerDe;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Properties;

@AutoService(value={Importer.class})
public class BinaryImporter
extends AbstractTreeDataImporter {
    private static final String[] EXTENSIONS = new String[]{"biidm", "bin"};

    @Override
    protected String[] getExtensions() {
        return EXTENSIONS;
    }

    public String getFormat() {
        return "BIIDM";
    }

    public String getComment() {
        return "IIDM binary v " + IidmSerDeConstants.CURRENT_IIDM_VERSION.toString(".") + " importer";
    }

    @Override
    protected boolean exists(ReadOnlyDataSource dataSource, String ext) throws IOException {
        if (ext != null) {
            try (InputStream dis = dataSource.newInputStream(null, ext);){
                boolean bl = Arrays.equals(dis.readNBytes(NetworkSerDe.BIIDM_MAGIC_NUMBER.length), NetworkSerDe.BIIDM_MAGIC_NUMBER);
                return bl;
            }
        }
        return false;
    }

    @Override
    protected ImportOptions createImportOptions(Properties parameters) {
        return (ImportOptions)super.createImportOptions(parameters).setFormat(TreeDataFormat.BIN);
    }
}

