/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.serde.AbstractSimpleIdentifiableSerDe;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;

class BusSerDe
extends AbstractSimpleIdentifiableSerDe<Bus, BusAdder, VoltageLevel> {
    static final BusSerDe INSTANCE = new BusSerDe();
    static final String ROOT_ELEMENT_NAME = "bus";
    static final String ARRAY_ELEMENT_NAME = "buses";

    BusSerDe() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected void writeRootElementAttributes(Bus b, VoltageLevel vl, NetworkSerializerContext context) {
        context.getWriter().writeDoubleAttribute("v", b.getV());
        context.getWriter().writeDoubleAttribute("angle", b.getAngle());
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_8, context, () -> {
            context.getWriter().writeDoubleAttribute("fictitiousP0", b.getFictitiousP0(), 0.0);
            context.getWriter().writeDoubleAttribute("fictitiousQ0", b.getFictitiousQ0(), 0.0);
        });
    }

    @Override
    protected void writeSubElements(Bus b, VoltageLevel vl, NetworkSerializerContext context) {
    }

    @Override
    protected BusAdder createAdder(VoltageLevel vl) {
        return vl.getBusBreakerView().newBus();
    }

    @Override
    protected Bus readRootElementAttributes(BusAdder adder, VoltageLevel voltageLevel, NetworkDeserializerContext context) {
        double v = context.getReader().readDoubleAttribute("v");
        double angle = context.getReader().readDoubleAttribute("angle");
        Bus b = adder.add();
        b.setV(v);
        b.setAngle(angle);
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_8, context, () -> {
            double p0 = context.getReader().readDoubleAttribute("fictitiousP0");
            double q0 = context.getReader().readDoubleAttribute("fictitiousQ0");
            if (!Double.isNaN(p0)) {
                b.setFictitiousP0(p0);
            }
            if (!Double.isNaN(q0)) {
                b.setFictitiousQ0(q0);
            }
        });
        return b;
    }

    @Override
    protected void readSubElements(Bus b, NetworkDeserializerContext context) {
        context.getReader().readChildNodes(elementName -> this.readSubElement(elementName, b, context));
    }
}

