/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.io.TreeDataReader;
import com.powsybl.commons.io.TreeDataWriter;
import com.powsybl.iidm.network.ActivePowerLimits;
import com.powsybl.iidm.network.ActivePowerLimitsAdder;
import com.powsybl.iidm.network.ApparentPowerLimits;
import com.powsybl.iidm.network.ApparentPowerLimitsAdder;
import com.powsybl.iidm.network.BranchAdder;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.CurrentLimits;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.FlowsLimitsHolder;
import com.powsybl.iidm.network.InjectionAdder;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.LoadingLimitsAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.OperationalLimitsGroup;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformerAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TopologyLevel;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.serde.ExportOptions;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.ImportOptions;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;
import java.util.Collection;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntConsumer;

public final class ConnectableSerDeUtil {
    static final String TEMPORARY_LIMITS_ARRAY_ELEMENT_NAME = "temporaryLimits";
    static final String TEMPORARY_LIMITS_ROOT_ELEMENT_NAME = "temporaryLimit";
    private static final String BUS = "bus";
    private static final String CONNECTABLE_BUS = "connectableBus";
    private static final String NODE = "node";
    static final String ACTIVE_POWER_LIMITS = "activePowerLimits";
    static final String APPARENT_POWER_LIMITS = "apparentPowerLimits";
    static final String ACTIVE_POWER_LIMITS_1 = "activePowerLimits1";
    static final String ACTIVE_POWER_LIMITS_2 = "activePowerLimits2";
    static final String APPARENT_POWER_LIMITS_1 = "apparentPowerLimits1";
    static final String APPARENT_POWER_LIMITS_2 = "apparentPowerLimits2";
    static final String ACTIVE_POWER_LIMITS_3 = "activePowerLimits3";
    static final String APPARENT_POWER_LIMITS_3 = "apparentPowerLimits3";
    static final String CURRENT_LIMITS = "currentLimits";
    static final String LIMITS_GROUP = "operationalLimitsGroup";
    static final String LIMITS_GROUP_1 = "operationalLimitsGroup1";
    static final String LIMITS_GROUP_2 = "operationalLimitsGroup2";
    static final String LIMITS_GROUP_3 = "operationalLimitsGroup3";
    static final String LIMITS_GROUPS = "operationalLimitsGroups";
    static final String LIMITS_GROUPS_1 = "operationalLimitsGroups1";
    static final String LIMITS_GROUPS_2 = "operationalLimitsGroups2";
    static final String LIMITS_GROUPS_3 = "operationalLimitsGroups3";
    static final String SELECTED_GROUP_ID = "selectedOperationalLimitsGroupId";

    private ConnectableSerDeUtil() {
    }

    private static String indexToString(Integer index) {
        return index != null ? index.toString() : "";
    }

    public static void writeNodeOrBus(Integer index, Terminal t, NetworkSerializerContext context) {
        if (index != null) {
            context.getWriter().writeStringAttribute("voltageLevelId" + index, context.getAnonymizer().anonymizeString(t.getVoltageLevel().getId()));
        }
        TopologyLevel topologyLevel = TopologyLevel.min((TopologyKind)t.getVoltageLevel().getTopologyKind(), (TopologyLevel)context.getOptions().getTopologyLevel());
        switch (topologyLevel) {
            case NODE_BREAKER: {
                ConnectableSerDeUtil.writeNode(index, t, context);
                break;
            }
            case BUS_BREAKER: {
                ConnectableSerDeUtil.writeBus(index, t.getBusBreakerView().getBus(), t.getBusBreakerView().getConnectableBus(), context);
                break;
            }
            case BUS_BRANCH: {
                ConnectableSerDeUtil.writeBus(index, t.getBusView().getBus(), t.getBusView().getConnectableBus(), context);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected TopologyLevel value: " + topologyLevel);
            }
        }
    }

    private static void writeNode(Integer index, Terminal t, NetworkSerializerContext context) {
        context.getWriter().writeIntAttribute(NODE + ConnectableSerDeUtil.indexToString(index), t.getNodeBreakerView().getNode());
    }

    private static void writeBus(Integer index, Bus bus, Bus connectableBus, NetworkSerializerContext context) {
        context.getWriter().writeStringAttribute(BUS + ConnectableSerDeUtil.indexToString(index), (String)Optional.ofNullable(bus).map(b -> context.getAnonymizer().anonymizeString(b.getId())).orElse(null));
        context.getWriter().writeStringAttribute(CONNECTABLE_BUS + ConnectableSerDeUtil.indexToString(index), (String)Optional.ofNullable(connectableBus).map(b -> context.getAnonymizer().anonymizeString(b.getId())).orElse(null));
    }

    public static void readNodeOrBus(InjectionAdder<?, ?> adder, NetworkDeserializerContext context, TopologyKind topologyKind) {
        ConnectableSerDeUtil.readNodeOrBus(adder, "", context, topologyKind);
    }

    public static void readNodeOrBus(InjectionAdder<?, ?> adder, String suffix, NetworkDeserializerContext context, TopologyKind topologyKind) {
        ConnectableSerDeUtil.readNodeOrBus(suffix, topologyKind, arg_0 -> adder.setNode(arg_0), arg_0 -> adder.setBus(arg_0), arg_0 -> adder.setConnectableBus(arg_0), context);
    }

    private static void readNode(IntConsumer nodeAdder, String suffix, NetworkDeserializerContext context) {
        nodeAdder.accept(context.getReader().readIntAttribute(NODE + suffix));
    }

    private static void readBus(Consumer<String> busAdder, String suffix, NetworkDeserializerContext context) {
        busAdder.accept(context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute(BUS + suffix)));
    }

    private static void readConnectableBus(Consumer<String> busAdder, String suffix, NetworkDeserializerContext context) {
        busAdder.accept(context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute(CONNECTABLE_BUS + suffix)));
    }

    public static void readVoltageLevelAndNodeOrBus(BranchAdder<?, ?> adder, Network network, NetworkDeserializerContext context) {
        ConnectableSerDeUtil.readVoltageLevelAndNodeOrBus("1", arg_0 -> adder.setVoltageLevel1(arg_0), arg_0 -> adder.setNode1(arg_0), arg_0 -> adder.setBus1(arg_0), arg_0 -> adder.setConnectableBus1(arg_0), network, context);
        ConnectableSerDeUtil.readVoltageLevelAndNodeOrBus("2", arg_0 -> adder.setVoltageLevel2(arg_0), arg_0 -> adder.setNode2(arg_0), arg_0 -> adder.setBus2(arg_0), arg_0 -> adder.setConnectableBus2(arg_0), network, context);
    }

    private static void readVoltageLevelAndNodeOrBus(String suffix, Consumer<String> voltageLevelSetter, IntConsumer nodeSetter, Consumer<String> busSetter, Consumer<String> connectableBusSetter, Network network, NetworkDeserializerContext context) {
        String voltageLevelId = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute("voltageLevelId" + suffix));
        voltageLevelSetter.accept(voltageLevelId);
        ConnectableSerDeUtil.readNodeOrBus(suffix, ConnectableSerDeUtil.getTopologKind(voltageLevelId, network), nodeSetter, busSetter, connectableBusSetter, context);
    }

    private static void readNodeOrBus(String suffix, TopologyKind topologyKind, IntConsumer nodeSetter, Consumer<String> busSetter, Consumer<String> connectableBusSetter, NetworkDeserializerContext context) {
        switch (topologyKind) {
            case NODE_BREAKER: {
                ConnectableSerDeUtil.readNode(nodeSetter, suffix, context);
                break;
            }
            case BUS_BREAKER: {
                ConnectableSerDeUtil.readBus(busSetter, suffix, context);
                ConnectableSerDeUtil.readConnectableBus(connectableBusSetter, suffix, context);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private static TopologyKind getTopologKind(String vlId, Network network) {
        VoltageLevel vl = network.getVoltageLevel(vlId);
        if (vl == null) {
            throw new PowsyblException("Voltage level '" + vlId + "' not found");
        }
        return vl.getTopologyKind();
    }

    public static void readNodeOrBus(int index, ThreeWindingsTransformerAdder.LegAdder adder, Network network, NetworkDeserializerContext context) {
        ConnectableSerDeUtil.readVoltageLevelAndNodeOrBus(String.valueOf(index), arg_0 -> ((ThreeWindingsTransformerAdder.LegAdder)adder).setVoltageLevel(arg_0), arg_0 -> ((ThreeWindingsTransformerAdder.LegAdder)adder).setNode(arg_0), arg_0 -> ((ThreeWindingsTransformerAdder.LegAdder)adder).setBus(arg_0), arg_0 -> ((ThreeWindingsTransformerAdder.LegAdder)adder).setConnectableBus(arg_0), network, context);
    }

    public static void writePQ(Integer index, Terminal t, TreeDataWriter writer) {
        writer.writeDoubleAttribute("p" + ConnectableSerDeUtil.indexToString(index), t.getP());
        writer.writeDoubleAttribute("q" + ConnectableSerDeUtil.indexToString(index), t.getQ());
    }

    public static void writeOptionalPQ(Integer index, Terminal t, TreeDataWriter writer, BooleanSupplier write) {
        Double nullableP = write.getAsBoolean() ? Double.valueOf(t.getP()) : null;
        Double nullableQ = write.getAsBoolean() ? Double.valueOf(t.getQ()) : null;
        writer.writeOptionalDoubleAttribute("p" + ConnectableSerDeUtil.indexToString(index), nullableP);
        writer.writeOptionalDoubleAttribute("q" + ConnectableSerDeUtil.indexToString(index), nullableQ);
    }

    public static void readPQ(Integer index, Terminal t, TreeDataReader reader) {
        double p = reader.readDoubleAttribute("p" + ConnectableSerDeUtil.indexToString(index));
        double q = reader.readDoubleAttribute("q" + ConnectableSerDeUtil.indexToString(index));
        t.setP(p).setQ(q);
    }

    public static void readOptionalPQ(Integer index, Terminal t, TreeDataReader reader) {
        reader.readOptionalDoubleAttribute("p" + ConnectableSerDeUtil.indexToString(index)).ifPresent(arg_0 -> ((Terminal)t).setP(arg_0));
        reader.readOptionalDoubleAttribute("q" + ConnectableSerDeUtil.indexToString(index)).ifPresent(arg_0 -> ((Terminal)t).setQ(arg_0));
    }

    public static void readActivePowerLimits(ActivePowerLimitsAdder activePowerLimitsAdder, NetworkDeserializerContext context) {
        ConnectableSerDeUtil.readLoadingLimits(ACTIVE_POWER_LIMITS, activePowerLimitsAdder, context);
    }

    public static void readApparentPowerLimits(ApparentPowerLimitsAdder apparentPowerLimitsAdder, NetworkDeserializerContext context) {
        ConnectableSerDeUtil.readLoadingLimits(APPARENT_POWER_LIMITS, apparentPowerLimitsAdder, context);
    }

    public static void readCurrentLimits(CurrentLimitsAdder currentLimitsAdder, NetworkDeserializerContext context) {
        ConnectableSerDeUtil.readLoadingLimits(CURRENT_LIMITS, currentLimitsAdder, context);
    }

    private static <L extends LoadingLimits, A extends LoadingLimitsAdder<L, A>> void readLoadingLimits(String type, A adder, NetworkDeserializerContext context) {
        TreeDataReader reader = context.getReader();
        IidmVersion iidmVersion = context.getVersion();
        ImportOptions options = context.getOptions();
        ValidationLevel minimalValidationLevel = options.getMinimalValidationLevel().orElse(context.getNetworkValidationLevel());
        double permanentLimit = reader.readDoubleAttribute("permanentLimit");
        if (Double.isNaN(permanentLimit) && iidmVersion.compareTo(IidmVersion.V_1_12) >= 0 && minimalValidationLevel == ValidationLevel.STEADY_STATE_HYPOTHESIS) {
            throw new PowsyblException("permanentLimit is absent in '" + type + "'");
        }
        adder.setPermanentLimit(permanentLimit);
        reader.readChildNodes(elementName -> {
            if (!TEMPORARY_LIMITS_ROOT_ELEMENT_NAME.equals(elementName)) {
                throw new PowsyblException("Unknown element name '" + elementName + "' in '" + type + "'");
            }
            String name = reader.readStringAttribute("name");
            int acceptableDuration = reader.readIntAttribute("acceptableDuration", Integer.MAX_VALUE);
            double value = reader.readDoubleAttribute("value", Double.MAX_VALUE);
            boolean fictitious = reader.readBooleanAttribute("fictitious", false);
            reader.readEndNode();
            adder.beginTemporaryLimit().setName(name).setAcceptableDuration(acceptableDuration).setValue(value).setFictitious(fictitious).endTemporaryLimit();
        });
        if (minimalValidationLevel == ValidationLevel.STEADY_STATE_HYPOTHESIS) {
            adder.fixLimits(options.getMissingPermanentLimitPercentage()).add();
        } else {
            adder.add();
        }
    }

    private static void readAllLoadingLimits(String groupElementName, OperationalLimitsGroup group, NetworkDeserializerContext context) {
        context.getReader().readChildNodes(limitElementName -> {
            switch (limitElementName) {
                case "activePowerLimits": {
                    ConnectableSerDeUtil.readActivePowerLimits(group.newActivePowerLimits(), context);
                    break;
                }
                case "apparentPowerLimits": {
                    ConnectableSerDeUtil.readApparentPowerLimits(group.newApparentPowerLimits(), context);
                    break;
                }
                case "currentLimits": {
                    ConnectableSerDeUtil.readCurrentLimits(group.newCurrentLimits(), context);
                    break;
                }
                default: {
                    throw new PowsyblException("Unknown element name '" + limitElementName + "' in '" + groupElementName + "'");
                }
            }
        });
    }

    static void readLoadingLimitsGroup(Function<String, OperationalLimitsGroup> groupBuilder, String groupElementName, NetworkDeserializerContext context) {
        String id = context.getReader().readStringAttribute("id");
        OperationalLimitsGroup group = groupBuilder.apply(id);
        ConnectableSerDeUtil.readAllLoadingLimits(groupElementName, group, context);
    }

    static void readLoadingLimitsGroups(FlowsLimitsHolder h, String groupElementName, NetworkDeserializerContext context) {
        String id = context.getReader().readStringAttribute("id");
        OperationalLimitsGroup group = h.newOperationalLimitsGroup(id);
        ConnectableSerDeUtil.readAllLoadingLimits(groupElementName, group, context);
    }

    static void writeActivePowerLimits(Integer index, ActivePowerLimits limits, TreeDataWriter writer, IidmVersion version, boolean valid, ExportOptions exportOptions) {
        ConnectableSerDeUtil.writeLoadingLimits(index, limits, writer, version.getNamespaceURI(valid), version, valid, exportOptions, ACTIVE_POWER_LIMITS);
    }

    static void writeApparentPowerLimits(Integer index, ApparentPowerLimits limits, TreeDataWriter writer, IidmVersion version, boolean valid, ExportOptions exportOptions) {
        ConnectableSerDeUtil.writeLoadingLimits(index, limits, writer, version.getNamespaceURI(valid), version, valid, exportOptions, APPARENT_POWER_LIMITS);
    }

    public static void writeCurrentLimits(Integer index, CurrentLimits limits, TreeDataWriter writer, IidmVersion version, boolean valid, ExportOptions exportOptions) {
        ConnectableSerDeUtil.writeCurrentLimits(index, limits, writer, version.getNamespaceURI(valid), version, valid, exportOptions);
    }

    public static void writeCurrentLimits(Integer index, CurrentLimits limits, TreeDataWriter writer, String nsUri, IidmVersion version, boolean valid, ExportOptions exportOptions) {
        ConnectableSerDeUtil.writeLoadingLimits(index, limits, writer, nsUri, version, valid, exportOptions, CURRENT_LIMITS);
    }

    private static <L extends LoadingLimits> void writeLoadingLimits(Integer index, L limits, TreeDataWriter writer, String nsUri, IidmVersion version, boolean valid, ExportOptions exportOptions, String type) {
        if (!(limits == null || Double.isNaN(limits.getPermanentLimit()) && limits.getTemporaryLimits().isEmpty())) {
            writer.writeStartNode(nsUri, type + ConnectableSerDeUtil.indexToString(index));
            writer.writeDoubleAttribute("permanentLimit", limits.getPermanentLimit());
            writer.writeStartNodes();
            for (LoadingLimits.TemporaryLimit tl : IidmSerDeUtil.sortedTemporaryLimits(limits.getTemporaryLimits(), exportOptions)) {
                writer.writeStartNode(version.getNamespaceURI(valid), TEMPORARY_LIMITS_ROOT_ELEMENT_NAME);
                writer.writeStringAttribute("name", tl.getName());
                writer.writeIntAttribute("acceptableDuration", tl.getAcceptableDuration(), Integer.MAX_VALUE);
                writer.writeDoubleAttribute("value", tl.getValue(), Double.MAX_VALUE);
                writer.writeBooleanAttribute("fictitious", tl.isFictitious(), false);
                writer.writeEndNode();
            }
            writer.writeEndNodes();
            writer.writeEndNode();
        }
    }

    static void writeSelectedGroupId(Integer index, String defaultId, TreeDataWriter writer) {
        String suffix = index == null ? "" : String.valueOf(index);
        writer.writeStringAttribute(SELECTED_GROUP_ID + suffix, defaultId);
    }

    static void readSelectedGroupId(Integer index, Consumer<String> selectedGroupIdSetter, NetworkDeserializerContext context) {
        String suffix = index == null ? "" : String.valueOf(index);
        String selectedGroupId = context.getReader().readStringAttribute(SELECTED_GROUP_ID + suffix);
        if (selectedGroupId != null) {
            context.getEndTasks().add(() -> selectedGroupIdSetter.accept(selectedGroupId));
        }
    }

    static void writeLimits(NetworkSerializerContext context, Integer index, String rootName, OperationalLimitsGroup defaultGroup, Collection<OperationalLimitsGroup> groups) {
        String suffix = index == null ? "" : String.valueOf(index);
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_11, context, () -> {
            ActivePowerLimits activePowerLimits = Optional.ofNullable(defaultGroup).flatMap(OperationalLimitsGroup::getActivePowerLimits).orElse(null);
            if (activePowerLimits != null) {
                IidmSerDeUtil.assertMinimumVersion(rootName, ACTIVE_POWER_LIMITS + suffix, IidmSerDeUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmVersion.V_1_5, context);
            }
            IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.writeActivePowerLimits(index, activePowerLimits, context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
            ApparentPowerLimits apparentPowerLimits = Optional.ofNullable(defaultGroup).flatMap(OperationalLimitsGroup::getApparentPowerLimits).orElse(null);
            if (apparentPowerLimits != null) {
                IidmSerDeUtil.assertMinimumVersion(rootName, APPARENT_POWER_LIMITS + suffix, IidmSerDeUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmVersion.V_1_5, context);
            }
            IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.writeApparentPowerLimits(index, apparentPowerLimits, context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
            CurrentLimits currentLimits = Optional.ofNullable(defaultGroup).flatMap(OperationalLimitsGroup::getCurrentLimits).orElse(null);
            ConnectableSerDeUtil.writeCurrentLimits(index, currentLimits, context.getWriter(), context.getVersion(), context.isValid(), context.getOptions());
        });
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> ConnectableSerDeUtil.writeLoadingLimitsGroups(index, groups, context.getWriter(), context.getVersion(), context.isValid(), context.getOptions()));
    }

    private static void writeLoadingLimitsGroups(Integer index, Collection<OperationalLimitsGroup> groups, TreeDataWriter writer, IidmVersion version, boolean valid, ExportOptions exportOptions) {
        String suffix = index == null ? "" : String.valueOf(index);
        writer.writeStartNodes();
        for (OperationalLimitsGroup g : groups) {
            writer.writeStartNode(version.getNamespaceURI(valid), LIMITS_GROUP + suffix);
            writer.writeStringAttribute("id", g.getId());
            g.getActivePowerLimits().ifPresent(l -> ConnectableSerDeUtil.writeActivePowerLimits(null, l, writer, version, valid, exportOptions));
            g.getApparentPowerLimits().ifPresent(l -> ConnectableSerDeUtil.writeApparentPowerLimits(null, l, writer, version, valid, exportOptions));
            g.getCurrentLimits().ifPresent(l -> ConnectableSerDeUtil.writeCurrentLimits(null, l, writer, version, valid, exportOptions));
            writer.writeEndNode();
        }
        writer.writeEndNodes();
    }
}

