/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.Container;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineFilter;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.Ground;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.StaticVarCompensator;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TopologyLevel;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.util.Networks;
import com.powsybl.iidm.serde.AbstractSimpleIdentifiableSerDe;
import com.powsybl.iidm.serde.BatterySerDe;
import com.powsybl.iidm.serde.BusBreakerViewSwitchSerDe;
import com.powsybl.iidm.serde.BusSerDe;
import com.powsybl.iidm.serde.BusbarSectionSerDe;
import com.powsybl.iidm.serde.DanglingLineSerDe;
import com.powsybl.iidm.serde.GeneratorSerDe;
import com.powsybl.iidm.serde.GroundSerDe;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.LccConverterStationSerDe;
import com.powsybl.iidm.serde.LoadSerDe;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.NodeBreakerViewInternalConnectionSerDe;
import com.powsybl.iidm.serde.NodeBreakerViewSwitchSerDe;
import com.powsybl.iidm.serde.PropertiesSerDe;
import com.powsybl.iidm.serde.ShuntSerDe;
import com.powsybl.iidm.serde.StaticVarCompensatorSerDe;
import com.powsybl.iidm.serde.VscConverterStationSerDe;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VoltageLevelSerDe
extends AbstractSimpleIdentifiableSerDe<VoltageLevel, VoltageLevelAdder, Container<? extends Identifiable<?>>> {
    static final VoltageLevelSerDe INSTANCE = new VoltageLevelSerDe();
    static final String ROOT_ELEMENT_NAME = "voltageLevel";
    static final String ARRAY_ELEMENT_NAME = "voltageLevels";
    private static final Logger LOGGER = LoggerFactory.getLogger(VoltageLevelSerDe.class);
    private static final String NODE_BREAKER_TOPOLOGY_ELEMENT_NAME = "nodeBreakerTopology";
    private static final String BUS_BREAKER_TOPOLOGY_ELEMENT_NAME = "busBreakerTopology";
    private static final String NODE_COUNT = "nodeCount";
    static final String INJ_ROOT_ELEMENT_NAME = "inj";
    static final String INJ_ARRAY_ELEMENT_NAME = "fictitiousInjections";

    VoltageLevelSerDe() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected void writeRootElementAttributes(VoltageLevel vl, Container<? extends Identifiable<?>> c, NetworkSerializerContext context) {
        context.getWriter().writeDoubleAttribute("nominalV", vl.getNominalV());
        context.getWriter().writeDoubleAttribute("lowVoltageLimit", vl.getLowVoltageLimit());
        context.getWriter().writeDoubleAttribute("highVoltageLimit", vl.getHighVoltageLimit());
        TopologyLevel topologyLevel = TopologyLevel.min((TopologyKind)vl.getTopologyKind(), (TopologyLevel)context.getOptions().getTopologyLevel());
        context.getWriter().writeEnumAttribute("topologyKind", (Enum)topologyLevel.getTopologyKind());
    }

    @Override
    protected void writeSubElements(VoltageLevel vl, Container<? extends Identifiable<?>> c, NetworkSerializerContext context) {
        TopologyLevel topologyLevel = TopologyLevel.min((TopologyKind)vl.getTopologyKind(), (TopologyLevel)context.getOptions().getTopologyLevel());
        switch (topologyLevel) {
            case NODE_BREAKER: {
                this.writeNodeBreakerTopology(vl, context);
                break;
            }
            case BUS_BREAKER: {
                this.writeBusBreakerTopology(vl, context);
                break;
            }
            case BUS_BRANCH: {
                this.writeBusBranchTopology(vl, context);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected TopologyLevel value: " + topologyLevel);
            }
        }
        this.writeGenerators(vl, context);
        this.writeBatteries(vl, context);
        this.writeLoads(vl, context);
        this.writeShuntCompensators(vl, context);
        this.writeDanglingLines(vl, context);
        this.writeStaticVarCompensators(vl, context);
        this.writeVscConverterStations(vl, context);
        this.writeLccConverterStations(vl, context);
        this.writeGrounds(vl, context);
    }

    private void writeNodeBreakerTopology(VoltageLevel vl, NetworkSerializerContext context) {
        context.getWriter().writeStartNode(context.getVersion().getNamespaceURI(context.isValid()), NODE_BREAKER_TOPOLOGY_ELEMENT_NAME);
        IidmSerDeUtil.writeIntAttributeUntilMaximumVersion(NODE_COUNT, vl.getNodeBreakerView().getMaximumNodeIndex() + 1, IidmVersion.V_1_1, context);
        context.getWriter().writeStartNodes();
        for (BusbarSection bs : IidmSerDeUtil.sorted(vl.getNodeBreakerView().getBusbarSections(), context.getOptions())) {
            BusbarSectionSerDe.INSTANCE.write(bs, null, context);
        }
        context.getWriter().writeEndNodes();
        context.getWriter().writeStartNodes();
        for (Switch sw : IidmSerDeUtil.sorted(vl.getNodeBreakerView().getSwitches(), context.getOptions())) {
            NodeBreakerViewSwitchSerDe.INSTANCE.write(sw, vl, context);
        }
        context.getWriter().writeEndNodes();
        this.writeNodeBreakerTopologyInternalConnections(vl, context);
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_1, context, () -> {
            Map nodesByBus = Networks.getNodesByBus((VoltageLevel)vl);
            context.getWriter().writeStartNodes();
            IidmSerDeUtil.sorted(vl.getBusView().getBusStream(), context.getOptions()).filter(bus -> !Double.isNaN(bus.getV()) || !Double.isNaN(bus.getAngle())).forEach(bus -> {
                Set nodes = (Set)nodesByBus.get(bus.getId());
                VoltageLevelSerDe.writeCalculatedBus(bus, nodes, context);
            });
            context.getWriter().writeEndNodes();
        });
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_8, context, () -> {
            context.getWriter().writeStartNodes();
            for (int node : vl.getNodeBreakerView().getNodes()) {
                double fictP0 = vl.getNodeBreakerView().getFictitiousP0(node);
                double fictQ0 = vl.getNodeBreakerView().getFictitiousQ0(node);
                if (fictP0 == 0.0 && fictQ0 == 0.0) continue;
                context.getWriter().writeStartNode(context.getVersion().getNamespaceURI(context.isValid()), INJ_ROOT_ELEMENT_NAME);
                context.getWriter().writeIntAttribute("node", node);
                context.getWriter().writeDoubleAttribute("fictitiousP0", fictP0, 0.0);
                context.getWriter().writeDoubleAttribute("fictitiousQ0", fictQ0, 0.0);
                context.getWriter().writeEndNode();
            }
            context.getWriter().writeEndNodes();
        });
        context.getWriter().writeEndNode();
    }

    private static void writeCalculatedBus(Bus bus, Set<Integer> nodes, NetworkSerializerContext context) {
        context.getWriter().writeStartNode(context.getVersion().getNamespaceURI(context.isValid()), "bus");
        context.getWriter().writeDoubleAttribute("v", bus.getV());
        context.getWriter().writeDoubleAttribute("angle", bus.getAngle());
        context.getWriter().writeIntArrayAttribute("nodes", nodes);
        if (context.getVersion().compareTo(IidmVersion.V_1_11) >= 0 && bus.hasProperty()) {
            PropertiesSerDe.write(bus, context);
        }
        context.getWriter().writeEndNode();
    }

    private void writeNodeBreakerTopologyInternalConnections(VoltageLevel vl, NetworkSerializerContext context) {
        context.getWriter().writeStartNodes();
        for (VoltageLevel.NodeBreakerView.InternalConnection ic : IidmSerDeUtil.sortedInternalConnections(vl.getNodeBreakerView().getInternalConnections(), context.getOptions())) {
            NodeBreakerViewInternalConnectionSerDe.INSTANCE.write(ic.getNode1(), ic.getNode2(), context);
        }
        context.getWriter().writeEndNodes();
    }

    private void writeBusBreakerTopology(VoltageLevel vl, NetworkSerializerContext context) {
        context.getWriter().writeStartNode(context.getVersion().getNamespaceURI(context.isValid()), BUS_BREAKER_TOPOLOGY_ELEMENT_NAME);
        context.getWriter().writeStartNodes();
        for (Bus b : IidmSerDeUtil.sorted(vl.getBusBreakerView().getBuses(), context.getOptions())) {
            if (!context.getFilter().test(b)) continue;
            BusSerDe.INSTANCE.write(b, null, context);
        }
        context.getWriter().writeEndNodes();
        context.getWriter().writeStartNodes();
        for (Switch sw : IidmSerDeUtil.sorted(vl.getBusBreakerView().getSwitches(), context.getOptions())) {
            Bus b1 = vl.getBusBreakerView().getBus1(sw.getId());
            Bus b2 = vl.getBusBreakerView().getBus2(sw.getId());
            if (!context.getFilter().test(b1) || !context.getFilter().test(b2)) continue;
            BusBreakerViewSwitchSerDe.INSTANCE.write(sw, vl, context);
        }
        context.getWriter().writeEndNodes();
        context.getWriter().writeEndNode();
    }

    private void writeBusBranchTopology(VoltageLevel vl, NetworkSerializerContext context) {
        context.getWriter().writeStartNode(context.getVersion().getNamespaceURI(context.isValid()), BUS_BREAKER_TOPOLOGY_ELEMENT_NAME);
        context.getWriter().writeStartNodes();
        for (Bus b : IidmSerDeUtil.sorted(vl.getBusView().getBuses(), context.getOptions())) {
            if (!context.getFilter().test(b)) continue;
            BusSerDe.INSTANCE.write(b, null, context);
        }
        context.getWriter().writeEndNodes();
        context.getWriter().writeEndNode();
    }

    private void writeGenerators(VoltageLevel vl, NetworkSerializerContext context) {
        context.getWriter().writeStartNodes();
        for (Generator g : IidmSerDeUtil.sorted(vl.getGenerators(), context.getOptions())) {
            if (!context.getFilter().test((Connectable<?>)g)) continue;
            GeneratorSerDe.INSTANCE.write(g, vl, context);
        }
        context.getWriter().writeEndNodes();
    }

    private void writeBatteries(VoltageLevel vl, NetworkSerializerContext context) {
        context.getWriter().writeStartNodes();
        for (Battery b : IidmSerDeUtil.sorted(vl.getBatteries(), context.getOptions())) {
            if (!context.getFilter().test((Connectable<?>)b)) continue;
            BatterySerDe.INSTANCE.write(b, vl, context);
        }
        context.getWriter().writeEndNodes();
    }

    private void writeLoads(VoltageLevel vl, NetworkSerializerContext context) {
        context.getWriter().writeStartNodes();
        for (Load l : IidmSerDeUtil.sorted(vl.getLoads(), context.getOptions())) {
            if (!context.getFilter().test((Connectable<?>)l)) continue;
            LoadSerDe.INSTANCE.write(l, vl, context);
        }
        context.getWriter().writeEndNodes();
    }

    private void writeShuntCompensators(VoltageLevel vl, NetworkSerializerContext context) {
        context.getWriter().writeStartNodes();
        for (ShuntCompensator sc : IidmSerDeUtil.sorted(vl.getShuntCompensators(), context.getOptions())) {
            if (!context.getFilter().test((Connectable<?>)sc)) continue;
            ShuntSerDe.INSTANCE.write(sc, vl, context);
        }
        context.getWriter().writeEndNodes();
    }

    private void writeDanglingLines(VoltageLevel vl, NetworkSerializerContext context) {
        context.getWriter().writeStartNodes();
        for (DanglingLine dl : IidmSerDeUtil.sorted(vl.getDanglingLines(DanglingLineFilter.ALL), context.getOptions())) {
            if (!context.getFilter().test((Connectable<?>)dl) || context.getVersion().compareTo(IidmVersion.V_1_10) < 0 && dl.isPaired()) continue;
            DanglingLineSerDe.INSTANCE.write(dl, vl, context);
        }
        context.getWriter().writeEndNodes();
    }

    private void writeStaticVarCompensators(VoltageLevel vl, NetworkSerializerContext context) {
        context.getWriter().writeStartNodes();
        for (StaticVarCompensator svc : IidmSerDeUtil.sorted(vl.getStaticVarCompensators(), context.getOptions())) {
            if (!context.getFilter().test((Connectable<?>)svc)) continue;
            StaticVarCompensatorSerDe.INSTANCE.write(svc, vl, context);
        }
        context.getWriter().writeEndNodes();
    }

    private void writeVscConverterStations(VoltageLevel vl, NetworkSerializerContext context) {
        context.getWriter().writeStartNodes();
        for (VscConverterStation cs : IidmSerDeUtil.sorted(vl.getVscConverterStations(), context.getOptions())) {
            if (!context.getFilter().test((Connectable<?>)cs)) continue;
            VscConverterStationSerDe.INSTANCE.write(cs, vl, context);
        }
        context.getWriter().writeEndNodes();
    }

    private void writeLccConverterStations(VoltageLevel vl, NetworkSerializerContext context) {
        context.getWriter().writeStartNodes();
        for (LccConverterStation cs : IidmSerDeUtil.sorted(vl.getLccConverterStations(), context.getOptions())) {
            if (!context.getFilter().test((Connectable<?>)cs)) continue;
            LccConverterStationSerDe.INSTANCE.write(cs, vl, context);
        }
        context.getWriter().writeEndNodes();
    }

    private void writeGrounds(VoltageLevel vl, NetworkSerializerContext context) {
        context.getWriter().writeStartNodes();
        for (Ground g : IidmSerDeUtil.sorted(vl.getGrounds(), context.getOptions())) {
            if (!context.getFilter().test((Connectable<?>)g)) continue;
            GroundSerDe.INSTANCE.write(g, vl, context);
        }
        context.getWriter().writeEndNodes();
    }

    @Override
    protected VoltageLevelAdder createAdder(Container<? extends Identifiable<?>> c) {
        if (c instanceof Network) {
            Network network = (Network)c;
            return network.newVoltageLevel();
        }
        if (c instanceof Substation) {
            Substation substation = (Substation)c;
            return substation.newVoltageLevel();
        }
        throw new IllegalStateException();
    }

    @Override
    protected VoltageLevel readRootElementAttributes(VoltageLevelAdder adder, Container<? extends Identifiable<?>> c, NetworkDeserializerContext context) {
        double nominalV = context.getReader().readDoubleAttribute("nominalV");
        double lowVoltageLimit = context.getReader().readDoubleAttribute("lowVoltageLimit");
        double highVoltageLimit = context.getReader().readDoubleAttribute("highVoltageLimit");
        TopologyKind topologyKind = (TopologyKind)context.getReader().readEnumAttribute("topologyKind", TopologyKind.class);
        return adder.setNominalV(nominalV).setLowVoltageLimit(lowVoltageLimit).setHighVoltageLimit(highVoltageLimit).setTopologyKind(topologyKind).add();
    }

    @Override
    protected void readSubElements(VoltageLevel vl, NetworkDeserializerContext context) {
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "nodeBreakerTopology": {
                    this.readNodeBreakerTopology(vl, context);
                    break;
                }
                case "busBreakerTopology": {
                    this.readBusBreakerTopology(vl, context);
                    break;
                }
                case "generator": {
                    GeneratorSerDe.INSTANCE.read(vl, context);
                    break;
                }
                case "battery": {
                    BatterySerDe.INSTANCE.read(vl, context);
                    break;
                }
                case "load": {
                    LoadSerDe.INSTANCE.read(vl, context);
                    break;
                }
                case "shunt": {
                    ShuntSerDe.INSTANCE.read(vl, context);
                    break;
                }
                case "danglingLine": {
                    DanglingLineSerDe.INSTANCE.read(vl, context);
                    break;
                }
                case "staticVarCompensator": {
                    StaticVarCompensatorSerDe.INSTANCE.read(vl, context);
                    break;
                }
                case "vscConverterStation": {
                    VscConverterStationSerDe.INSTANCE.read(vl, context);
                    break;
                }
                case "lccConverterStation": {
                    LccConverterStationSerDe.INSTANCE.read(vl, context);
                    break;
                }
                case "ground": {
                    GroundSerDe.INSTANCE.read(vl, context);
                    break;
                }
                default: {
                    this.readSubElement(elementName, vl, context);
                }
            }
        });
    }

    private void readNodeBreakerTopology(VoltageLevel vl, NetworkDeserializerContext context) {
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_1, context, () -> {
            context.getReader().readIntAttribute(NODE_COUNT);
            LOGGER.trace("attribute nodeBreakerTopology.nodeCount is ignored.");
        });
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "busbarSection": {
                    BusbarSectionSerDe.INSTANCE.read(vl, context);
                    break;
                }
                case "switch": {
                    NodeBreakerViewSwitchSerDe.INSTANCE.read(vl, context);
                    break;
                }
                case "internalConnection": {
                    NodeBreakerViewInternalConnectionSerDe.INSTANCE.read(vl, context);
                    break;
                }
                case "bus": {
                    this.readCalculatedBus(vl, context);
                    break;
                }
                case "inj": {
                    this.readFictitiousInjection(vl, context);
                    break;
                }
                default: {
                    throw new PowsyblException(String.format("Unknown element name '%s' in 'nodeBreakerTopology'", elementName));
                }
            }
        });
    }

    private void readCalculatedBus(VoltageLevel vl, NetworkDeserializerContext context) {
        IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "bus", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_1, context);
        double v = context.getReader().readDoubleAttribute("v");
        double angle = context.getReader().readDoubleAttribute("angle");
        List busNodes = context.getReader().readIntArrayAttribute("nodes");
        HashMap properties = new HashMap();
        context.getReader().readChildNodes(elementName -> {
            if (!elementName.equals("property")) {
                throw new PowsyblException(String.format("Unknown element name '%s' in 'bus'", elementName));
            }
            String name = context.getReader().readStringAttribute("name");
            String value = context.getReader().readStringAttribute("value");
            context.getReader().readEndNode();
            properties.put(name, value);
        });
        context.getEndTasks().add(() -> {
            Iterator iterator = busNodes.iterator();
            while (iterator.hasNext()) {
                Bus b;
                int node = (Integer)iterator.next();
                Terminal terminal = vl.getNodeBreakerView().getTerminal(node);
                if (terminal == null || (b = terminal.getBusView().getBus()) == null) continue;
                b.setV(v).setAngle(angle);
                properties.forEach((arg_0, arg_1) -> ((Bus)b).setProperty(arg_0, arg_1));
                break;
            }
        });
    }

    private void readFictitiousInjection(VoltageLevel vl, NetworkDeserializerContext context) {
        IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, INJ_ROOT_ELEMENT_NAME, IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_8, context);
        int node = context.getReader().readIntAttribute("node");
        double p0 = context.getReader().readDoubleAttribute("fictitiousP0");
        double q0 = context.getReader().readDoubleAttribute("fictitiousQ0");
        context.getReader().readEndNode();
        if (!Double.isNaN(p0)) {
            vl.getNodeBreakerView().setFictitiousP0(node, p0);
        }
        if (!Double.isNaN(q0)) {
            vl.getNodeBreakerView().setFictitiousQ0(node, q0);
        }
    }

    private void readBusBreakerTopology(VoltageLevel vl, NetworkDeserializerContext context) {
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "bus": {
                    BusSerDe.INSTANCE.read(vl, context);
                    break;
                }
                case "switch": {
                    BusBreakerViewSwitchSerDe.INSTANCE.read(vl, context);
                    break;
                }
                default: {
                    throw new PowsyblException(String.format("Unknown element name '%s' in 'busBreakerTopology'", elementName));
                }
            }
        });
    }
}

