/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.serde.AbstractSimpleIdentifiableSerDe;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;

abstract class AbstractSwitchSerDe<A extends IdentifiableAdder<Switch, A>>
extends AbstractSimpleIdentifiableSerDe<Switch, A, VoltageLevel> {
    static final String ROOT_ELEMENT_NAME = "switch";
    static final String ARRAY_ELEMENT_NAME = "switches";

    AbstractSwitchSerDe() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected void writeRootElementAttributes(Switch s, VoltageLevel vl, NetworkSerializerContext context) {
        context.getWriter().writeEnumAttribute("kind", (Enum)s.getKind());
        context.getWriter().writeBooleanAttribute("retained", s.isRetained());
        context.getWriter().writeBooleanAttribute("open", s.isOpen());
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_1, context, () -> context.getWriter().writeBooleanAttribute("fictitious", s.isFictitious(), false));
    }

    @Override
    protected void readSubElements(Switch s, NetworkDeserializerContext context) {
        context.getReader().readChildNodes(elementName -> this.readSubElement(elementName, s, context));
    }
}

