/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.google.common.collect.Sets;
import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.serde.AbstractOptions;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public class ImportOptions
extends AbstractOptions<ImportOptions> {
    private boolean throwExceptionIfExtensionNotFound = false;
    private boolean withAutomationSystems = true;
    private double missingPermanentLimitPercentage = 100.0;
    private ValidationLevel minimalValidationLevel = null;

    public ImportOptions() {
    }

    public ImportOptions(boolean throwExceptionIfExtensionNotFound) {
        this.throwExceptionIfExtensionNotFound = throwExceptionIfExtensionNotFound;
    }

    @Override
    public ImportOptions setExtensions(Set<String> extensions) {
        this.extensions = extensions;
        return this;
    }

    public ImportOptions setThrowExceptionIfExtensionNotFound(boolean throwExceptionIfExtensionNotFound) {
        this.throwExceptionIfExtensionNotFound = throwExceptionIfExtensionNotFound;
        return this;
    }

    @Override
    public ImportOptions addExtension(String extension) {
        if (this.extensions != null) {
            this.extensions.add(extension);
        } else {
            this.extensions = Sets.newHashSet((Object[])new String[]{extension});
        }
        return this;
    }

    @Override
    public boolean isThrowExceptionIfExtensionNotFound() {
        return this.throwExceptionIfExtensionNotFound;
    }

    public boolean isWithAutomationSystems() {
        return this.withAutomationSystems;
    }

    public ImportOptions setWithAutomationSystems(boolean withAutomationSystems) {
        this.withAutomationSystems = withAutomationSystems;
        return this;
    }

    public ImportOptions setMissingPermanentLimitPercentage(double missingPermanentLimitPercentage) {
        if (missingPermanentLimitPercentage < 0.0 || missingPermanentLimitPercentage > 100.0) {
            throw new IllegalArgumentException("Missing permanent limit percentage must be between 0 and 100.");
        }
        this.missingPermanentLimitPercentage = missingPermanentLimitPercentage;
        return this;
    }

    public double getMissingPermanentLimitPercentage() {
        return this.missingPermanentLimitPercentage;
    }

    public ImportOptions setMinimalValidationLevel(String minimalValidationLevel) {
        if (minimalValidationLevel != null) {
            if (Stream.of(ValidationLevel.values()).map(Enum::name).noneMatch(n -> n.equals(minimalValidationLevel))) {
                throw new PowsyblException("Unexpected value for minimalValidationLevel: " + minimalValidationLevel);
            }
            this.minimalValidationLevel = ValidationLevel.valueOf((String)minimalValidationLevel);
        }
        return this;
    }

    public Optional<ValidationLevel> getMinimalValidationLevel() {
        return Optional.ofNullable(this.minimalValidationLevel);
    }
}

