/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.Switch;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.serde.AbstractSwitchSerDe;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeBreakerViewSwitchSerDe
extends AbstractSwitchSerDe<VoltageLevel.NodeBreakerView.SwitchAdder> {
    static final NodeBreakerViewSwitchSerDe INSTANCE = new NodeBreakerViewSwitchSerDe();
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeBreakerViewSwitchSerDe.class);

    @Override
    protected boolean isValid(Switch s, VoltageLevel vl) {
        VoltageLevel.NodeBreakerView v = vl.getNodeBreakerView();
        if (v.getNode1(s.getId()) == v.getNode2(s.getId())) {
            LOGGER.warn("Discard switch with same node at both ends. Id: {}", (Object)s.getId());
            return false;
        }
        return true;
    }

    @Override
    protected void writeRootElementAttributes(Switch s, VoltageLevel vl, NetworkSerializerContext context) {
        super.writeRootElementAttributes(s, vl, context);
        VoltageLevel.NodeBreakerView v = vl.getNodeBreakerView();
        context.getWriter().writeIntAttribute("node1", v.getNode1(s.getId()));
        context.getWriter().writeIntAttribute("node2", v.getNode2(s.getId()));
    }

    @Override
    protected VoltageLevel.NodeBreakerView.SwitchAdder createAdder(VoltageLevel vl) {
        return vl.getNodeBreakerView().newSwitch();
    }

    @Override
    protected Switch readRootElementAttributes(VoltageLevel.NodeBreakerView.SwitchAdder adder, VoltageLevel voltageLevel, NetworkDeserializerContext context) {
        SwitchKind kind = (SwitchKind)context.getReader().readEnumAttribute("kind", SwitchKind.class);
        boolean retained = context.getReader().readBooleanAttribute("retained");
        boolean open = context.getReader().readBooleanAttribute("open");
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_1, context, () -> {
            boolean fictitious = context.getReader().readBooleanAttribute("fictitious", false);
            adder.setFictitious(fictitious);
        });
        int node1 = context.getReader().readIntAttribute("node1");
        int node2 = context.getReader().readIntAttribute("node2");
        if (node1 == node2 && context.getVersion().compareTo(IidmVersion.V_1_8) < 0) {
            LOGGER.warn("Discard switch with same node {} at both ends", (Object)node1);
            return null;
        }
        return adder.setKind(kind).setRetained(retained).setOpen(open).setNode1(node1).setNode2(node2).add();
    }
}

