/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.extensions.AbstractExtensionSerDe;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.extensions.LineFortescue;
import com.powsybl.iidm.network.extensions.LineFortescueAdder;

@AutoService(value={ExtensionSerDe.class})
public class LineFortescueSerDe
extends AbstractExtensionSerDe<Line, LineFortescue> {
    public LineFortescueSerDe() {
        super("lineFortescue", "network", LineFortescue.class, "lineFortescue_V1_0.xsd", "http://www.powsybl.org/schema/iidm/ext/line_fortescue/1_0", "lf");
    }

    public void write(LineFortescue lineFortescue, SerializerContext context) {
        context.getWriter().writeDoubleAttribute("rz", lineFortescue.getRz(), Double.NaN);
        context.getWriter().writeDoubleAttribute("xz", lineFortescue.getXz(), Double.NaN);
        context.getWriter().writeBooleanAttribute("openPhaseA", lineFortescue.isOpenPhaseA(), false);
        context.getWriter().writeBooleanAttribute("openPhaseB", lineFortescue.isOpenPhaseB(), false);
        context.getWriter().writeBooleanAttribute("openPhaseC", lineFortescue.isOpenPhaseC(), false);
    }

    public LineFortescue read(Line line, DeserializerContext context) {
        double rz = context.getReader().readDoubleAttribute("rz");
        double xz = context.getReader().readDoubleAttribute("xz");
        boolean openPhaseA = context.getReader().readBooleanAttribute("openPhaseA", false);
        boolean openPhaseB = context.getReader().readBooleanAttribute("openPhaseB", false);
        boolean openPhaseC = context.getReader().readBooleanAttribute("openPhaseC", false);
        context.getReader().readEndNode();
        return (LineFortescue)((LineFortescueAdder)line.newExtension(LineFortescueAdder.class)).withRz(rz).withXz(xz).withOpenPhaseA(openPhaseA).withOpenPhaseB(openPhaseB).withOpenPhaseC(openPhaseC).add();
    }
}

