/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.serde.AbstractIdentifiableSerDe;
import com.powsybl.iidm.serde.AliasesSerDe;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.PropertiesSerDe;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;

abstract class AbstractSimpleIdentifiableSerDe<T extends Identifiable<? super T>, A extends IdentifiableAdder<T, A>, P extends Identifiable>
extends AbstractIdentifiableSerDe<T, A, P> {
    AbstractSimpleIdentifiableSerDe() {
    }

    protected abstract T readRootElementAttributes(A var1, P var2, NetworkDeserializerContext var3);

    protected void readSubElement(String elementName, T identifiable, NetworkDeserializerContext context) {
        switch (elementName) {
            case "property": {
                PropertiesSerDe.read(identifiable, context);
                break;
            }
            case "alias": {
                IidmSerDeUtil.assertMinimumVersion(this.getRootElementName(), "alias", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_3, context);
                AliasesSerDe.read(identifiable, context);
                break;
            }
            default: {
                throw new PowsyblException("Unknown element name '" + elementName + "' in '" + identifiable.getId() + "'");
            }
        }
    }

    @Override
    public final void read(P parent, NetworkDeserializerContext context) {
        Object adder = this.createAdder(parent);
        this.readIdentifierAttributes(adder, context);
        T identifiable = this.readRootElementAttributes(adder, parent, context);
        if (identifiable != null) {
            this.readSubElements(identifiable, context);
        } else {
            context.getReader().skipNode();
        }
    }

    protected abstract void readSubElements(T var1, NetworkDeserializerContext var2);
}

