/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.AbstractExtensionSerDe;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.extensions.Coordinate;
import com.powsybl.iidm.network.extensions.SubstationPosition;
import com.powsybl.iidm.network.extensions.SubstationPositionAdder;

@AutoService(value={ExtensionSerDe.class})
public class SubstationPositionSerDe
extends AbstractExtensionSerDe<Substation, SubstationPosition> {
    private static final String COORDINATE_ROOT_NODE = "coordinate";

    public SubstationPositionSerDe() {
        super("substationPosition", "network", SubstationPosition.class, "substationPosition.xsd", "http://www.powsybl.org/schema/iidm/ext/substation_position/1_0", "sp");
    }

    public void write(SubstationPosition substationPosition, SerializerContext context) {
        context.getWriter().writeStartNode(this.getNamespaceUri(), COORDINATE_ROOT_NODE);
        context.getWriter().writeDoubleAttribute("longitude", substationPosition.getCoordinate().getLongitude());
        context.getWriter().writeDoubleAttribute("latitude", substationPosition.getCoordinate().getLatitude());
        context.getWriter().writeEndNode();
    }

    public SubstationPosition read(Substation substation, DeserializerContext context) {
        Coordinate[] coordinate = new Coordinate[1];
        context.getReader().readChildNodes(e -> {
            if (!e.equals(COORDINATE_ROOT_NODE)) {
                throw new PowsyblException("Unknown element name '" + e + "' in 'substationPosition'");
            }
            double longitude = context.getReader().readDoubleAttribute("longitude");
            double latitude = context.getReader().readDoubleAttribute("latitude");
            context.getReader().readEndNode();
            coordinate[0] = new Coordinate(latitude, longitude);
        });
        return (SubstationPosition)((SubstationPositionAdder)substation.newExtension(SubstationPositionAdder.class)).withCoordinate(coordinate[0]).add();
    }
}

