/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.Area;
import com.powsybl.iidm.network.AreaAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.serde.AbstractSimpleIdentifiableSerDe;
import com.powsybl.iidm.serde.AreaBoundarySerDe;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.VoltageLevelRefSerDe;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;
import java.util.OptionalDouble;

public class AreaSerDe
extends AbstractSimpleIdentifiableSerDe<Area, AreaAdder, Network> {
    static final AreaSerDe INSTANCE = new AreaSerDe();
    static final String ROOT_ELEMENT_NAME = "area";
    static final String ARRAY_ELEMENT_NAME = "areas";

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected void writeRootElementAttributes(Area area, Network parent, NetworkSerializerContext context) {
        context.getWriter().writeStringAttribute("areaType", context.getAnonymizer().anonymizeString(area.getAreaType()));
        Double interchangeTarget = null;
        if (area.getInterchangeTarget().isPresent()) {
            interchangeTarget = area.getInterchangeTarget().getAsDouble();
        }
        context.getWriter().writeOptionalDoubleAttribute("interchangeTarget", interchangeTarget);
    }

    @Override
    protected void writeSubElements(Area area, Network parent, NetworkSerializerContext context) {
        this.writeVoltageLevels(area, context);
        AreaBoundarySerDe.INSTANCE.write(area, context);
    }

    private void writeVoltageLevels(Area area, NetworkSerializerContext context) {
        for (VoltageLevel voltageLevel : IidmSerDeUtil.sorted(area.getVoltageLevels(), context.getOptions())) {
            VoltageLevelRefSerDe.writeVoltageLevelRef(voltageLevel, context);
        }
    }

    @Override
    protected AreaAdder createAdder(Network network) {
        return network.newArea();
    }

    @Override
    protected Area readRootElementAttributes(AreaAdder adder, Network parent, NetworkDeserializerContext context) {
        String areaType = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute("areaType"));
        adder.setAreaType(areaType);
        OptionalDouble interchangeTarget = context.getReader().readOptionalDoubleAttribute("interchangeTarget");
        interchangeTarget.ifPresent(arg_0 -> ((AreaAdder)adder).setInterchangeTarget(arg_0));
        return adder.add();
    }

    @Override
    protected void readSubElements(Area area, NetworkDeserializerContext context) {
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "voltageLevelRef": {
                    VoltageLevelRefSerDe.readVoltageLevelRef(context, area.getNetwork(), arg_0 -> ((Area)area).addVoltageLevel(arg_0));
                    break;
                }
                case "areaBoundary": {
                    AreaBoundarySerDe.INSTANCE.read(area, context);
                    break;
                }
                default: {
                    this.readSubElement(elementName, area, context);
                }
            }
        });
    }
}

