/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.serde.DeserializationEndTask;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import java.util.function.Consumer;

public final class VoltageLevelRefSerDe {
    private static final String ID = "id";
    public static final String ROOT_ELEMENT_NAME = "voltageLevelRef";

    public static void readVoltageLevelRef(NetworkDeserializerContext context, Network network, Consumer<VoltageLevel> endTaskTerminalConsumer) {
        String id = context.getAnonymizer().deanonymizeString(context.getReader().readStringAttribute(ID));
        context.getReader().readEndNode();
        context.addEndTask(DeserializationEndTask.Step.AFTER_EXTENSIONS, () -> {
            VoltageLevel voltageLevel = network.getVoltageLevel(id);
            endTaskTerminalConsumer.accept(voltageLevel);
        });
    }

    public static void writeVoltageLevelRef(VoltageLevel voltageLevel, NetworkSerializerContext context) {
        context.getWriter().writeStartNode(context.getVersion().getNamespaceURI(context.isValid()), ROOT_ELEMENT_NAME);
        context.getWriter().writeStringAttribute(ID, context.getAnonymizer().anonymizeString(voltageLevel.getId()));
        context.getWriter().writeEndNode();
    }

    private VoltageLevelRefSerDe() {
    }
}

