/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde.extensions;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.extensions.BatteryShortCircuit;
import com.powsybl.iidm.network.extensions.BatteryShortCircuitAdder;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.extensions.AbstractVersionableNetworkExtensionSerDe;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@AutoService(value={ExtensionSerDe.class})
public class BatteryShortCircuitSerDe
extends AbstractVersionableNetworkExtensionSerDe<Battery, BatteryShortCircuit> {
    public static final String V1_0_LEGACY = "1.0-legacy";
    public static final String V1_0_LEGACY_2 = "1.0-legacy-2";
    private static final ImmutableSortedSet<String> LEGACY_VERSIONS = ImmutableSortedSet.reverseOrder().add((Object[])new String[]{"1.0-legacy", "1.0-legacy-2"}).build();

    public BatteryShortCircuitSerDe() {
        super("batteryShortCircuit", BatteryShortCircuit.class, "bsc", (Map<IidmVersion, ImmutableSortedSet<String>>)new ImmutableMap.Builder().put((Object)IidmVersion.V_1_0, LEGACY_VERSIONS).put((Object)IidmVersion.V_1_1, LEGACY_VERSIONS).put((Object)IidmVersion.V_1_2, LEGACY_VERSIONS).put((Object)IidmVersion.V_1_3, LEGACY_VERSIONS).put((Object)IidmVersion.V_1_4, LEGACY_VERSIONS).put((Object)IidmVersion.V_1_5, LEGACY_VERSIONS).put((Object)IidmVersion.V_1_6, LEGACY_VERSIONS).put((Object)IidmVersion.V_1_7, LEGACY_VERSIONS).put((Object)IidmVersion.V_1_8, LEGACY_VERSIONS).put((Object)IidmVersion.V_1_9, LEGACY_VERSIONS).put((Object)IidmVersion.V_1_10, LEGACY_VERSIONS).put((Object)IidmVersion.V_1_11, LEGACY_VERSIONS).put((Object)IidmVersion.V_1_12, LEGACY_VERSIONS).put((Object)IidmVersion.V_1_13, (Object)ImmutableSortedSet.reverseOrder().add((Object[])new String[]{V1_0_LEGACY, V1_0_LEGACY_2, "1.0"}).build()).build(), (Map<String, String>)new ImmutableMap.Builder().put((Object)V1_0_LEGACY, (Object)"http://www.itesla_project.eu/schema/iidm/ext/battery_short_circuits/1_0").put((Object)V1_0_LEGACY_2, (Object)"http://www.itesla_project.eu/schema/iidm/ext/batteryshortcircuits/1_0").put((Object)"1.0", (Object)"http://www.itesla_project.eu/schema/iidm/ext/battery_short_circuit/1_0").build(), List.of(new AbstractVersionableNetworkExtensionSerDe.AlternativeSerializationData("batteryShortCircuits", List.copyOf(LEGACY_VERSIONS))));
    }

    public InputStream getXsdAsStream() {
        return this.getClass().getResourceAsStream("/xsd/batteryShortCircuit_V1_0.xsd");
    }

    public List<InputStream> getXsdAsStreamList() {
        return List.of(Objects.requireNonNull(this.getClass().getResourceAsStream("/xsd/batteryShortCircuit_V1_0.xsd")), Objects.requireNonNull(this.getClass().getResourceAsStream("/xsd/batteryShortCircuit_V1_0_legacy.xsd")), Objects.requireNonNull(this.getClass().getResourceAsStream("/xsd/batteryShortCircuit_V1_0_legacy_2.xsd")));
    }

    public void write(BatteryShortCircuit batteryShortCircuit, SerializerContext context) {
        NetworkSerializerContext networkContext = (NetworkSerializerContext)context;
        String extVersionStr = networkContext.getExtensionVersion(this.getExtensionName()).orElseGet(() -> this.getVersion(networkContext.getVersion()));
        if (LEGACY_VERSIONS.contains((Object)extVersionStr)) {
            context.getWriter().writeFloatAttribute("transientReactance", (float)batteryShortCircuit.getDirectTransX());
            context.getWriter().writeFloatAttribute("stepUpTransformerReactance", (float)batteryShortCircuit.getStepUpTransformerX());
        } else {
            context.getWriter().writeDoubleAttribute("directSubtransX", batteryShortCircuit.getDirectSubtransX());
            context.getWriter().writeDoubleAttribute("directTransX", batteryShortCircuit.getDirectTransX());
            context.getWriter().writeDoubleAttribute("stepUpTransformerX", batteryShortCircuit.getStepUpTransformerX());
        }
    }

    public BatteryShortCircuit read(Battery battery, DeserializerContext context) {
        NetworkDeserializerContext networkContext = (NetworkDeserializerContext)context;
        String extVersionStr = networkContext.getExtensionVersion(this).orElseThrow(IllegalStateException::new);
        BatteryShortCircuitAdder batteryShortCircuitAdder = (BatteryShortCircuitAdder)battery.newExtension(BatteryShortCircuitAdder.class);
        if (LEGACY_VERSIONS.contains((Object)extVersionStr)) {
            ((BatteryShortCircuitAdder)batteryShortCircuitAdder.withDirectTransX((double)context.getReader().readFloatAttribute("transientReactance"))).withStepUpTransformerX((double)context.getReader().readFloatAttribute("stepUpTransformerReactance"));
        } else {
            ((BatteryShortCircuitAdder)((BatteryShortCircuitAdder)batteryShortCircuitAdder.withDirectSubtransX(context.getReader().readDoubleAttribute("directSubtransX"))).withDirectTransX(context.getReader().readDoubleAttribute("directTransX"))).withStepUpTransformerX(context.getReader().readDoubleAttribute("stepUpTransformerX"));
        }
        context.getReader().readEndNode();
        return (BatteryShortCircuit)batteryShortCircuitAdder.add();
    }
}

