/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.AbstractExtensionSerDe;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.iidm.network.Branch;
import com.powsybl.iidm.network.TwoSides;
import com.powsybl.iidm.network.extensions.BranchObservability;
import com.powsybl.iidm.network.extensions.BranchObservabilityAdder;
import com.powsybl.iidm.network.extensions.ObservabilityQuality;

@AutoService(value={ExtensionSerDe.class})
public class BranchObservabilitySerDe<T extends Branch<T>>
extends AbstractExtensionSerDe<T, BranchObservability<T>> {
    private static final String QUALITY_P = "qualityP";
    private static final String QUALITY_Q = "qualityQ";
    private static final String SIDE = "side";
    private static final String STANDARD_DEVIATION = "standardDeviation";
    private static final String REDUNDANT = "redundant";

    public BranchObservabilitySerDe() {
        super("branchObservability", "network", BranchObservability.class, "branchObservability.xsd", "http://www.itesla_project.eu/schema/iidm/ext/branch_observability/1_0", "bo");
    }

    public void write(BranchObservability<T> branchObservability, SerializerContext context) {
        context.getWriter().writeBooleanAttribute("observable", branchObservability.isObservable(), false);
        this.writeOptionalQuality(context, branchObservability.getQualityP1(), QUALITY_P, TwoSides.ONE);
        this.writeOptionalQuality(context, branchObservability.getQualityP2(), QUALITY_P, TwoSides.TWO);
        this.writeOptionalQuality(context, branchObservability.getQualityQ1(), QUALITY_Q, TwoSides.ONE);
        this.writeOptionalQuality(context, branchObservability.getQualityQ2(), QUALITY_Q, TwoSides.TWO);
    }

    private void writeOptionalQuality(SerializerContext context, ObservabilityQuality<T> quality, String type, TwoSides side) {
        if (quality != null) {
            context.getWriter().writeStartNode(this.getNamespaceUri(), type);
            context.getWriter().writeEnumAttribute(SIDE, (Enum)side);
            context.getWriter().writeDoubleAttribute(STANDARD_DEVIATION, quality.getStandardDeviation());
            context.getWriter().writeOptionalBooleanAttribute(REDUNDANT, (Boolean)quality.isRedundant().orElse(null));
            context.getWriter().writeEndNode();
        }
    }

    public BranchObservability<T> read(T identifiable, DeserializerContext context) {
        boolean observable = context.getReader().readBooleanAttribute("observable", false);
        BranchObservabilityAdder adder = ((BranchObservabilityAdder)identifiable.newExtension(BranchObservabilityAdder.class)).withObservable(observable);
        context.getReader().readChildNodes(elementName -> {
            TwoSides side = (TwoSides)context.getReader().readEnumAttribute(SIDE, TwoSides.class);
            double standardDeviation = context.getReader().readDoubleAttribute(STANDARD_DEVIATION);
            Boolean redundant = context.getReader().readOptionalBooleanAttribute(REDUNDANT).orElse(null);
            context.getReader().readEndNode();
            switch (elementName) {
                case "qualityP": {
                    this.readQualityP(standardDeviation, redundant, side, adder);
                    break;
                }
                case "qualityQ": {
                    this.readQualityQ(standardDeviation, redundant, side, adder);
                    break;
                }
                default: {
                    throw new PowsyblException("Unknown element name '" + elementName + "' in 'branchObservability'");
                }
            }
        });
        return (BranchObservability)adder.add();
    }

    private void readQualityP(double standardDeviation, Boolean redundant, TwoSides side, BranchObservabilityAdder<T> adder) {
        if (side == TwoSides.ONE) {
            adder.withStandardDeviationP1(standardDeviation);
            if (redundant != null) {
                adder.withRedundantP1(redundant);
            }
        } else if (side == TwoSides.TWO) {
            adder.withStandardDeviationP2(standardDeviation);
            if (redundant != null) {
                adder.withRedundantP2(redundant);
            }
        }
    }

    private void readQualityQ(double standardDeviation, Boolean redundant, TwoSides side, BranchObservabilityAdder<T> adder) {
        if (side == TwoSides.ONE) {
            adder.withStandardDeviationQ1(standardDeviation);
            if (redundant != null) {
                adder.withRedundantQ1(redundant);
            }
        } else if (side == TwoSides.TWO) {
            adder.withStandardDeviationQ2(standardDeviation);
            if (redundant != null) {
                adder.withRedundantQ2(redundant);
            }
        }
    }
}

