/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.extensions.AbstractExtensionSerDe;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.extensions.LoadDetail;
import com.powsybl.iidm.network.extensions.LoadDetailAdder;

@AutoService(value={ExtensionSerDe.class})
public class LoadDetailSerDe
extends AbstractExtensionSerDe<Load, LoadDetail> {
    public LoadDetailSerDe() {
        super("detail", "network", LoadDetail.class, "loadDetail.xsd", "http://www.itesla_project.eu/schema/iidm/ext/load_detail/1_0", "ld");
    }

    public void write(LoadDetail detail, SerializerContext context) {
        context.getWriter().writeDoubleAttribute("fixedActivePower", detail.getFixedActivePower());
        context.getWriter().writeDoubleAttribute("fixedReactivePower", detail.getFixedReactivePower());
        context.getWriter().writeDoubleAttribute("variableActivePower", detail.getVariableActivePower());
        context.getWriter().writeDoubleAttribute("variableReactivePower", detail.getVariableReactivePower());
    }

    public LoadDetail read(Load load, DeserializerContext context) {
        double variableReactivePower;
        double variableActivePower;
        double fixedReactivePower;
        double fixedActivePower = context.getReader().readDoubleAttribute("fixedActivePower");
        if (Double.isNaN(fixedActivePower)) {
            fixedActivePower = context.getReader().readDoubleAttribute("subLoad1ActivePower");
        }
        if (Double.isNaN(fixedReactivePower = context.getReader().readDoubleAttribute("fixedReactivePower"))) {
            fixedReactivePower = context.getReader().readDoubleAttribute("subLoad1ReactivePower");
        }
        if (Double.isNaN(variableActivePower = context.getReader().readDoubleAttribute("variableActivePower"))) {
            variableActivePower = context.getReader().readDoubleAttribute("subLoad2ActivePower");
        }
        if (Double.isNaN(variableReactivePower = context.getReader().readDoubleAttribute("variableReactivePower"))) {
            variableReactivePower = context.getReader().readDoubleAttribute("subLoad2ReactivePower");
        }
        context.getReader().readEndNode();
        return (LoadDetail)((LoadDetailAdder)load.newExtension(LoadDetailAdder.class)).withFixedActivePower(fixedActivePower).withFixedReactivePower(fixedReactivePower).withVariableActivePower(variableActivePower).withVariableReactivePower(variableReactivePower).add();
    }
}

