/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde.extensions;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.extensions.VoltageRegulation;
import com.powsybl.iidm.network.extensions.VoltageRegulationAdder;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.TerminalRefSerDe;
import com.powsybl.iidm.serde.extensions.AbstractVersionableNetworkExtensionSerDe;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@AutoService(value={ExtensionSerDe.class})
public class VoltageRegulationSerDe
extends AbstractVersionableNetworkExtensionSerDe<Battery, VoltageRegulation> {
    public VoltageRegulationSerDe() {
        super("voltageRegulation", VoltageRegulation.class, "vr", (Map<IidmVersion, ImmutableSortedSet<String>>)ImmutableMap.builder().put((Object)IidmVersion.V_1_0, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.0"), (Comparable)((Object)"1.0-legacy"))).put((Object)IidmVersion.V_1_1, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.1"))).put((Object)IidmVersion.V_1_2, VoltageRegulationSerDe.reversedNaturalOrderOf("1.1", "1.2")).put((Object)IidmVersion.V_1_3, VoltageRegulationSerDe.reversedNaturalOrderOf("1.1", "1.3")).put((Object)IidmVersion.V_1_4, VoltageRegulationSerDe.reversedNaturalOrderOf("1.1", "1.4")).put((Object)IidmVersion.V_1_5, VoltageRegulationSerDe.reversedNaturalOrderOf("1.1", "1.5")).put((Object)IidmVersion.V_1_6, VoltageRegulationSerDe.reversedNaturalOrderOf("1.1", "1.6")).put((Object)IidmVersion.V_1_7, VoltageRegulationSerDe.reversedNaturalOrderOf("1.1", "1.7")).put((Object)IidmVersion.V_1_8, VoltageRegulationSerDe.reversedNaturalOrderOf("1.1", "1.8")).put((Object)IidmVersion.V_1_9, VoltageRegulationSerDe.reversedNaturalOrderOf("1.1", "1.9")).put((Object)IidmVersion.V_1_10, VoltageRegulationSerDe.reversedNaturalOrderOf("1.1", "1.10")).put((Object)IidmVersion.V_1_11, VoltageRegulationSerDe.reversedNaturalOrderOf("1.1", "1.11")).put((Object)IidmVersion.V_1_12, VoltageRegulationSerDe.reversedNaturalOrderOf("1.1", "1.12")).put((Object)IidmVersion.V_1_13, (Object)ImmutableSortedSet.of((Comparable)((Object)"1.1"))).build(), (Map<String, String>)ImmutableMap.builder().put((Object)"1.0", (Object)"http://www.itesla_project.eu/schema/iidm/ext/voltage_regulation/1_0").put((Object)"1.0-legacy", (Object)"http://www.itesla_project.eu/schema/iidm/ext/voltageregulation/1_0").put((Object)"1.1", (Object)"http://www.powsybl.org/schema/iidm/ext/voltage_regulation/1_1").put((Object)"1.2", (Object)"http://www.powsybl.org/schema/iidm/ext/voltage_regulation/1_2").put((Object)"1.3", (Object)"http://www.powsybl.org/schema/iidm/ext/voltage_regulation/1_3").put((Object)"1.4", (Object)"http://www.powsybl.org/schema/iidm/ext/voltage_regulation/1_4").put((Object)"1.5", (Object)"http://www.powsybl.org/schema/iidm/ext/voltage_regulation/1_5").put((Object)"1.6", (Object)"http://www.powsybl.org/schema/iidm/ext/voltage_regulation/1_6").put((Object)"1.7", (Object)"http://www.powsybl.org/schema/iidm/ext/voltage_regulation/1_7").put((Object)"1.8", (Object)"http://www.powsybl.org/schema/iidm/ext/voltage_regulation/1_8").put((Object)"1.9", (Object)"http://www.powsybl.org/schema/iidm/ext/voltage_regulation/1_9").put((Object)"1.10", (Object)"http://www.powsybl.org/schema/iidm/ext/voltage_regulation/1_10").put((Object)"1.11", (Object)"http://www.powsybl.org/schema/iidm/ext/voltage_regulation/1_11").put((Object)"1.12", (Object)"http://www.powsybl.org/schema/iidm/ext/voltage_regulation/1_12").build());
    }

    private static ImmutableSortedSet<String> reversedNaturalOrderOf(String ... versions) {
        return ImmutableSortedSet.reverseOrder().add((Object[])versions).build();
    }

    public InputStream getXsdAsStream() {
        return this.getClass().getResourceAsStream("/xsd/voltageRegulation_V1_1.xsd");
    }

    public List<InputStream> getXsdAsStreamList() {
        return List.of(Objects.requireNonNull(this.getClass().getResourceAsStream("/xsd/voltageRegulation_V1_0.xsd")), Objects.requireNonNull(this.getClass().getResourceAsStream("/xsd/voltageRegulation_V1_0_legacy.xsd")), Objects.requireNonNull(this.getClass().getResourceAsStream("/xsd/voltageRegulation_V1_1.xsd")), Objects.requireNonNull(this.getClass().getResourceAsStream("/xsd/compatibility/voltage_regulation/voltageRegulation_V1_2.xsd")), Objects.requireNonNull(this.getClass().getResourceAsStream("/xsd/compatibility/voltage_regulation/voltageRegulation_V1_3.xsd")), Objects.requireNonNull(this.getClass().getResourceAsStream("/xsd/compatibility/voltage_regulation/voltageRegulation_V1_4.xsd")), Objects.requireNonNull(this.getClass().getResourceAsStream("/xsd/compatibility/voltage_regulation/voltageRegulation_V1_5.xsd")), Objects.requireNonNull(this.getClass().getResourceAsStream("/xsd/compatibility/voltage_regulation/voltageRegulation_V1_6.xsd")), Objects.requireNonNull(this.getClass().getResourceAsStream("/xsd/compatibility/voltage_regulation/voltageRegulation_V1_7.xsd")), Objects.requireNonNull(this.getClass().getResourceAsStream("/xsd/compatibility/voltage_regulation/voltageRegulation_V1_8.xsd")), Objects.requireNonNull(this.getClass().getResourceAsStream("/xsd/compatibility/voltage_regulation/voltageRegulation_V1_9.xsd")), Objects.requireNonNull(this.getClass().getResourceAsStream("/xsd/compatibility/voltage_regulation/voltageRegulation_V1_10.xsd")), Objects.requireNonNull(this.getClass().getResourceAsStream("/xsd/compatibility/voltage_regulation/voltageRegulation_V1_11.xsd")), Objects.requireNonNull(this.getClass().getResourceAsStream("/xsd/compatibility/voltage_regulation/voltageRegulation_V1_12.xsd")));
    }

    public void write(VoltageRegulation voltageRegulation, SerializerContext context) {
        NetworkSerializerContext networkContext = VoltageRegulationSerDe.convertContext(context);
        networkContext.getExtensionVersion(this.getExtensionName()).ifPresent(extensionVersion -> this.checkWritingCompatibility((String)extensionVersion, networkContext.getVersion()));
        networkContext.getWriter().writeBooleanAttribute("voltageRegulatorOn", voltageRegulation.isVoltageRegulatorOn());
        networkContext.getWriter().writeDoubleAttribute("targetV", voltageRegulation.getTargetV());
        if (voltageRegulation.getRegulatingTerminal() != null && !Objects.equals(voltageRegulation.getRegulatingTerminal().getBusBreakerView().getConnectableBus(), ((Battery)voltageRegulation.getExtendable()).getTerminal().getBusBreakerView().getConnectableBus())) {
            String extensionVersion2 = networkContext.getExtensionVersion(this.getExtensionName()).orElseGet(() -> this.getVersion(networkContext.getVersion()));
            TerminalRefSerDe.writeTerminalRef(voltageRegulation.getRegulatingTerminal(), networkContext, this.getNamespaceUri(extensionVersion2), "terminalRef", networkContext.getWriter());
        }
    }

    public VoltageRegulation read(Battery battery, DeserializerContext context) {
        NetworkDeserializerContext networkContext = VoltageRegulationSerDe.convertContext(context);
        this.checkReadingCompatibility(networkContext);
        boolean voltageRegulatorOn = networkContext.getReader().readBooleanAttribute("voltageRegulatorOn");
        double targetV = networkContext.getReader().readDoubleAttribute("targetV");
        VoltageRegulation voltageRegulation = (VoltageRegulation)((VoltageRegulationAdder)battery.newExtension(VoltageRegulationAdder.class)).withVoltageRegulatorOn(voltageRegulatorOn).withTargetV(targetV).add();
        networkContext.getReader().readChildNodes(elementName -> {
            if (!elementName.equals("terminalRef")) {
                throw new AssertionError((Object)("Unexpected element: " + elementName));
            }
            TerminalRefSerDe.readTerminalRef(networkContext, battery.getTerminal().getVoltageLevel().getNetwork(), arg_0 -> ((VoltageRegulation)voltageRegulation).setRegulatingTerminal(arg_0));
        });
        return voltageRegulation;
    }

    private static NetworkSerializerContext convertContext(SerializerContext context) {
        if (context instanceof NetworkSerializerContext) {
            NetworkSerializerContext networkSerializerContext = (NetworkSerializerContext)context;
            return networkSerializerContext;
        }
        throw new IllegalArgumentException("context is not a NetworkXmlWriterContext");
    }

    private static NetworkDeserializerContext convertContext(DeserializerContext context) {
        if (context instanceof NetworkDeserializerContext) {
            NetworkDeserializerContext networkDeserializerContext = (NetworkDeserializerContext)context;
            return networkDeserializerContext;
        }
        throw new IllegalArgumentException("context is not a NetworkXmlReaderContext");
    }
}

