/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde.util;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.network.LoadingLimits;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.serde.AbstractNetworkSerDeContext;
import com.powsybl.iidm.serde.ExportOptions;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IidmSerDeUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(IidmSerDeUtil.class);
    private static final String MAXIMUM_REASON = "IIDM version should be <= ";
    private static final String MINIMUM_REASON = "IIDM version should be >= ";

    private static String message(String elementName, ErrorMessage type, IidmVersion version, IidmVersion contextVersion, String reason) {
        return elementName + " is " + type.message + " for IIDM version " + contextVersion.toString(".") + ". " + reason + version.toString(".");
    }

    private static PowsyblException createException(String rootElementName, String elementName, ErrorMessage type, IidmVersion version, IidmVersion contextVersion, String reason) {
        return IidmSerDeUtil.createException(rootElementName + "." + elementName, type, version, contextVersion, reason);
    }

    private static PowsyblException createException(String elementName, ErrorMessage type, IidmVersion version, IidmVersion contextVersion, String reason) {
        return new PowsyblException(IidmSerDeUtil.message(elementName, type, version, contextVersion, reason));
    }

    private static void createExceptionOrLogError(String rootElementName, String elementName, ErrorMessage type, IidmVersion refVersion, String reason, NetworkSerializerContext context) {
        IidmSerDeUtil.createExceptionOrLogError(rootElementName + "." + elementName, type, refVersion, reason, context);
    }

    private static void createExceptionOrLogError(String elementName, ErrorMessage type, IidmVersion refVersion, String reason, NetworkSerializerContext context) {
        if (context.getOptions().getIidmVersionIncompatibilityBehavior() == ExportOptions.IidmVersionIncompatibilityBehavior.THROW_EXCEPTION) {
            throw IidmSerDeUtil.createException(elementName, type, refVersion, context.getVersion(), reason);
        }
        if (context.getOptions().getIidmVersionIncompatibilityBehavior() == ExportOptions.IidmVersionIncompatibilityBehavior.LOG_ERROR) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error(IidmSerDeUtil.message(elementName, type, refVersion, context.getVersion(), reason));
            }
        } else {
            throw new IllegalStateException("Unexpected behaviour: " + context.getOptions().getIidmVersionIncompatibilityBehavior());
        }
    }

    public static void assertMaximumVersion(String rootElementName, String elementName, ErrorMessage type, IidmVersion maxVersion, NetworkDeserializerContext context) {
        if (context.getVersion().compareTo(maxVersion) > 0) {
            throw IidmSerDeUtil.createException(rootElementName, elementName, type, maxVersion, context.getVersion(), MAXIMUM_REASON);
        }
    }

    public static void assertMaximumVersion(String rootElementName, String elementName, ErrorMessage type, IidmVersion maxVersion, NetworkSerializerContext context) {
        if (context.getVersion().compareTo(maxVersion) > 0) {
            IidmSerDeUtil.createExceptionOrLogError(rootElementName, elementName, type, maxVersion, MAXIMUM_REASON, context);
        }
    }

    public static void assertMaximumVersion(String elementName, ErrorMessage type, IidmVersion maxVersion, NetworkDeserializerContext context) {
        if (context.getVersion().compareTo(maxVersion) > 0) {
            throw IidmSerDeUtil.createException(elementName, type, maxVersion, context.getVersion(), MAXIMUM_REASON);
        }
    }

    public static void assertMaximumVersion(String elementName, ErrorMessage type, IidmVersion maxVersion, NetworkSerializerContext context) {
        if (context.getVersion().compareTo(maxVersion) > 0) {
            IidmSerDeUtil.createExceptionOrLogError(elementName, type, maxVersion, MAXIMUM_REASON, context);
        }
    }

    public static void assertMinimumVersion(String rootElementName, String elementName, ErrorMessage type, IidmVersion minVersion, NetworkDeserializerContext context) {
        if (context.getVersion().compareTo(minVersion) < 0) {
            throw IidmSerDeUtil.createException(rootElementName, elementName, type, minVersion, context.getVersion(), MINIMUM_REASON);
        }
    }

    public static void assertMinimumVersion(String rootElementName, String elementName, ErrorMessage type, IidmVersion minVersion, IidmVersion version) {
        if (version.compareTo(minVersion) < 0) {
            throw IidmSerDeUtil.createException(rootElementName, elementName, type, minVersion, version, MINIMUM_REASON);
        }
    }

    public static void assertMinimumVersion(String rootElementName, String elementName, ErrorMessage type, IidmVersion minVersion, NetworkSerializerContext context) {
        if (context.getVersion().compareTo(minVersion) < 0) {
            IidmSerDeUtil.createExceptionOrLogError(rootElementName, elementName, type, minVersion, MINIMUM_REASON, context);
        }
    }

    public static void assertMinimumVersion(String elementName, ErrorMessage type, IidmVersion minVersion, NetworkDeserializerContext context) {
        if (context.getVersion().compareTo(minVersion) < 0) {
            throw IidmSerDeUtil.createException(elementName, type, minVersion, context.getVersion(), MINIMUM_REASON);
        }
    }

    public static void assertMinimumVersion(String elementName, ErrorMessage type, IidmVersion minVersion, NetworkSerializerContext context) {
        if (context.getVersion().compareTo(minVersion) < 0) {
            IidmSerDeUtil.createExceptionOrLogError(elementName, type, minVersion, MINIMUM_REASON, context);
        }
    }

    public static void assertMinimumVersionIfNotDefault(boolean valueIsNotDefault, String rootElementName, String elementName, ErrorMessage type, IidmVersion minVersion, IidmVersion version) {
        if (valueIsNotDefault) {
            IidmSerDeUtil.assertMinimumVersion(rootElementName, elementName, type, minVersion, version);
        }
    }

    public static void assertMinimumVersionIfNotDefault(boolean valueIsNotDefault, String rootElementName, String elementName, ErrorMessage type, IidmVersion minVersion, NetworkDeserializerContext context) {
        if (valueIsNotDefault) {
            IidmSerDeUtil.assertMinimumVersion(rootElementName, elementName, type, minVersion, context);
        }
    }

    public static void assertMinimumVersionIfNotDefault(boolean valueIsNotDefault, String rootElementName, String elementName, ErrorMessage type, IidmVersion minVersion, NetworkSerializerContext context) {
        if (valueIsNotDefault) {
            IidmSerDeUtil.assertMinimumVersion(rootElementName, elementName, type, minVersion, context);
        }
    }

    public static void assertMinimumVersionAndRunIfNotDefault(boolean valueIsNotDefault, String rootElementName, String elementName, ErrorMessage type, IidmVersion minVersion, NetworkDeserializerContext context, Runnable runnable) {
        if (valueIsNotDefault) {
            IidmSerDeUtil.assertMinimumVersion(rootElementName, elementName, type, minVersion, context);
            runnable.run();
        }
    }

    public static void assertMinimumVersionAndRunIfNotDefault(boolean valueIsNotDefault, String rootElementName, String elementName, ErrorMessage type, IidmVersion minVersion, NetworkSerializerContext context, Runnable runnable) {
        if (valueIsNotDefault) {
            IidmSerDeUtil.assertMinimumVersion(rootElementName, elementName, type, minVersion, context);
            IidmSerDeUtil.runFromMinimumVersion(minVersion, context, runnable::run);
        }
    }

    public static void assertStrictMaximumVersion(String rootElementName, String elementName, ErrorMessage type, IidmVersion maxVersion, NetworkDeserializerContext context) {
        if (context.getVersion().compareTo(maxVersion) >= 0) {
            throw IidmSerDeUtil.createException(rootElementName, elementName, type, maxVersion, context.getVersion(), "IIDM version should be < ");
        }
    }

    public static void assertStrictMaximumVersion(String rootElementName, String elementName, ErrorMessage type, IidmVersion maxVersion, NetworkSerializerContext context) {
        if (context.getVersion().compareTo(maxVersion) >= 0) {
            IidmSerDeUtil.createExceptionOrLogError(rootElementName, elementName, type, maxVersion, "IIDM version should be < ", context);
        }
    }

    public static <C extends AbstractNetworkSerDeContext> void runFromMinimumVersion(IidmVersion minVersion, C context, Runnable runnable) {
        if (context.getVersion().compareTo(minVersion) >= 0) {
            runnable.run();
        }
    }

    public static <C extends AbstractNetworkSerDeContext> void runUntilMaximumVersion(IidmVersion maxVersion, C context, Runnable runnable) {
        if (context.getVersion().compareTo(maxVersion) <= 0) {
            runnable.run();
        }
    }

    public static void writeBooleanAttributeFromMinimumVersion(String rootElementName, String attributeName, boolean value, boolean defaultValue, ErrorMessage type, IidmVersion minVersion, NetworkSerializerContext context) {
        IidmSerDeUtil.writeAttributeFromMinimumVersion(rootElementName, attributeName, value != defaultValue, type, minVersion, context, () -> context.getWriter().writeBooleanAttribute(attributeName, value));
    }

    public static void writeDoubleAttributeFromMinimumVersion(String rootElementName, String attributeName, double value, ErrorMessage type, IidmVersion minVersion, NetworkSerializerContext context) {
        IidmSerDeUtil.writeDoubleAttributeFromMinimumVersion(rootElementName, attributeName, value, Double.NaN, type, minVersion, context);
    }

    public static void writeDoubleAttributeFromMinimumVersion(String rootElementName, String attributeName, double value, double defaultValue, ErrorMessage type, IidmVersion minVersion, NetworkSerializerContext context) {
        IidmSerDeUtil.writeAttributeFromMinimumVersion(rootElementName, attributeName, !Objects.equals(value, defaultValue), type, minVersion, context, () -> context.getWriter().writeDoubleAttribute(attributeName, value));
    }

    private static void writeAttributeFromMinimumVersion(String rootElementName, String attributeName, boolean isNotDefaultValue, ErrorMessage type, IidmVersion minVersion, NetworkSerializerContext context, Runnable write) {
        if (context.getVersion().compareTo(minVersion) >= 0) {
            write.run();
        } else {
            IidmSerDeUtil.assertMinimumVersionIfNotDefault(isNotDefaultValue, rootElementName, attributeName, type, minVersion, context);
        }
    }

    public static void writeIntAttributeUntilMaximumVersion(String attributeName, int value, IidmVersion maxVersion, NetworkSerializerContext context) {
        if (context.getVersion().compareTo(maxVersion) <= 0) {
            context.getWriter().writeIntAttribute(attributeName, value);
        }
    }

    public static String getAttributeName(String oldName, String newName, IidmVersion version, IidmVersion comparisonVersion) {
        if (version.compareTo(comparisonVersion) < 0) {
            return oldName;
        }
        return newName;
    }

    public static <T extends Identifiable> Iterable<T> sorted(Iterable<T> identifiables, ExportOptions exportOptions) {
        Objects.requireNonNull(identifiables);
        Objects.requireNonNull(exportOptions);
        return exportOptions.isSorted() ? (Iterable)StreamSupport.stream(identifiables.spliterator(), false).sorted(Comparator.comparing(Identifiable::getId)).collect(Collectors.toList()) : identifiables;
    }

    public static <T extends Identifiable<T>> Stream<T> sorted(Stream<T> stream, ExportOptions exportOptions) {
        Objects.requireNonNull(stream);
        Objects.requireNonNull(exportOptions);
        return exportOptions.isSorted() ? stream.sorted(Comparator.comparing(Identifiable::getId)) : stream;
    }

    public static Iterable<? extends Extension<? extends Identifiable<?>>> sortedExtensions(Iterable<? extends Extension<? extends Identifiable<?>>> extensions, ExportOptions exportOptions) {
        Objects.requireNonNull(exportOptions);
        Objects.requireNonNull(exportOptions);
        return exportOptions.isSorted() ? (Iterable)StreamSupport.stream(extensions.spliterator(), false).sorted(Comparator.comparing(Extension::getName)).collect(Collectors.toList()) : extensions;
    }

    public static Iterable<LoadingLimits.TemporaryLimit> sortedTemporaryLimits(Iterable<LoadingLimits.TemporaryLimit> temporaryLimits, ExportOptions exportOptions) {
        Objects.requireNonNull(temporaryLimits);
        Objects.requireNonNull(exportOptions);
        return exportOptions.isSorted() ? (Iterable)StreamSupport.stream(temporaryLimits.spliterator(), false).sorted(Comparator.comparing(LoadingLimits.TemporaryLimit::getName)).collect(Collectors.toList()) : temporaryLimits;
    }

    public static Iterable<VoltageLevel.NodeBreakerView.InternalConnection> sortedInternalConnections(Iterable<VoltageLevel.NodeBreakerView.InternalConnection> internalConnections, ExportOptions exportOptions) {
        Objects.requireNonNull(internalConnections);
        Objects.requireNonNull(exportOptions);
        return exportOptions.isSorted() ? (Iterable)StreamSupport.stream(internalConnections.spliterator(), false).sorted(Comparator.comparing(VoltageLevel.NodeBreakerView.InternalConnection::getNode1).thenComparing(VoltageLevel.NodeBreakerView.InternalConnection::getNode2)).collect(Collectors.toList()) : internalConnections;
    }

    public static Iterable<String> sortedNames(Iterable<String> names, ExportOptions exportOptions) {
        Objects.requireNonNull(names);
        Objects.requireNonNull(exportOptions);
        return exportOptions.isSorted() ? (Iterable)StreamSupport.stream(names.spliterator(), false).sorted().collect(Collectors.toList()) : names;
    }

    private IidmSerDeUtil() {
    }

    public static enum ErrorMessage {
        NOT_SUPPORTED("not supported"),
        MANDATORY("mandatory"),
        NOT_NULL_NOT_SUPPORTED("not null and not supported"),
        NOT_DEFAULT_NOT_SUPPORTED("not defined as default and not supported");

        private final String message;

        private ErrorMessage(String message) {
            this.message = message;
        }
    }
}

