/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.io.TreeDataFormat;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOptions<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractOptions.class);
    protected Set<String> includedExtensions;
    protected Set<String> excludedExtensions;
    protected TreeDataFormat format = TreeDataFormat.XML;

    public T setIncludedExtensions(Set<String> extensions) {
        if (this.excludedExtensions != null) {
            LOGGER.warn("Previously excluded extensions list will now be ignored: {}", this.excludedExtensions);
        }
        if (extensions != null && extensions.isEmpty()) {
            LOGGER.warn("All extensions will be excluded");
        }
        this.excludedExtensions = null;
        this.includedExtensions = extensions;
        return this.castThis();
    }

    public T setExcludedExtensions(Set<String> extensions) {
        if (this.includedExtensions != null) {
            LOGGER.warn("Previously included extensions list will now be ignored: {}", this.includedExtensions);
        }
        this.includedExtensions = null;
        this.excludedExtensions = extensions;
        return this.castThis();
    }

    public T addIncludedExtension(String extension) {
        if (this.excludedExtensions != null) {
            if (this.excludedExtensions.remove(extension)) {
                LOGGER.warn("Previously excluded extensions {} will now be included", (Object)extension);
            }
        } else {
            if (this.includedExtensions == null) {
                this.includedExtensions = new HashSet<String>();
            }
            this.includedExtensions.add(extension);
        }
        return this.castThis();
    }

    public T addExcludedExtension(String extension) throws PowsyblException {
        if (this.includedExtensions != null) {
            if (this.includedExtensions.remove(extension)) {
                LOGGER.warn("Previously included extensions {} will now be excluded", (Object)extension);
            }
        } else {
            if (this.excludedExtensions == null) {
                this.excludedExtensions = new HashSet<String>();
            }
            this.excludedExtensions.add(extension);
        }
        return this.castThis();
    }

    public Optional<Set<String>> getIncludedExtensions() {
        return Optional.ofNullable(this.includedExtensions);
    }

    public Optional<Set<String>> getExcludedExtensions() {
        return Optional.ofNullable(this.excludedExtensions);
    }

    public boolean withNoExtension() {
        return this.includedExtensions != null && this.includedExtensions.isEmpty();
    }

    public boolean withAllExtensions() {
        return this.includedExtensions == null && (this.excludedExtensions == null || this.excludedExtensions.isEmpty());
    }

    public boolean hasAtLeastOneExtension(Set<String> extensions) {
        if (this.withAllExtensions()) {
            return true;
        }
        for (String extension : extensions) {
            if (!this.withExtension(extension)) continue;
            return true;
        }
        return false;
    }

    public boolean withExtension(String extensionName) {
        return !(this.excludedExtensions != null && this.excludedExtensions.contains(extensionName) || this.includedExtensions != null && !this.includedExtensions.contains(extensionName));
    }

    public abstract boolean isThrowExceptionIfExtensionNotFound();

    public TreeDataFormat getFormat() {
        return this.format;
    }

    public T setFormat(TreeDataFormat format) {
        this.format = Objects.requireNonNull(format);
        return this.castThis();
    }

    private T castThis() {
        return (T)this;
    }
}

