/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.io.TreeDataWriter;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.IdentifiableAdder;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.PhaseTapChangerAdder;
import com.powsybl.iidm.network.PhaseTapChangerStep;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.RatioTapChangerAdder;
import com.powsybl.iidm.network.RatioTapChangerStep;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.TapChanger;
import com.powsybl.iidm.network.TapChangerAdder;
import com.powsybl.iidm.network.TapChangerStep;
import com.powsybl.iidm.network.TapChangerStepAdder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.serde.AbstractSimpleIdentifiableSerDe;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.TerminalRefSerDe;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.DoubleConsumer;

abstract class AbstractTransformerSerDe<T extends Connectable<T>, A extends IdentifiableAdder<T, A>>
extends AbstractSimpleIdentifiableSerDe<T, A, Substation> {
    private static final String ATTR_LOW_TAP_POSITION = "lowTapPosition";
    private static final String ATTR_TAP_POSITION = "tapPosition";
    private static final String ATTR_SOLVED_TAP_POSITION = "solvedTapPosition";
    private static final String ATTR_REGULATING = "regulating";
    private static final String ELEM_TERMINAL_REF = "terminalRef";
    private static final String ATTR_REGULATION_MODE = "regulationMode";
    private static final String ATTR_REGULATION_VALUE = "regulationValue";
    private static final String ATTR_LOAD_TAP_CHANGING_CAPABILITIES = "loadTapChangingCapabilities";
    static final String STEP_ROOT_ELEMENT_NAME = "step";
    static final String STEP_ARRAY_ELEMENT_NAME = "steps";
    private static final String TARGET_DEADBAND = "targetDeadband";
    private static final String RATIO_TAP_CHANGER = "ratioTapChanger";
    private static final String PHASE_TAP_CHANGER = "phaseTapChanger";

    AbstractTransformerSerDe() {
    }

    protected static void writeTapChangerStep(TapChangerStep<?> tcs, TreeDataWriter writer) {
        writer.writeDoubleAttribute("r", tcs.getR());
        writer.writeDoubleAttribute("x", tcs.getX());
        writer.writeDoubleAttribute("g", tcs.getG());
        writer.writeDoubleAttribute("b", tcs.getB());
        writer.writeDoubleAttribute("rho", tcs.getRho());
    }

    private static void writeTargetDeadband(double targetDeadband, NetworkSerializerContext context) {
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_1, context, () -> context.getWriter().writeDoubleAttribute(TARGET_DEADBAND, targetDeadband, 0.0));
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_2, context, () -> context.getWriter().writeDoubleAttribute(TARGET_DEADBAND, targetDeadband));
    }

    private static double readTargetDeadband(NetworkDeserializerContext context, boolean regulating) {
        double[] targetDeadband = new double[1];
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_1, context, () -> {
            targetDeadband[0] = context.getReader().readDoubleAttribute(TARGET_DEADBAND);
            if (regulating && Double.isNaN(targetDeadband[0])) {
                targetDeadband[0] = 0.0;
            }
        });
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_2, context, () -> {
            targetDeadband[0] = context.getReader().readDoubleAttribute(TARGET_DEADBAND);
        });
        return targetDeadband[0];
    }

    private static void writeTapChanger(TapChanger<?, ?, ?, ?> tc, NetworkSerializerContext context) {
        context.getWriter().writeIntAttribute(ATTR_LOW_TAP_POSITION, tc.getLowTapPosition());
        OptionalInt tp = tc.findTapPosition();
        OptionalInt stp = tc.findSolvedTapPosition();
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_13, context, () -> {
            OptionalInt position = stp.isPresent() ? stp : tp;
            context.getWriter().writeOptionalIntAttribute(ATTR_TAP_POSITION, position.isPresent() ? Integer.valueOf(position.getAsInt()) : null);
        });
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_14, context, () -> {
            context.getWriter().writeOptionalIntAttribute(ATTR_TAP_POSITION, tp.isPresent() ? Integer.valueOf(tp.getAsInt()) : null);
            context.getWriter().writeOptionalIntAttribute(ATTR_SOLVED_TAP_POSITION, stp.isPresent() ? Integer.valueOf(stp.getAsInt()) : null);
        });
        AbstractTransformerSerDe.writeTargetDeadband(tc.getTargetDeadband(), context);
    }

    protected static void writeRatioTapChanger(String name, RatioTapChanger rtc, NetworkSerializerContext context) {
        context.getWriter().writeStartNode(context.getVersion().getNamespaceURI(context.isValid()), name);
        Boolean optionalRegulatingValue = !rtc.hasLoadTapChangingCapabilities() ? null : Boolean.valueOf(rtc.isRegulating());
        context.getWriter().writeOptionalBooleanAttribute(ATTR_REGULATING, optionalRegulatingValue);
        AbstractTransformerSerDe.writeTapChanger(rtc, context);
        context.getWriter().writeBooleanAttribute(ATTR_LOAD_TAP_CHANGING_CAPABILITIES, rtc.hasLoadTapChangingCapabilities());
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_11, context, () -> context.getWriter().writeDoubleAttribute("targetV", rtc.getRegulationValue()));
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> {
            context.getWriter().writeEnumAttribute(ATTR_REGULATION_MODE, (Enum)rtc.getRegulationMode());
            context.getWriter().writeDoubleAttribute(ATTR_REGULATION_VALUE, rtc.getRegulationValue());
        });
        TerminalRefSerDe.writeTerminalRef(rtc.getRegulationTerminal(), context, ELEM_TERMINAL_REF);
        context.getWriter().writeStartNodes();
        for (int p = rtc.getLowTapPosition(); p <= rtc.getHighTapPosition(); ++p) {
            RatioTapChangerStep rtcs = (RatioTapChangerStep)rtc.getStep(p);
            context.getWriter().writeStartNode(context.getVersion().getNamespaceURI(context.isValid()), STEP_ROOT_ELEMENT_NAME);
            AbstractTransformerSerDe.writeTapChangerStep(rtcs, context.getWriter());
            context.getWriter().writeEndNode();
        }
        context.getWriter().writeEndNodes();
        context.getWriter().writeEndNode();
    }

    protected static void readRatioTapChanger(String elementName, RatioTapChangerAdder adder, Terminal terminal, NetworkDeserializerContext context) {
        boolean regulating = AbstractTransformerSerDe.readTapChangerAttributes(adder, context);
        boolean loadTapChangingCapabilities = context.getReader().readBooleanAttribute(ATTR_LOAD_TAP_CHANGING_CAPABILITIES);
        adder.setLoadTapChangingCapabilities(loadTapChangingCapabilities);
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_11, context, () -> {
            double targetV = context.getReader().readDoubleAttribute("targetV");
            if (!Double.isNaN(targetV)) {
                adder.setRegulationMode(RatioTapChanger.RegulationMode.VOLTAGE);
            }
            adder.setRegulationValue(targetV);
        });
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> {
            RatioTapChanger.RegulationMode regulationMode = (RatioTapChanger.RegulationMode)context.getReader().readEnumAttribute(ATTR_REGULATION_MODE, RatioTapChanger.RegulationMode.class);
            double regulationValue = context.getReader().readDoubleAttribute(ATTR_REGULATION_VALUE);
            adder.setRegulationMode(regulationMode).setRegulationValue(regulationValue);
        });
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_13, context, () -> {
            if (!loadTapChangingCapabilities && regulating) {
                adder.setRegulating(false);
            }
        });
        boolean[] hasTerminalRef = new boolean[1];
        context.getReader().readChildNodes(subElementName -> {
            switch (subElementName) {
                case "terminalRef": {
                    hasTerminalRef[0] = true;
                    AbstractTransformerSerDe.readTapChangerTerminalRef(adder, terminal, context);
                    break;
                }
                case "step": {
                    RatioTapChangerAdder.StepAdder stepAdder = (RatioTapChangerAdder.StepAdder)adder.beginStep();
                    AbstractTransformerSerDe.readSteps(context, stepAdder);
                    stepAdder.endStep();
                    context.getReader().readEndNode();
                    break;
                }
                default: {
                    throw new PowsyblException("Unknown element name '" + subElementName + "' in '" + elementName + "'");
                }
            }
        });
        if (!hasTerminalRef[0]) {
            adder.add();
        }
    }

    protected static void readRatioTapChanger(TwoWindingsTransformer twt, NetworkDeserializerContext context) {
        AbstractTransformerSerDe.readRatioTapChanger(RATIO_TAP_CHANGER, twt.newRatioTapChanger(), twt.getTerminal1(), context);
    }

    protected static void readRatioTapChanger(int leg, ThreeWindingsTransformer.Leg twl, NetworkDeserializerContext context) {
        AbstractTransformerSerDe.readRatioTapChanger(RATIO_TAP_CHANGER + leg, twl.newRatioTapChanger(), twl.getTerminal(), context);
    }

    protected static void writePhaseTapChanger(String name, PhaseTapChanger ptc, NetworkSerializerContext context) {
        context.getWriter().writeStartNode(context.getVersion().getNamespaceURI(context.isValid()), name);
        PhaseTapChanger.RegulationMode regMode = ptc.getRegulationMode();
        Boolean optionalRegulatingValue = !ptc.hasLoadTapChangingCapabilities() || regMode == null ? null : Boolean.valueOf(ptc.isRegulating());
        context.getWriter().writeOptionalBooleanAttribute(ATTR_REGULATING, optionalRegulatingValue);
        AbstractTransformerSerDe.writeTapChanger(ptc, context);
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_14, context, () -> context.getWriter().writeBooleanAttribute(ATTR_LOAD_TAP_CHANGING_CAPABILITIES, ptc.hasLoadTapChangingCapabilities()));
        if (context.getVersion().compareTo(IidmVersion.V_1_5) <= 0 && (Double.isNaN(ptc.getRegulationValue()) || ptc.getRegulationTerminal() == null)) {
            context.getWriter().writeEnumAttribute(ATTR_REGULATION_MODE, (Enum)PhaseTapChangerRegulationModeSerDe.FIXED_TAP);
        } else {
            context.getWriter().writeEnumAttribute(ATTR_REGULATION_MODE, (Enum)regMode);
        }
        context.getWriter().writeDoubleAttribute(ATTR_REGULATION_VALUE, ptc.getRegulationValue());
        TerminalRefSerDe.writeTerminalRef(ptc.getRegulationTerminal(), context, ELEM_TERMINAL_REF);
        context.getWriter().writeStartNodes();
        for (int p = ptc.getLowTapPosition(); p <= ptc.getHighTapPosition(); ++p) {
            PhaseTapChangerStep ptcs = (PhaseTapChangerStep)ptc.getStep(p);
            context.getWriter().writeStartNode(context.getVersion().getNamespaceURI(context.isValid()), STEP_ROOT_ELEMENT_NAME);
            AbstractTransformerSerDe.writeTapChangerStep(ptcs, context.getWriter());
            context.getWriter().writeDoubleAttribute("alpha", ptcs.getAlpha());
            context.getWriter().writeEndNode();
        }
        context.getWriter().writeEndNodes();
        context.getWriter().writeEndNode();
    }

    protected static void readPhaseTapChanger(String name, PhaseTapChangerAdder adder, Terminal terminal, NetworkDeserializerContext context) {
        AbstractTransformerSerDe.readTapChangerAttributes(adder, context);
        AtomicReference regulationMode = new AtomicReference();
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_13, context, () -> {
            adder.setRegulationMode(null);
            PhaseTapChangerRegulationModeSerDe regulationModeSerDe = (PhaseTapChangerRegulationModeSerDe)context.getReader().readEnumAttribute(ATTR_REGULATION_MODE, PhaseTapChangerRegulationModeSerDe.class);
            if (regulationModeSerDe != null) {
                if (PhaseTapChangerRegulationModeSerDe.FIXED_TAP.equals((Object)regulationModeSerDe)) {
                    adder.setRegulating(false);
                }
                regulationMode.set(PhaseTapChangerRegulationModeSerDe.convertToRegulationMode(regulationModeSerDe));
                adder.setRegulationMode((PhaseTapChanger.RegulationMode)regulationMode.get());
            }
        });
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_14, context, () -> {
            boolean loadTapChangingCapabilities = context.getReader().readBooleanAttribute(ATTR_LOAD_TAP_CHANGING_CAPABILITIES);
            adder.setLoadTapChangingCapabilities(loadTapChangingCapabilities);
            regulationMode.set((PhaseTapChanger.RegulationMode)context.getReader().readEnumAttribute(ATTR_REGULATION_MODE, PhaseTapChanger.RegulationMode.class));
            adder.setRegulationMode((PhaseTapChanger.RegulationMode)regulationMode.get());
        });
        adder.setRegulationValue(AbstractTransformerSerDe.checkRegulationValue((PhaseTapChanger.RegulationMode)regulationMode.get(), context.getReader().readDoubleAttribute(ATTR_REGULATION_VALUE)));
        boolean[] hasTerminalRef = new boolean[1];
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "terminalRef": {
                    hasTerminalRef[0] = true;
                    AbstractTransformerSerDe.readTapChangerTerminalRef(adder, terminal, context);
                    break;
                }
                case "step": {
                    PhaseTapChangerAdder.StepAdder stepAdder = (PhaseTapChangerAdder.StepAdder)adder.beginStep();
                    AbstractTransformerSerDe.readSteps(context, stepAdder);
                    double alpha = context.getReader().readDoubleAttribute("alpha");
                    ((PhaseTapChangerAdder.StepAdder)stepAdder.setAlpha(alpha)).endStep();
                    context.getReader().readEndNode();
                    break;
                }
                default: {
                    throw new PowsyblException("Unknown element name '" + elementName + "' in '" + name + "'");
                }
            }
        });
        if (!hasTerminalRef[0]) {
            adder.add();
        }
    }

    private static double checkRegulationValue(PhaseTapChanger.RegulationMode regulationMode, double regulationValue) {
        if (regulationMode == PhaseTapChanger.RegulationMode.CURRENT_LIMITER && regulationValue < 0.0) {
            return Math.abs(regulationValue);
        }
        return regulationValue;
    }

    private static void readTapChangerTerminalRef(TapChangerAdder<?, ?, ?, ?, ?, ?> adder, Terminal terminal, NetworkDeserializerContext context) {
        TerminalRefSerDe.readTerminalRef(context, terminal.getVoltageLevel().getNetwork(), tRef -> {
            adder.setRegulationTerminal(tRef);
            adder.add();
        });
    }

    private static boolean readTapChangerAttributes(TapChangerAdder<?, ?, ?, ?, ?, ?> adder, NetworkDeserializerContext context) {
        boolean regulating = context.getReader().readOptionalBooleanAttribute(ATTR_REGULATING).orElse(false);
        int lowTapPosition = context.getReader().readIntAttribute(ATTR_LOW_TAP_POSITION);
        OptionalInt tapPosition = context.getReader().readOptionalIntAttribute(ATTR_TAP_POSITION);
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_14, context, () -> {
            OptionalInt solvedTapPosition = context.getReader().readOptionalIntAttribute(ATTR_SOLVED_TAP_POSITION);
            solvedTapPosition.ifPresent(arg_0 -> ((TapChangerAdder)adder).setSolvedTapPosition(arg_0));
        });
        double targetDeadband = AbstractTransformerSerDe.readTargetDeadband(context, regulating);
        adder.setLowTapPosition(lowTapPosition).setTargetDeadband(targetDeadband).setRegulating(regulating);
        tapPosition.ifPresent(arg_0 -> adder.setTapPosition(arg_0));
        return regulating;
    }

    protected static void readPhaseTapChanger(TwoWindingsTransformer twt, NetworkDeserializerContext context) {
        AbstractTransformerSerDe.readPhaseTapChanger(PHASE_TAP_CHANGER, twt.newPhaseTapChanger(), twt.getTerminal1(), context);
    }

    protected static void readPhaseTapChanger(int leg, ThreeWindingsTransformer.Leg twl, NetworkDeserializerContext context) {
        AbstractTransformerSerDe.readPhaseTapChanger(PHASE_TAP_CHANGER + leg, twl.newPhaseTapChanger(), twl.getTerminal(), context);
    }

    private static void readSteps(NetworkDeserializerContext context, TapChangerStepAdder<?, ?> adder) {
        double r = context.getReader().readDoubleAttribute("r");
        double x = context.getReader().readDoubleAttribute("x");
        double g = context.getReader().readDoubleAttribute("g");
        double b = context.getReader().readDoubleAttribute("b");
        double rho = context.getReader().readDoubleAttribute("rho");
        adder.setR(r).setX(x).setG(g).setB(b).setRho(rho);
    }

    protected static void readRatedS(String name, NetworkDeserializerContext context, DoubleConsumer consumer) {
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_2, context, () -> {
            double ratedS = context.getReader().readDoubleAttribute(name);
            consumer.accept(ratedS);
        });
    }

    protected static void writeRatedS(String name, double ratedS, NetworkSerializerContext context) {
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_2, context, () -> context.getWriter().writeDoubleAttribute(name, ratedS));
    }

    private static enum PhaseTapChangerRegulationModeSerDe {
        CURRENT_LIMITER,
        ACTIVE_POWER_CONTROL,
        FIXED_TAP;


        static PhaseTapChanger.RegulationMode convertToRegulationMode(PhaseTapChangerRegulationModeSerDe regulationModeSerDe) {
            switch (regulationModeSerDe.ordinal()) {
                case 0: 
                case 2: {
                    return PhaseTapChanger.RegulationMode.CURRENT_LIMITER;
                }
                case 1: {
                    return PhaseTapChanger.RegulationMode.ACTIVE_POWER_CONTROL;
                }
            }
            return PhaseTapChanger.RegulationMode.CURRENT_LIMITER;
        }
    }
}

