/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineAdder;
import com.powsybl.iidm.network.FlowsLimitsHolder;
import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.serde.AbstractSimpleIdentifiableSerDe;
import com.powsybl.iidm.serde.ConnectableSerDeUtil;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.ReactiveLimitsSerDe;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.function.Function;
import java.util.function.Supplier;

class DanglingLineSerDe
extends AbstractSimpleIdentifiableSerDe<DanglingLine, DanglingLineAdder, VoltageLevel> {
    private static final String GENERATION = "generation";
    private static final String GENERATION_MAX_P = "generationMaxP";
    private static final String GENERATION_MIN_P = "generationMinP";
    private static final String GENERATION_TARGET_P = "generationTargetP";
    private static final String GENERATION_TARGET_Q = "generationTargetQ";
    private static final String GENERATION_TARGET_V = "generationTargetV";
    static final DanglingLineSerDe INSTANCE = new DanglingLineSerDe();
    static final String ROOT_ELEMENT_NAME = "danglingLine";
    static final String ARRAY_ELEMENT_NAME = "danglingLines";

    DanglingLineSerDe() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected void writeRootElementAttributes(DanglingLine dl, VoltageLevel vl, NetworkSerializerContext context) {
        DanglingLineSerDe.writeRootElementAttributesInternal(dl, () -> ((DanglingLine)dl).getTerminal(), context);
    }

    static void writeRootElementAttributesInternal(DanglingLine dl, Supplier<Terminal> terminalGetter, NetworkSerializerContext context) {
        DanglingLine.Generation generation = dl.getGeneration();
        double[] p0 = new double[1];
        double[] q0 = new double[1];
        p0[0] = dl.getP0();
        q0[0] = dl.getQ0();
        if (generation != null) {
            IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, GENERATION, IidmSerDeUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmVersion.V_1_3, context);
            IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_2, context, () -> {
                if (!Double.isNaN(generation.getTargetP())) {
                    p0[0] = p0[0] - generation.getTargetP();
                }
                if (!Double.isNaN(generation.getTargetQ())) {
                    q0[0] = q0[0] - generation.getTargetQ();
                }
            });
        }
        context.getWriter().writeDoubleAttribute("p0", p0[0]);
        context.getWriter().writeDoubleAttribute("q0", q0[0]);
        context.getWriter().writeDoubleAttribute("r", dl.getR());
        context.getWriter().writeDoubleAttribute("x", dl.getX());
        context.getWriter().writeDoubleAttribute("g", dl.getG());
        context.getWriter().writeDoubleAttribute("b", dl.getB());
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_3, context, () -> {
            context.getWriter().writeOptionalBooleanAttribute("generationVoltageRegulationOn", DanglingLineSerDe.getOptionalValue(generation, DanglingLine.Generation::isVoltageRegulationOn));
            context.getWriter().writeOptionalDoubleAttribute(GENERATION_MIN_P, DanglingLineSerDe.getOptionalValue(generation, DanglingLine.Generation::getMinP));
            context.getWriter().writeOptionalDoubleAttribute(GENERATION_MAX_P, DanglingLineSerDe.getOptionalValue(generation, DanglingLine.Generation::getMaxP));
            context.getWriter().writeOptionalDoubleAttribute(GENERATION_TARGET_P, DanglingLineSerDe.getOptionalValue(generation, DanglingLine.Generation::getTargetP));
            context.getWriter().writeOptionalDoubleAttribute(GENERATION_TARGET_V, DanglingLineSerDe.getOptionalValue(generation, DanglingLine.Generation::getTargetV));
            context.getWriter().writeOptionalDoubleAttribute(GENERATION_TARGET_Q, DanglingLineSerDe.getOptionalValue(generation, DanglingLine.Generation::getTargetQ));
        });
        Terminal t = terminalGetter.get();
        ConnectableSerDeUtil.writeNodeOrBus(null, t, context);
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_10, context, () -> context.getWriter().writeStringAttribute("ucteXnodeCode", dl.getPairingKey()));
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_11, context, () -> context.getWriter().writeStringAttribute("pairingKey", dl.getPairingKey()));
        ConnectableSerDeUtil.writePQ(null, t, context.getWriter());
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> ConnectableSerDeUtil.writeSelectedGroupId(null, dl.getSelectedOperationalLimitsGroupId().orElse(null), context.getWriter()));
    }

    private static <T> T getOptionalValue(DanglingLine.Generation generation, Function<DanglingLine.Generation, T> valueGetter) {
        return Optional.ofNullable(generation).map(valueGetter).orElse(null);
    }

    @Override
    protected DanglingLineAdder createAdder(VoltageLevel parent) {
        return parent.newDanglingLine();
    }

    @Override
    protected void writeSubElements(DanglingLine dl, VoltageLevel vl, NetworkSerializerContext context) {
        if (dl.getGeneration() != null) {
            IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_3, context, () -> ReactiveLimitsSerDe.INSTANCE.write((ReactiveLimitsHolder)dl.getGeneration(), context));
        }
        ConnectableSerDeUtil.writeLimits(context, null, ROOT_ELEMENT_NAME, dl.getSelectedOperationalLimitsGroup().orElse(null), dl.getOperationalLimitsGroups());
    }

    @Override
    protected DanglingLine readRootElementAttributes(DanglingLineAdder adder, VoltageLevel voltageLevel, NetworkDeserializerContext context) {
        DanglingLineSerDe.readRootElementAttributesInternal(adder, voltageLevel, context);
        IidmSerDeUtil.runUntilMaximumVersion(IidmVersion.V_1_10, context, () -> {
            String pairingKey = context.getReader().readStringAttribute("ucteXnodeCode");
            adder.setPairingKey(pairingKey);
        });
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_11, context, () -> {
            String pairingKey = context.getReader().readStringAttribute("pairingKey");
            adder.setPairingKey(pairingKey);
        });
        DanglingLine dl = adder.add();
        ConnectableSerDeUtil.readPQ(null, dl.getTerminal(), context.getReader());
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> ConnectableSerDeUtil.readSelectedGroupId(null, arg_0 -> ((DanglingLine)dl).setSelectedOperationalLimitsGroup(arg_0), context));
        return dl;
    }

    public static void readRootElementAttributesInternal(DanglingLineAdder adder, VoltageLevel voltageLevel, NetworkDeserializerContext context) {
        double p0 = context.getReader().readDoubleAttribute("p0");
        double q0 = context.getReader().readDoubleAttribute("q0");
        double r = context.getReader().readDoubleAttribute("r");
        double x = context.getReader().readDoubleAttribute("x");
        double g = context.getReader().readDoubleAttribute("g");
        double b = context.getReader().readDoubleAttribute("b");
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_3, context, () -> {
            Optional voltageRegulationOn = context.getReader().readOptionalBooleanAttribute("generationVoltageRegulationOn");
            OptionalDouble minP = context.getReader().readOptionalDoubleAttribute(GENERATION_MIN_P);
            OptionalDouble maxP = context.getReader().readOptionalDoubleAttribute(GENERATION_MAX_P);
            OptionalDouble targetP = context.getReader().readOptionalDoubleAttribute(GENERATION_TARGET_P);
            OptionalDouble targetV = context.getReader().readOptionalDoubleAttribute(GENERATION_TARGET_V);
            OptionalDouble targetQ = context.getReader().readOptionalDoubleAttribute(GENERATION_TARGET_Q);
            if (voltageRegulationOn.isPresent()) {
                DanglingLineAdder.GenerationAdder generationAdder = adder.newGeneration().setVoltageRegulationOn(((Boolean)voltageRegulationOn.get()).booleanValue());
                minP.ifPresent(arg_0 -> ((DanglingLineAdder.GenerationAdder)generationAdder).setMinP(arg_0));
                maxP.ifPresent(arg_0 -> ((DanglingLineAdder.GenerationAdder)generationAdder).setMaxP(arg_0));
                targetP.ifPresent(arg_0 -> ((DanglingLineAdder.GenerationAdder)generationAdder).setTargetP(arg_0));
                targetV.ifPresent(arg_0 -> ((DanglingLineAdder.GenerationAdder)generationAdder).setTargetV(arg_0));
                targetQ.ifPresent(arg_0 -> ((DanglingLineAdder.GenerationAdder)generationAdder).setTargetQ(arg_0));
                generationAdder.add();
            }
        });
        ConnectableSerDeUtil.readNodeOrBus(adder, context, voltageLevel.getTopologyKind());
        adder.setP0(p0).setQ0(q0).setR(r).setX(x).setG(g).setB(b);
    }

    @Override
    protected void readSubElements(DanglingLine dl, NetworkDeserializerContext context) {
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "operationalLimitsGroup": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "operationalLimitsGroup", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_12, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> ConnectableSerDeUtil.readLoadingLimitsGroups((FlowsLimitsHolder)dl, "operationalLimitsGroup", context));
                    break;
                }
                case "activePowerLimits": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readActivePowerLimits(dl.getOrCreateSelectedOperationalLimitsGroup().newActivePowerLimits(), context));
                    break;
                }
                case "apparentPowerLimits": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readApparentPowerLimits(dl.getOrCreateSelectedOperationalLimitsGroup().newApparentPowerLimits(), context));
                    break;
                }
                case "currentLimits": {
                    ConnectableSerDeUtil.readCurrentLimits(dl.getOrCreateSelectedOperationalLimitsGroup().newCurrentLimits(), context);
                    break;
                }
                case "reactiveCapabilityCurve": {
                    IidmSerDeUtil.assertMinimumVersion("danglingLine.generation", "reactiveLimits", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_3, context);
                    ReactiveLimitsSerDe.INSTANCE.readReactiveCapabilityCurve((ReactiveLimitsHolder)dl.getGeneration(), context);
                    break;
                }
                case "minMaxReactiveLimits": {
                    IidmSerDeUtil.assertMinimumVersion("danglingLine.generation", "reactiveLimits", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_3, context);
                    ReactiveLimitsSerDe.INSTANCE.readMinMaxReactiveLimits((ReactiveLimitsHolder)dl.getGeneration(), context);
                    break;
                }
                default: {
                    this.readSubElement(elementName, dl, context);
                }
            }
        });
    }
}

