/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.TopologyLevel;
import com.powsybl.iidm.serde.AbstractOptions;
import com.powsybl.iidm.serde.IidmSerDeConstants;
import com.powsybl.iidm.serde.IidmVersion;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ExportOptions
extends AbstractOptions<ExportOptions> {
    private boolean withBranchSV = true;
    private boolean indent = true;
    private boolean onlyMainCc = false;
    private boolean anonymized = false;
    private TopologyLevel topologyLevel = TopologyLevel.NODE_BREAKER;
    private boolean throwExceptionIfExtensionNotFound = false;
    private String version;
    private IidmVersionIncompatibilityBehavior iidmVersionIncompatibilityBehavior = IidmVersionIncompatibilityBehavior.THROW_EXCEPTION;
    private final Map<String, String> extensionsVersions = new HashMap<String, String>();
    private final Map<String, TopologyLevel> voltageLevelTopologyLevel = new HashMap<String, TopologyLevel>();
    private Charset charset = StandardCharsets.UTF_8;
    private boolean sorted = false;
    private boolean withAutomationSystems = true;

    public ExportOptions() {
    }

    public ExportOptions(boolean withBranchSV, boolean indent, boolean onlyMainCc, TopologyLevel topologyLevel, boolean throwExceptionIfExtensionNotFound) {
        this(withBranchSV, indent, onlyMainCc, topologyLevel, throwExceptionIfExtensionNotFound, false);
    }

    public ExportOptions(boolean withBranchSV, boolean indent, boolean onlyMainCc, TopologyLevel topologyLevel, boolean throwExceptionIfExtensionNotFound, boolean sorted) {
        this(withBranchSV, indent, onlyMainCc, topologyLevel, throwExceptionIfExtensionNotFound, sorted, null);
    }

    public ExportOptions(boolean withBranchSV, boolean indent, boolean onlyMainCc, TopologyLevel topologyLevel, boolean throwExceptionIfExtensionNotFound, String version) {
        this(withBranchSV, indent, onlyMainCc, topologyLevel, throwExceptionIfExtensionNotFound, false, version);
    }

    public ExportOptions(boolean withBranchSV, boolean indent, boolean onlyMainCc, TopologyLevel topologyLevel, boolean throwExceptionIfExtensionNotFound, boolean sorted, String version) {
        this(withBranchSV, indent, onlyMainCc, topologyLevel, throwExceptionIfExtensionNotFound, sorted, version, IidmVersionIncompatibilityBehavior.THROW_EXCEPTION);
    }

    public ExportOptions(boolean withBranchSV, boolean indent, boolean onlyMainCc, TopologyLevel topologyLevel, boolean throwExceptionIfExtensionNotFound, boolean sorted, String version, IidmVersionIncompatibilityBehavior iidmVersionIncompatibilityBehavior) {
        this.withBranchSV = withBranchSV;
        this.indent = indent;
        this.onlyMainCc = onlyMainCc;
        this.topologyLevel = Objects.requireNonNull(topologyLevel);
        this.throwExceptionIfExtensionNotFound = throwExceptionIfExtensionNotFound;
        this.sorted = sorted;
        this.version = version;
        this.iidmVersionIncompatibilityBehavior = Objects.requireNonNull(iidmVersionIncompatibilityBehavior);
    }

    public boolean isWithBranchSV() {
        return this.withBranchSV;
    }

    public ExportOptions setWithBranchSV(boolean withBranchSV) {
        this.withBranchSV = withBranchSV;
        return this;
    }

    public boolean isIndent() {
        return this.indent;
    }

    public ExportOptions setIndent(boolean indent) {
        this.indent = indent;
        return this;
    }

    public boolean isOnlyMainCc() {
        return this.onlyMainCc;
    }

    public ExportOptions setOnlyMainCc(boolean onlyMainCc) {
        this.onlyMainCc = onlyMainCc;
        return this;
    }

    public boolean isAnonymized() {
        return this.anonymized;
    }

    public ExportOptions setAnonymized(boolean anonymized) {
        this.anonymized = anonymized;
        return this;
    }

    public TopologyLevel getTopologyLevel() {
        return this.topologyLevel;
    }

    public ExportOptions setTopologyLevel(TopologyLevel topologyLevel) {
        this.topologyLevel = Objects.requireNonNull(topologyLevel);
        return this;
    }

    @Override
    public boolean isThrowExceptionIfExtensionNotFound() {
        return this.throwExceptionIfExtensionNotFound;
    }

    public ExportOptions setThrowExceptionIfExtensionNotFound(boolean throwException) {
        this.throwExceptionIfExtensionNotFound = throwException;
        return this;
    }

    public IidmVersion getVersion() {
        return this.version != null ? IidmVersion.of(this.version, ".") : IidmSerDeConstants.CURRENT_IIDM_VERSION;
    }

    public ExportOptions setVersion(String version) {
        this.version = version;
        return this;
    }

    public IidmVersionIncompatibilityBehavior getIidmVersionIncompatibilityBehavior() {
        return this.iidmVersionIncompatibilityBehavior;
    }

    public ExportOptions setIidmVersionIncompatibilityBehavior(IidmVersionIncompatibilityBehavior iidmVersionIncompatibilityBehavior) {
        this.iidmVersionIncompatibilityBehavior = Objects.requireNonNull(iidmVersionIncompatibilityBehavior);
        return this;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public ExportOptions setCharset(Charset charset) {
        Objects.requireNonNull(charset);
        this.charset = charset;
        return this;
    }

    public ExportOptions addExtensionVersion(String extensionName, String extensionVersion) {
        if (this.includedExtensions != null && !this.includedExtensions.contains(extensionName)) {
            throw new PowsyblException(extensionName + " is not an extension you have included in the extensions inclusion list to export.");
        }
        if (this.excludedExtensions != null && this.excludedExtensions.contains(extensionName)) {
            throw new PowsyblException(extensionName + " is an extension you have excluded in the extensions exclusion list to export.");
        }
        if (this.extensionsVersions.putIfAbsent(extensionName, extensionVersion) != null) {
            throw new PowsyblException("The version of " + extensionName + "'s XML serializer has already been set.");
        }
        return this;
    }

    public Optional<String> getExtensionVersion(String extensionName) {
        return Optional.ofNullable(this.extensionsVersions.get(extensionName));
    }

    public ExportOptions addVoltageLevelTopologyLevel(String voltageLevelId, TopologyLevel topologyLevel) {
        if (!voltageLevelId.isEmpty()) {
            this.voltageLevelTopologyLevel.put(voltageLevelId, topologyLevel);
        }
        return this;
    }

    public TopologyLevel getVoltageLevelTopologyLevel(String voltageLevelId) {
        return this.voltageLevelTopologyLevel.get(voltageLevelId);
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public ExportOptions setSorted(boolean sorted) {
        this.sorted = sorted;
        return this;
    }

    public boolean isWithAutomationSystems() {
        return this.withAutomationSystems;
    }

    public ExportOptions setWithAutomationSystems(boolean withAutomationSystems) {
        this.withAutomationSystems = withAutomationSystems;
        return this;
    }

    public static enum IidmVersionIncompatibilityBehavior {
        THROW_EXCEPTION,
        LOG_ERROR;

    }
}

