/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.commons.config.ConfigurationException;
import com.powsybl.commons.parameters.Parameter;
import com.powsybl.commons.parameters.ParameterDefaultValueConfig;
import com.powsybl.iidm.serde.AbstractOptions;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtensionOptionsUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtensionOptionsUtil.class);

    private ExtensionOptionsUtil() {
    }

    public static <T extends AbstractOptions<T>> boolean getAndCheckExtensionsToInclude(Properties parameters, T options, String format, ParameterDefaultValueConfig defaultValueConfig, Parameter includeListParameter, Parameter excludeListParameter, boolean shouldWarnOnInclusionEmptiness) {
        List includedExtensions = Parameter.readStringList((String)format, (Properties)parameters, (Parameter)includeListParameter, (ParameterDefaultValueConfig)defaultValueConfig);
        List excludedExtensions = Parameter.readStringList((String)format, (Properties)parameters, (Parameter)excludeListParameter, (ParameterDefaultValueConfig)defaultValueConfig);
        if (includedExtensions != null && excludedExtensions != null) {
            throw new ConfigurationException("You can't define both included and excluded extensions in parameters.");
        }
        if (excludedExtensions != null) {
            options.setExcludedExtensions(new HashSet<String>(excludedExtensions));
        }
        if (includedExtensions != null) {
            options.setIncludedExtensions(new HashSet<String>(includedExtensions));
            if (includedExtensions.isEmpty()) {
                if (shouldWarnOnInclusionEmptiness) {
                    LOGGER.info("All extensions are excluded.");
                }
                return false;
            }
        }
        return true;
    }
}

