/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.ReactiveLimitsHolder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.serde.AbstractSimpleIdentifiableSerDe;
import com.powsybl.iidm.serde.ConnectableSerDeUtil;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.ReactiveLimitsSerDe;
import com.powsybl.iidm.serde.TerminalRefSerDe;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;

class GeneratorSerDe
extends AbstractSimpleIdentifiableSerDe<Generator, GeneratorAdder, VoltageLevel> {
    static final GeneratorSerDe INSTANCE = new GeneratorSerDe();
    static final String ROOT_ELEMENT_NAME = "generator";
    static final String ARRAY_ELEMENT_NAME = "generators";

    GeneratorSerDe() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected void writeRootElementAttributes(Generator g, VoltageLevel vl, NetworkSerializerContext context) {
        context.getWriter().writeEnumAttribute("energySource", (Enum)g.getEnergySource());
        context.getWriter().writeDoubleAttribute("minP", g.getMinP());
        context.getWriter().writeDoubleAttribute("maxP", g.getMaxP());
        context.getWriter().writeDoubleAttribute("ratedS", g.getRatedS());
        context.getWriter().writeBooleanAttribute("voltageRegulatorOn", g.isVoltageRegulatorOn());
        context.getWriter().writeDoubleAttribute("targetP", g.getTargetP());
        context.getWriter().writeDoubleAttribute("targetV", g.getTargetV());
        context.getWriter().writeDoubleAttribute("targetQ", g.getTargetQ());
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_13, context, () -> context.getWriter().writeBooleanAttribute("isCondenser", g.isCondenser(), false));
        ConnectableSerDeUtil.writeNodeOrBus(null, g.getTerminal(), context);
        ConnectableSerDeUtil.writePQ(null, g.getTerminal(), context.getWriter());
    }

    @Override
    protected void writeSubElements(Generator g, VoltageLevel vl, NetworkSerializerContext context) {
        if (g != g.getRegulatingTerminal().getConnectable()) {
            TerminalRefSerDe.writeTerminalRef(g.getRegulatingTerminal(), context, "regulatingTerminal");
        }
        ReactiveLimitsSerDe.INSTANCE.write((ReactiveLimitsHolder)g, context);
    }

    @Override
    protected GeneratorAdder createAdder(VoltageLevel vl) {
        return vl.newGenerator();
    }

    @Override
    protected Generator readRootElementAttributes(GeneratorAdder adder, VoltageLevel voltageLevel, NetworkDeserializerContext context) {
        EnergySource energySource = (EnergySource)context.getReader().readEnumAttribute("energySource", EnergySource.class);
        double minP = context.getReader().readDoubleAttribute("minP");
        double maxP = context.getReader().readDoubleAttribute("maxP");
        double ratedS = context.getReader().readDoubleAttribute("ratedS");
        boolean voltageRegulatorOn = context.getReader().readBooleanAttribute("voltageRegulatorOn");
        double targetP = context.getReader().readDoubleAttribute("targetP");
        double targetV = context.getReader().readDoubleAttribute("targetV");
        double targetQ = context.getReader().readDoubleAttribute("targetQ");
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_13, context, () -> adder.setCondenser(context.getReader().readBooleanAttribute("isCondenser", false)));
        ConnectableSerDeUtil.readNodeOrBus(adder, context, voltageLevel.getTopologyKind());
        adder.setEnergySource(energySource).setMinP(minP).setMaxP(maxP).setRatedS(ratedS).setTargetP(targetP).setTargetV(targetV).setTargetQ(targetQ).setVoltageRegulatorOn(voltageRegulatorOn);
        Generator g = adder.add();
        ConnectableSerDeUtil.readPQ(null, g.getTerminal(), context.getReader());
        return g;
    }

    @Override
    protected void readSubElements(Generator g, NetworkDeserializerContext context) {
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "regulatingTerminal": {
                    TerminalRefSerDe.readTerminalRef(context, g.getNetwork(), arg_0 -> ((Generator)g).setRegulatingTerminal(arg_0));
                    break;
                }
                case "reactiveCapabilityCurve": {
                    ReactiveLimitsSerDe.INSTANCE.readReactiveCapabilityCurve((ReactiveLimitsHolder)g, context);
                    break;
                }
                case "minMaxReactiveLimits": {
                    ReactiveLimitsSerDe.INSTANCE.readMinMaxReactiveLimits((ReactiveLimitsHolder)g, context);
                    break;
                }
                default: {
                    this.readSubElement(elementName, g, context);
                }
            }
        });
    }
}

