/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.Line;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.serde.AbstractSimpleIdentifiableSerDe;
import com.powsybl.iidm.serde.ConnectableSerDeUtil;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;

class LineSerDe
extends AbstractSimpleIdentifiableSerDe<Line, LineAdder, Network> {
    static final LineSerDe INSTANCE = new LineSerDe();
    static final String ROOT_ELEMENT_NAME = "line";
    static final String ARRAY_ELEMENT_NAME = "lines";

    LineSerDe() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected void writeRootElementAttributes(Line l, Network n, NetworkSerializerContext context) {
        context.getWriter().writeDoubleAttribute("r", l.getR());
        context.getWriter().writeDoubleAttribute("x", l.getX());
        context.getWriter().writeDoubleAttribute("g1", l.getG1());
        context.getWriter().writeDoubleAttribute("b1", l.getB1());
        context.getWriter().writeDoubleAttribute("g2", l.getG2());
        context.getWriter().writeDoubleAttribute("b2", l.getB2());
        ConnectableSerDeUtil.writeNodeOrBus(1, l.getTerminal1(), context);
        ConnectableSerDeUtil.writeNodeOrBus(2, l.getTerminal2(), context);
        ConnectableSerDeUtil.writeOptionalPQ(1, l.getTerminal1(), context.getWriter(), context.getOptions()::isWithBranchSV);
        ConnectableSerDeUtil.writeOptionalPQ(2, l.getTerminal2(), context.getWriter(), context.getOptions()::isWithBranchSV);
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> {
            ConnectableSerDeUtil.writeSelectedGroupId(1, l.getSelectedOperationalLimitsGroupId1().orElse(null), context.getWriter());
            ConnectableSerDeUtil.writeSelectedGroupId(2, l.getSelectedOperationalLimitsGroupId2().orElse(null), context.getWriter());
        });
    }

    @Override
    protected void writeSubElements(Line l, Network n, NetworkSerializerContext context) {
        ConnectableSerDeUtil.writeLimits(context, 1, ROOT_ELEMENT_NAME, l.getSelectedOperationalLimitsGroup1().orElse(null), l.getOperationalLimitsGroups1());
        ConnectableSerDeUtil.writeLimits(context, 2, ROOT_ELEMENT_NAME, l.getSelectedOperationalLimitsGroup2().orElse(null), l.getOperationalLimitsGroups2());
    }

    @Override
    protected LineAdder createAdder(Network n) {
        return n.newLine();
    }

    @Override
    protected Line readRootElementAttributes(LineAdder adder, Network network, NetworkDeserializerContext context) {
        double r = context.getReader().readDoubleAttribute("r");
        double x = context.getReader().readDoubleAttribute("x");
        double g1 = context.getReader().readDoubleAttribute("g1");
        double b1 = context.getReader().readDoubleAttribute("b1");
        double g2 = context.getReader().readDoubleAttribute("g2");
        double b2 = context.getReader().readDoubleAttribute("b2");
        adder.setR(r).setX(x).setG1(g1).setB1(b1).setG2(g2).setB2(b2);
        ConnectableSerDeUtil.readVoltageLevelAndNodeOrBus(adder, network, context);
        Line l = adder.add();
        ConnectableSerDeUtil.readOptionalPQ(1, l.getTerminal1(), context.getReader());
        ConnectableSerDeUtil.readOptionalPQ(2, l.getTerminal2(), context.getReader());
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> {
            ConnectableSerDeUtil.readSelectedGroupId(1, arg_0 -> ((Line)l).setSelectedOperationalLimitsGroup1(arg_0), context);
            ConnectableSerDeUtil.readSelectedGroupId(2, arg_0 -> ((Line)l).setSelectedOperationalLimitsGroup2(arg_0), context);
        });
        return l;
    }

    @Override
    protected void readSubElements(Line l, NetworkDeserializerContext context) {
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "operationalLimitsGroup1": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "operationalLimitsGroup1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_12, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> ConnectableSerDeUtil.readLoadingLimitsGroup(arg_0 -> ((Line)l).newOperationalLimitsGroup1(arg_0), "operationalLimitsGroup1", context));
                    break;
                }
                case "activePowerLimits1": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readActivePowerLimits(l.getOrCreateSelectedOperationalLimitsGroup1().newActivePowerLimits(), context));
                    break;
                }
                case "apparentPowerLimits1": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readApparentPowerLimits(l.getOrCreateSelectedOperationalLimitsGroup1().newApparentPowerLimits(), context));
                    break;
                }
                case "currentLimits1": {
                    ConnectableSerDeUtil.readCurrentLimits(l.getOrCreateSelectedOperationalLimitsGroup1().newCurrentLimits(), context);
                    break;
                }
                case "operationalLimitsGroup2": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "operationalLimitsGroups2", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_12, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> ConnectableSerDeUtil.readLoadingLimitsGroup(arg_0 -> ((Line)l).newOperationalLimitsGroup2(arg_0), "operationalLimitsGroup2", context));
                    break;
                }
                case "activePowerLimits2": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits2", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readActivePowerLimits(l.getOrCreateSelectedOperationalLimitsGroup2().newActivePowerLimits(), context));
                    break;
                }
                case "apparentPowerLimits2": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits2", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readApparentPowerLimits(l.getOrCreateSelectedOperationalLimitsGroup2().newApparentPowerLimits(), context));
                    break;
                }
                case "currentLimits2": {
                    ConnectableSerDeUtil.readCurrentLimits(l.getOrCreateSelectedOperationalLimitsGroup2().newCurrentLimits(), context);
                    break;
                }
                default: {
                    super.readSubElement(elementName, l, context);
                }
            }
        });
    }
}

