/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.commons.io.SerializerContext;
import com.powsybl.commons.io.TreeDataWriter;
import com.powsybl.iidm.network.Identifiable;
import com.powsybl.iidm.serde.AbstractNetworkSerDeContext;
import com.powsybl.iidm.serde.BusFilter;
import com.powsybl.iidm.serde.ExportOptions;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.anonymizer.Anonymizer;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class NetworkSerializerContext
extends AbstractNetworkSerDeContext<ExportOptions>
implements SerializerContext {
    private final TreeDataWriter writer;
    private final ExportOptions options;
    private final BusFilter filter;
    private final boolean valid;
    private final Set<Identifiable> exportedEquipments;

    NetworkSerializerContext(Anonymizer anonymizer, TreeDataWriter writer, ExportOptions options, BusFilter filter, IidmVersion version, boolean valid) {
        super(anonymizer, version);
        this.writer = Objects.requireNonNull(writer);
        this.options = options;
        this.filter = filter;
        this.valid = valid;
        this.exportedEquipments = new HashSet<Identifiable>();
    }

    public TreeDataWriter getWriter() {
        return this.writer;
    }

    @Override
    public ExportOptions getOptions() {
        return this.options;
    }

    public BusFilter getFilter() {
        return this.filter;
    }

    public boolean isValid() {
        return this.valid;
    }

    public Set<Identifiable> getExportedEquipments() {
        return Collections.unmodifiableSet(this.exportedEquipments);
    }

    public void addExportedEquipment(Identifiable<?> equipment) {
        this.exportedEquipments.add(equipment);
    }

    public boolean isExportedEquipment(Identifiable<?> equipment) {
        return this.exportedEquipments.contains(equipment);
    }

    public Optional<String> getExtensionVersion(String extensionName) {
        return this.options.getExtensionVersion(extensionName);
    }

    public String getNamespaceURI() {
        return this.getVersion().getNamespaceURI(this.valid);
    }
}

