/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde;

import com.powsybl.iidm.network.FlowsLimitsHolder;
import com.powsybl.iidm.network.PhaseTapChanger;
import com.powsybl.iidm.network.RatioTapChanger;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.ThreeWindingsTransformerAdder;
import com.powsybl.iidm.serde.AbstractTransformerSerDe;
import com.powsybl.iidm.serde.ConnectableSerDeUtil;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.util.IidmSerDeUtil;

class ThreeWindingsTransformerSerDe
extends AbstractTransformerSerDe<ThreeWindingsTransformer, ThreeWindingsTransformerAdder> {
    static final ThreeWindingsTransformerSerDe INSTANCE = new ThreeWindingsTransformerSerDe();
    static final String ROOT_ELEMENT_NAME = "threeWindingsTransformer";
    static final String ARRAY_ELEMENT_NAME = "threeWindingsTransformers";
    private static final String RATIO_TAP_CHANGER_1 = "ratioTapChanger1";
    private static final String PHASE_TAP_CHANGER_1 = "phaseTapChanger1";
    private static final String RATIO_TAP_CHANGER_2 = "ratioTapChanger2";
    private static final String PHASE_TAP_CHANGER_2 = "phaseTapChanger2";
    private static final String RATIO_TAP_CHANGER_3 = "ratioTapChanger3";
    private static final String PHASE_TAP_CHANGER_3 = "phaseTapChanger3";

    ThreeWindingsTransformerSerDe() {
    }

    @Override
    protected String getRootElementName() {
        return ROOT_ELEMENT_NAME;
    }

    @Override
    protected void writeRootElementAttributes(ThreeWindingsTransformer twt, Substation s, NetworkSerializerContext context) {
        context.getWriter().writeDoubleAttribute("r1", twt.getLeg1().getR());
        context.getWriter().writeDoubleAttribute("x1", twt.getLeg1().getX());
        context.getWriter().writeDoubleAttribute("g1", twt.getLeg1().getG());
        context.getWriter().writeDoubleAttribute("b1", twt.getLeg1().getB());
        context.getWriter().writeDoubleAttribute("ratedU1", twt.getLeg1().getRatedU());
        ThreeWindingsTransformerSerDe.writeRatedS("ratedS1", twt.getLeg1().getRatedS(), context);
        context.getWriter().writeDoubleAttribute("r2", twt.getLeg2().getR());
        context.getWriter().writeDoubleAttribute("x2", twt.getLeg2().getX());
        IidmSerDeUtil.writeDoubleAttributeFromMinimumVersion(ROOT_ELEMENT_NAME, "g2", twt.getLeg2().getG(), 0.0, IidmSerDeUtil.ErrorMessage.NOT_DEFAULT_NOT_SUPPORTED, IidmVersion.V_1_1, context);
        IidmSerDeUtil.writeDoubleAttributeFromMinimumVersion(ROOT_ELEMENT_NAME, "b2", twt.getLeg2().getB(), 0.0, IidmSerDeUtil.ErrorMessage.NOT_DEFAULT_NOT_SUPPORTED, IidmVersion.V_1_1, context);
        context.getWriter().writeDoubleAttribute("ratedU2", twt.getLeg2().getRatedU());
        ThreeWindingsTransformerSerDe.writeRatedS("ratedS2", twt.getLeg2().getRatedS(), context);
        context.getWriter().writeDoubleAttribute("r3", twt.getLeg3().getR());
        context.getWriter().writeDoubleAttribute("x3", twt.getLeg3().getX());
        IidmSerDeUtil.writeDoubleAttributeFromMinimumVersion(ROOT_ELEMENT_NAME, "g3", twt.getLeg3().getG(), 0.0, IidmSerDeUtil.ErrorMessage.NOT_DEFAULT_NOT_SUPPORTED, IidmVersion.V_1_1, context);
        IidmSerDeUtil.writeDoubleAttributeFromMinimumVersion(ROOT_ELEMENT_NAME, "b3", twt.getLeg3().getB(), 0.0, IidmSerDeUtil.ErrorMessage.NOT_DEFAULT_NOT_SUPPORTED, IidmVersion.V_1_1, context);
        context.getWriter().writeDoubleAttribute("ratedU3", twt.getLeg3().getRatedU());
        ThreeWindingsTransformerSerDe.writeRatedS("ratedS3", twt.getLeg3().getRatedS(), context);
        IidmSerDeUtil.writeDoubleAttributeFromMinimumVersion(ROOT_ELEMENT_NAME, "ratedU0", twt.getRatedU0(), twt.getLeg1().getRatedU(), IidmSerDeUtil.ErrorMessage.NOT_DEFAULT_NOT_SUPPORTED, IidmVersion.V_1_1, context);
        ConnectableSerDeUtil.writeNodeOrBus(1, twt.getLeg1().getTerminal(), context);
        ConnectableSerDeUtil.writeNodeOrBus(2, twt.getLeg2().getTerminal(), context);
        ConnectableSerDeUtil.writeNodeOrBus(3, twt.getLeg3().getTerminal(), context);
        ConnectableSerDeUtil.writeOptionalPQ(1, twt.getLeg1().getTerminal(), context.getWriter(), context.getOptions()::isWithBranchSV);
        ConnectableSerDeUtil.writeOptionalPQ(2, twt.getLeg2().getTerminal(), context.getWriter(), context.getOptions()::isWithBranchSV);
        ConnectableSerDeUtil.writeOptionalPQ(3, twt.getLeg3().getTerminal(), context.getWriter(), context.getOptions()::isWithBranchSV);
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> {
            ConnectableSerDeUtil.writeSelectedGroupId(1, twt.getLeg1().getSelectedOperationalLimitsGroupId().orElse(null), context.getWriter());
            ConnectableSerDeUtil.writeSelectedGroupId(2, twt.getLeg2().getSelectedOperationalLimitsGroupId().orElse(null), context.getWriter());
            ConnectableSerDeUtil.writeSelectedGroupId(3, twt.getLeg3().getSelectedOperationalLimitsGroupId().orElse(null), context.getWriter());
        });
    }

    @Override
    protected void writeSubElements(ThreeWindingsTransformer twt, Substation s, NetworkSerializerContext context) {
        IidmSerDeUtil.assertMinimumVersionAndRunIfNotDefault(twt.getLeg1().hasRatioTapChanger(), ROOT_ELEMENT_NAME, RATIO_TAP_CHANGER_1, IidmSerDeUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmVersion.V_1_1, context, () -> ThreeWindingsTransformerSerDe.writeRatioTapChanger(twt.getLeg1().getRatioTapChanger(), 1, context));
        IidmSerDeUtil.assertMinimumVersionAndRunIfNotDefault(twt.getLeg1().hasPhaseTapChanger(), ROOT_ELEMENT_NAME, PHASE_TAP_CHANGER_1, IidmSerDeUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmVersion.V_1_1, context, () -> ThreeWindingsTransformerSerDe.writePhaseTapChanger(twt.getLeg1().getPhaseTapChanger(), 1, context));
        ThreeWindingsTransformerSerDe.writeRatioTapChanger(twt.getLeg2().getRatioTapChanger(), 2, context);
        IidmSerDeUtil.assertMinimumVersionAndRunIfNotDefault(twt.getLeg2().hasPhaseTapChanger(), ROOT_ELEMENT_NAME, PHASE_TAP_CHANGER_2, IidmSerDeUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmVersion.V_1_1, context, () -> ThreeWindingsTransformerSerDe.writePhaseTapChanger(twt.getLeg2().getPhaseTapChanger(), 2, context));
        ThreeWindingsTransformerSerDe.writeRatioTapChanger(twt.getLeg3().getRatioTapChanger(), 3, context);
        IidmSerDeUtil.assertMinimumVersionAndRunIfNotDefault(twt.getLeg3().hasPhaseTapChanger(), ROOT_ELEMENT_NAME, PHASE_TAP_CHANGER_3, IidmSerDeUtil.ErrorMessage.NOT_NULL_NOT_SUPPORTED, IidmVersion.V_1_1, context, () -> ThreeWindingsTransformerSerDe.writePhaseTapChanger(twt.getLeg3().getPhaseTapChanger(), 3, context));
        int[] i = new int[]{1};
        for (ThreeWindingsTransformer.Leg leg : twt.getLegs()) {
            ConnectableSerDeUtil.writeLimits(context, i[0], ROOT_ELEMENT_NAME, leg.getSelectedOperationalLimitsGroup().orElse(null), leg.getOperationalLimitsGroups());
            i[0] = i[0] + 1;
        }
    }

    private static void writeRatioTapChanger(RatioTapChanger rtc, int index, NetworkSerializerContext context) {
        if (rtc != null) {
            ThreeWindingsTransformerSerDe.writeRatioTapChanger("ratioTapChanger" + index, rtc, context);
        }
    }

    private static void writePhaseTapChanger(PhaseTapChanger ptc, int index, NetworkSerializerContext context) {
        if (ptc != null) {
            ThreeWindingsTransformerSerDe.writePhaseTapChanger("phaseTapChanger" + index, ptc, context);
        }
    }

    @Override
    protected ThreeWindingsTransformerAdder createAdder(Substation s) {
        return s.newThreeWindingsTransformer();
    }

    @Override
    protected ThreeWindingsTransformer readRootElementAttributes(ThreeWindingsTransformerAdder adder, Substation s, NetworkDeserializerContext context) {
        ThreeWindingsTransformerAdder.LegAdder legAdder1 = adder.newLeg1();
        ThreeWindingsTransformerAdder.LegAdder legAdder2 = adder.newLeg2();
        ThreeWindingsTransformerAdder.LegAdder legAdder3 = adder.newLeg3();
        double r1 = context.getReader().readDoubleAttribute("r1");
        double x1 = context.getReader().readDoubleAttribute("x1");
        double g1 = context.getReader().readDoubleAttribute("g1");
        double b1 = context.getReader().readDoubleAttribute("b1");
        double ratedU1 = context.getReader().readDoubleAttribute("ratedU1");
        legAdder1.setR(r1).setX(x1).setG(g1).setB(b1).setRatedU(ratedU1);
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_2, context, () -> ThreeWindingsTransformerSerDe.readRatedS("ratedS1", context, arg_0 -> ((ThreeWindingsTransformerAdder.LegAdder)legAdder1).setRatedS(arg_0)));
        double r2 = context.getReader().readDoubleAttribute("r2");
        double x2 = context.getReader().readDoubleAttribute("x2");
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_1, context, () -> {
            double g2 = context.getReader().readDoubleAttribute("g2");
            double b2 = context.getReader().readDoubleAttribute("b2");
            legAdder2.setG(g2).setB(b2);
        });
        double ratedU2 = context.getReader().readDoubleAttribute("ratedU2");
        legAdder2.setR(r2).setX(x2).setRatedU(ratedU2);
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_2, context, () -> ThreeWindingsTransformerSerDe.readRatedS("ratedS2", context, arg_0 -> ((ThreeWindingsTransformerAdder.LegAdder)legAdder2).setRatedS(arg_0)));
        double r3 = context.getReader().readDoubleAttribute("r3");
        double x3 = context.getReader().readDoubleAttribute("x3");
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_1, context, () -> {
            double g3 = context.getReader().readDoubleAttribute("g3");
            double b3 = context.getReader().readDoubleAttribute("b3");
            legAdder3.setG(g3).setB(b3);
        });
        double ratedU3 = context.getReader().readDoubleAttribute("ratedU3");
        legAdder3.setR(r3).setX(x3).setRatedU(ratedU3);
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_2, context, () -> ThreeWindingsTransformerSerDe.readRatedS("ratedS3", context, arg_0 -> ((ThreeWindingsTransformerAdder.LegAdder)legAdder3).setRatedS(arg_0)));
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_1, context, () -> {
            double ratedU0 = context.getReader().readDoubleAttribute("ratedU0");
            adder.setRatedU0(ratedU0);
        });
        ConnectableSerDeUtil.readNodeOrBus(1, legAdder1, s.getNetwork(), context);
        ConnectableSerDeUtil.readNodeOrBus(2, legAdder2, s.getNetwork(), context);
        ConnectableSerDeUtil.readNodeOrBus(3, legAdder3, s.getNetwork(), context);
        legAdder1.add();
        legAdder2.add();
        legAdder3.add();
        ThreeWindingsTransformer twt = adder.add();
        ConnectableSerDeUtil.readOptionalPQ(1, twt.getLeg1().getTerminal(), context.getReader());
        ConnectableSerDeUtil.readOptionalPQ(2, twt.getLeg2().getTerminal(), context.getReader());
        ConnectableSerDeUtil.readOptionalPQ(3, twt.getLeg3().getTerminal(), context.getReader());
        IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> {
            ConnectableSerDeUtil.readSelectedGroupId(1, arg_0 -> ((ThreeWindingsTransformer.Leg)twt.getLeg1()).setSelectedOperationalLimitsGroup(arg_0), context);
            ConnectableSerDeUtil.readSelectedGroupId(2, arg_0 -> ((ThreeWindingsTransformer.Leg)twt.getLeg2()).setSelectedOperationalLimitsGroup(arg_0), context);
            ConnectableSerDeUtil.readSelectedGroupId(3, arg_0 -> ((ThreeWindingsTransformer.Leg)twt.getLeg3()).setSelectedOperationalLimitsGroup(arg_0), context);
        });
        return twt;
    }

    @Override
    protected void readSubElements(ThreeWindingsTransformer tx, NetworkDeserializerContext context) {
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "operationalLimitsGroup1": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "operationalLimitsGroup1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_12, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> ConnectableSerDeUtil.readLoadingLimitsGroups((FlowsLimitsHolder)tx.getLeg1(), "operationalLimitsGroup1", context));
                    break;
                }
                case "activePowerLimits1": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readActivePowerLimits(tx.getLeg1().getOrCreateSelectedOperationalLimitsGroup().newActivePowerLimits(), context));
                    break;
                }
                case "apparentPowerLimits1": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits1", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readApparentPowerLimits(tx.getLeg1().getOrCreateSelectedOperationalLimitsGroup().newApparentPowerLimits(), context));
                    break;
                }
                case "currentLimits1": {
                    ConnectableSerDeUtil.readCurrentLimits(tx.getLeg1().getOrCreateSelectedOperationalLimitsGroup().newCurrentLimits(), context);
                    break;
                }
                case "operationalLimitsGroup2": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "operationalLimitsGroup2", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_12, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> ConnectableSerDeUtil.readLoadingLimitsGroups((FlowsLimitsHolder)tx.getLeg2(), "operationalLimitsGroup2", context));
                    break;
                }
                case "activePowerLimits2": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits2", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readActivePowerLimits(tx.getLeg2().getOrCreateSelectedOperationalLimitsGroup().newActivePowerLimits(), context));
                    break;
                }
                case "apparentPowerLimits2": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits2", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readApparentPowerLimits(tx.getLeg2().getOrCreateSelectedOperationalLimitsGroup().newApparentPowerLimits(), context));
                    break;
                }
                case "currentLimits2": {
                    ConnectableSerDeUtil.readCurrentLimits(tx.getLeg2().getOrCreateSelectedOperationalLimitsGroup().newCurrentLimits(), context);
                    break;
                }
                case "operationalLimitsGroup3": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "operationalLimitsGroup3", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_12, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_12, context, () -> ConnectableSerDeUtil.readLoadingLimitsGroups((FlowsLimitsHolder)tx.getLeg3(), "operationalLimitsGroup3", context));
                    break;
                }
                case "activePowerLimits3": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "activePowerLimits3", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readActivePowerLimits(tx.getLeg3().getOrCreateSelectedOperationalLimitsGroup().newActivePowerLimits(), context));
                    break;
                }
                case "apparentPowerLimits3": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, "apparentPowerLimits3", IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_5, context);
                    IidmSerDeUtil.runFromMinimumVersion(IidmVersion.V_1_5, context, () -> ConnectableSerDeUtil.readApparentPowerLimits(tx.getLeg3().getOrCreateSelectedOperationalLimitsGroup().newApparentPowerLimits(), context));
                    break;
                }
                case "currentLimits3": {
                    ConnectableSerDeUtil.readCurrentLimits(tx.getLeg3().getOrCreateSelectedOperationalLimitsGroup().newCurrentLimits(), context);
                    break;
                }
                case "ratioTapChanger1": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, RATIO_TAP_CHANGER_1, IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_1, context);
                    ThreeWindingsTransformerSerDe.readRatioTapChanger(1, tx.getLeg1(), context);
                    break;
                }
                case "phaseTapChanger1": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, PHASE_TAP_CHANGER_1, IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_1, context);
                    ThreeWindingsTransformerSerDe.readPhaseTapChanger(1, tx.getLeg1(), context);
                    break;
                }
                case "ratioTapChanger2": {
                    ThreeWindingsTransformerSerDe.readRatioTapChanger(2, tx.getLeg2(), context);
                    break;
                }
                case "phaseTapChanger2": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, PHASE_TAP_CHANGER_2, IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_1, context);
                    ThreeWindingsTransformerSerDe.readPhaseTapChanger(2, tx.getLeg2(), context);
                    break;
                }
                case "ratioTapChanger3": {
                    ThreeWindingsTransformerSerDe.readRatioTapChanger(3, tx.getLeg3(), context);
                    break;
                }
                case "phaseTapChanger3": {
                    IidmSerDeUtil.assertMinimumVersion(ROOT_ELEMENT_NAME, PHASE_TAP_CHANGER_3, IidmSerDeUtil.ErrorMessage.NOT_SUPPORTED, IidmVersion.V_1_1, context);
                    ThreeWindingsTransformerSerDe.readPhaseTapChanger(3, tx.getLeg3(), context);
                    break;
                }
                default: {
                    this.readSubElement(elementName, tx, context);
                }
            }
        });
    }
}

