/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde.extensions;

import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.Extendable;
import com.powsybl.commons.extensions.Extension;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.iidm.serde.IidmSerDeConstants;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkDeserializerContext;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.extensions.SerDeVersion;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractVersionableNetworkExtensionSerDe<T extends Extendable, E extends Extension<T>, V extends SerDeVersion<V>>
implements ExtensionSerDe<T, E> {
    private static final String INCOMPATIBILITY_NETWORK_VERSION_MESSAGE = "IIDM version of network (";
    private final String extensionName;
    private final Class<? super E> extensionClass;
    private final List<V> versions;

    protected AbstractVersionableNetworkExtensionSerDe(String extensionName, Class<? super E> extensionClass, V[] versions) {
        this.extensionName = Objects.requireNonNull(extensionName);
        this.extensionClass = Objects.requireNonNull(extensionClass);
        this.versions = Arrays.stream((SerDeVersion[])Objects.requireNonNull(versions)).sorted(Comparator.comparing(SerDeVersion::getVersionNumbers)).toList();
    }

    public String getExtensionName() {
        return this.extensionName;
    }

    public String getSerializationName(String extensionVersion) {
        return this.versionOf(extensionVersion).getSerializationName();
    }

    public Set<String> getSerializationNames() {
        return this.versions.stream().map(SerDeVersion::getSerializationName).collect(Collectors.toUnmodifiableSet());
    }

    public String getCategoryName() {
        return "network";
    }

    public Class<? super E> getExtensionClass() {
        return this.extensionClass;
    }

    public String getNamespaceUri() {
        return this.getNamespaceUri(this.getVersion());
    }

    public Stream<String> getNamespaceUriStream() {
        return this.versions.stream().map(SerDeVersion::getNamespaceUri);
    }

    public String getNamespaceUri(String extensionVersion) {
        return this.versionOf(extensionVersion, true).getNamespaceUri();
    }

    public String getVersion() {
        return this.getVersion(IidmSerDeConstants.CURRENT_IIDM_VERSION).getVersionString();
    }

    public boolean versionExists(IidmVersion networkVersion) {
        return this.versions.stream().anyMatch(version -> version.supports(networkVersion));
    }

    public V getVersion(IidmVersion networkVersion) {
        V defaultVersion = this.getDefaultVersion();
        if (defaultVersion.supports(networkVersion)) {
            return defaultVersion;
        }
        for (int i = this.versions.size() - 1; i >= 0; --i) {
            SerDeVersion v = (SerDeVersion)this.versions.get(i);
            if (!v.supports(networkVersion)) continue;
            return (V)v;
        }
        throw new PowsyblException("IIDM version " + String.valueOf((Object)networkVersion) + " is not supported by " + this.extensionName + " extension");
    }

    public String getVersion(String namespaceUri) {
        return this.versions.stream().filter(version -> version.getNamespaceUri().equals(namespaceUri)).map(SerDeVersion::getVersionString).findFirst().orElseThrow(() -> new PowsyblException("The namespace URI " + namespaceUri + " of the " + this.extensionName + " extension is not supported."));
    }

    public Set<String> getVersions() {
        return this.versions.stream().map(SerDeVersion::getVersionString).collect(Collectors.toUnmodifiableSet());
    }

    protected V getExtensionVersionImported(DeserializerContext context) {
        return (V)((NetworkDeserializerContext)context).getExtensionVersion(this).map(this::versionOf).orElseThrow(IllegalStateException::new);
    }

    protected V getExtensionVersionToExport(SerializerContext context) {
        NetworkSerializerContext networkSerializerContext = (NetworkSerializerContext)context;
        return (V)networkSerializerContext.getExtensionVersion(this.getExtensionName()).map(this::versionOf).orElseGet(() -> this.getVersion(networkSerializerContext.getVersion()));
    }

    public void checkReadingCompatibility(DeserializerContext context) {
        NetworkDeserializerContext networkContext = AbstractVersionableNetworkExtensionSerDe.convertContext(context);
        IidmVersion iidmVersion = networkContext.getVersion();
        this.checkCompatibilityNetworkVersion(iidmVersion);
        if (this.versions.stream().filter(v -> v.supports(iidmVersion)).noneMatch(v -> networkContext.containsExtensionVersion(this.getExtensionName(), v.getVersionString()))) {
            throw new PowsyblException(INCOMPATIBILITY_NETWORK_VERSION_MESSAGE + iidmVersion.toString(".") + ") is not compatible with the " + this.extensionName + " extension's namespace URI.");
        }
    }

    public boolean checkWritingCompatibility(String extensionVersion, IidmVersion iidmVersion) {
        if (!this.versionOf(extensionVersion, true).supports(iidmVersion)) {
            throw new PowsyblException(INCOMPATIBILITY_NETWORK_VERSION_MESSAGE + iidmVersion.toString(".") + ") is not compatible with " + this.extensionName + " version " + extensionVersion);
        }
        return true;
    }

    private void checkCompatibilityNetworkVersion(IidmVersion version) {
        if (this.versions.stream().noneMatch(v -> v.supports(version))) {
            throw new PowsyblException(INCOMPATIBILITY_NETWORK_VERSION_MESSAGE + version.toString(".") + ") is not supported by the " + this.getExtensionName() + " extension's XML serializer.");
        }
    }

    public String getNamespacePrefix() {
        return this.getDefaultVersion().getNamespacePrefix();
    }

    public String getNamespacePrefix(String extensionVersion) {
        return this.versionOf(extensionVersion, true).getNamespacePrefix();
    }

    public void checkExtensionVersionSupported(String extensionVersion) {
        this.versionOf(extensionVersion, true);
    }

    public InputStream getXsdAsStream() {
        return Objects.requireNonNull(this.getClass().getResourceAsStream(this.getDefaultVersion().getXsdResourcePath()));
    }

    public List<InputStream> getXsdAsStreamList() {
        return this.versions.stream().map(SerDeVersion::getXsdResourcePath).map(this.getClass()::getResourceAsStream).map(s -> Objects.requireNonNull(s, "xsd resource not found")).toList();
    }

    protected V getDefaultVersion() {
        return (V)((SerDeVersion)this.versions.get(this.versions.size() - 1));
    }

    public V versionOf(String extensionVersion) {
        return this.versionOf(extensionVersion, false);
    }

    private V versionOf(String extensionVersion, boolean throwIfUnknown) {
        Objects.requireNonNull(extensionVersion);
        Optional<SerDeVersion> a = this.versions.stream().filter(v -> extensionVersion.equals(v.getVersionString())).findFirst();
        if (throwIfUnknown) {
            return (V)a.orElseThrow(() -> new PowsyblException("The " + this.extensionName + " extension version " + extensionVersion + " is unknown."));
        }
        return (V)((SerDeVersion)a.orElse(null));
    }

    protected static NetworkSerializerContext convertContext(SerializerContext context) {
        if (context instanceof NetworkSerializerContext) {
            NetworkSerializerContext networkSerializerContext = (NetworkSerializerContext)context;
            return networkSerializerContext;
        }
        throw new IllegalArgumentException("context is not a NetworkXmlWriterContext");
    }

    protected static NetworkDeserializerContext convertContext(DeserializerContext context) {
        if (context instanceof NetworkDeserializerContext) {
            NetworkDeserializerContext networkDeserializerContext = (NetworkDeserializerContext)context;
            return networkDeserializerContext;
        }
        throw new IllegalArgumentException("context is not a NetworkXmlReaderContext");
    }
}

