/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.iidm.network.Injection;
import com.powsybl.iidm.network.extensions.ActivePowerControl;
import com.powsybl.iidm.network.extensions.ActivePowerControlAdder;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.extensions.AbstractVersionableNetworkExtensionSerDe;
import com.powsybl.iidm.serde.extensions.SerDeVersion;

@AutoService(value={ExtensionSerDe.class})
public class ActivePowerControlSerDe<T extends Injection<T>>
extends AbstractVersionableNetworkExtensionSerDe<T, ActivePowerControl<T>, Version> {
    public ActivePowerControlSerDe() {
        super("activePowerControl", ActivePowerControl.class, (SerDeVersion[])Version.values());
    }

    public void write(ActivePowerControl<T> activePowerControl, SerializerContext context) {
        context.getWriter().writeBooleanAttribute("participate", activePowerControl.isParticipate());
        context.getWriter().writeDoubleAttribute("droop", activePowerControl.getDroop());
        Version extVersion = (Version)this.getExtensionVersionToExport(context);
        if (extVersion.isGreaterThan(Version.V_1_0)) {
            context.getWriter().writeDoubleAttribute("participationFactor", activePowerControl.getParticipationFactor());
        }
        if (extVersion.isGreaterThan(Version.V_1_1)) {
            context.getWriter().writeDoubleAttribute("maxTargetP", activePowerControl.getMaxTargetP().orElse(Double.NaN));
            context.getWriter().writeDoubleAttribute("minTargetP", activePowerControl.getMinTargetP().orElse(Double.NaN));
        }
    }

    public ActivePowerControl<T> read(T identifiable, DeserializerContext context) {
        boolean participate = context.getReader().readBooleanAttribute("participate");
        double droop = context.getReader().readDoubleAttribute("droop");
        double participationFactor = Double.NaN;
        double minTargetP = Double.NaN;
        double maxTargetP = Double.NaN;
        Version extVersion = (Version)this.getExtensionVersionImported(context);
        if (extVersion.isGreaterThan(Version.V_1_0)) {
            participationFactor = context.getReader().readDoubleAttribute("participationFactor");
        }
        if (extVersion.isGreaterThan(Version.V_1_1)) {
            maxTargetP = context.getReader().readDoubleAttribute("maxTargetP");
            minTargetP = context.getReader().readDoubleAttribute("minTargetP");
        }
        context.getReader().readEndNode();
        ActivePowerControlAdder activePowerControlAdder = (ActivePowerControlAdder)identifiable.newExtension(ActivePowerControlAdder.class);
        return (ActivePowerControl)activePowerControlAdder.withParticipate(participate).withDroop(droop).withParticipationFactor(participationFactor).withMinTargetP(minTargetP).withMaxTargetP(maxTargetP).add();
    }

    public static enum Version implements SerDeVersion<Version>
    {
        V_1_0("/xsd/activePowerControl_V1_0.xsd", "http://www.itesla_project.eu/schema/iidm/ext/active_power_control/1_0", new SerDeVersion.VersionNumbers(1, 0), IidmVersion.V_1_0, IidmVersion.V_1_13),
        V_1_1("/xsd/activePowerControl_V1_1.xsd", "http://www.powsybl.org/schema/iidm/ext/active_power_control/1_1", new SerDeVersion.VersionNumbers(1, 1), IidmVersion.V_1_0, IidmVersion.V_1_13),
        V_1_2("/xsd/activePowerControl_V1_2.xsd", "http://www.powsybl.org/schema/iidm/ext/active_power_control/1_2", new SerDeVersion.VersionNumbers(1, 2), IidmVersion.V_1_13, null);

        private final SerDeVersion.VersionInfo versionInfo;

        private Version(String xsdResourcePath, String namespaceUri, SerDeVersion.VersionNumbers versionNumbers, IidmVersion minIidmVersionIncluded, IidmVersion maxIidmVersionExcluded) {
            this.versionInfo = new SerDeVersion.VersionInfo(xsdResourcePath, namespaceUri, "apc", versionNumbers, minIidmVersionIncluded, maxIidmVersionExcluded, "activePowerControl");
        }

        @Override
        public SerDeVersion.VersionInfo getVersionInfo() {
            return this.versionInfo;
        }
    }
}

