/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde.extensions;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSortedSet;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.extensions.BatteryShortCircuit;
import com.powsybl.iidm.network.extensions.BatteryShortCircuitAdder;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.extensions.AbstractVersionableNetworkExtensionSerDe;
import com.powsybl.iidm.serde.extensions.SerDeVersion;

@AutoService(value={ExtensionSerDe.class})
public class BatteryShortCircuitSerDe
extends AbstractVersionableNetworkExtensionSerDe<Battery, BatteryShortCircuit, Version> {
    private static final ImmutableSortedSet<Version> LEGACY_VERSIONS = ImmutableSortedSet.reverseOrder().add((Object[])new Version[]{Version.V_1_0_LEGACY, Version.V_1_0_LEGACY_2}).build();

    public BatteryShortCircuitSerDe() {
        super("batteryShortCircuit", BatteryShortCircuit.class, (SerDeVersion[])Version.values());
    }

    @Override
    public Version getVersion(IidmVersion networkVersion) {
        if (IidmVersion.V_1_13.compareTo(networkVersion) > 0) {
            return Version.V_1_0_LEGACY;
        }
        if (networkVersion == IidmVersion.V_1_13) {
            return Version.V_1_0;
        }
        return (Version)super.getVersion(networkVersion);
    }

    public void write(BatteryShortCircuit batteryShortCircuit, SerializerContext context) {
        Version extensionVersionToExport = (Version)this.getExtensionVersionToExport(context);
        if (LEGACY_VERSIONS.contains((Object)extensionVersionToExport)) {
            context.getWriter().writeFloatAttribute("transientReactance", (float)batteryShortCircuit.getDirectTransX());
            context.getWriter().writeFloatAttribute("stepUpTransformerReactance", (float)batteryShortCircuit.getStepUpTransformerX());
        } else {
            context.getWriter().writeDoubleAttribute("directSubtransX", batteryShortCircuit.getDirectSubtransX());
            context.getWriter().writeDoubleAttribute("directTransX", batteryShortCircuit.getDirectTransX());
            context.getWriter().writeDoubleAttribute("stepUpTransformerX", batteryShortCircuit.getStepUpTransformerX());
        }
    }

    public BatteryShortCircuit read(Battery battery, DeserializerContext context) {
        Version extensionVersionImported = (Version)this.getExtensionVersionImported(context);
        BatteryShortCircuitAdder batteryShortCircuitAdder = (BatteryShortCircuitAdder)battery.newExtension(BatteryShortCircuitAdder.class);
        if (LEGACY_VERSIONS.contains((Object)extensionVersionImported)) {
            ((BatteryShortCircuitAdder)batteryShortCircuitAdder.withDirectTransX((double)context.getReader().readFloatAttribute("transientReactance"))).withStepUpTransformerX((double)context.getReader().readFloatAttribute("stepUpTransformerReactance"));
        } else {
            ((BatteryShortCircuitAdder)((BatteryShortCircuitAdder)batteryShortCircuitAdder.withDirectSubtransX(context.getReader().readDoubleAttribute("directSubtransX"))).withDirectTransX(context.getReader().readDoubleAttribute("directTransX"))).withStepUpTransformerX(context.getReader().readDoubleAttribute("stepUpTransformerX"));
        }
        context.getReader().readEndNode();
        return (BatteryShortCircuit)batteryShortCircuitAdder.add();
    }

    public static enum Version implements SerDeVersion<Version>
    {
        V_1_0_LEGACY("/xsd/batteryShortCircuit_V1_0_legacy.xsd", "http://www.itesla_project.eu/schema/iidm/ext/battery_short_circuits/1_0", new SerDeVersion.VersionNumbers(1, 0, "legacy"), IidmVersion.V_1_0, IidmVersion.V_1_14, "batteryShortCircuits"),
        V_1_0_LEGACY_2("/xsd/batteryShortCircuit_V1_0_legacy_2.xsd", "http://www.itesla_project.eu/schema/iidm/ext/batteryshortcircuits/1_0", new SerDeVersion.VersionNumbers(1, 0, "legacy-2"), IidmVersion.V_1_0, IidmVersion.V_1_14, "batteryShortCircuits"),
        V_1_0("/xsd/batteryShortCircuit_V1_0.xsd", "http://www.itesla_project.eu/schema/iidm/ext/battery_short_circuit/1_0", new SerDeVersion.VersionNumbers(1, 0), IidmVersion.V_1_13, null);

        private final SerDeVersion.VersionInfo versionInfo;

        private Version(String xsdResourcePath, String namespaceUri, SerDeVersion.VersionNumbers versionNumbers, IidmVersion minIidmVersionIncluded, IidmVersion maxIidmVersionExcluded) {
            this.versionInfo = new SerDeVersion.VersionInfo(xsdResourcePath, namespaceUri, "bsc", versionNumbers, minIidmVersionIncluded, maxIidmVersionExcluded, "batteryShortCircuit");
        }

        private Version(String xsdResourcePath, String namespaceUri, SerDeVersion.VersionNumbers versionNumbers, IidmVersion minIidmVersionIncluded, IidmVersion maxIidmVersionExcluded, String serializationName) {
            this.versionInfo = new SerDeVersion.VersionInfo(xsdResourcePath, namespaceUri, "bsc", versionNumbers, minIidmVersionIncluded, maxIidmVersionExcluded, serializationName);
        }

        @Override
        public SerDeVersion.VersionInfo getVersionInfo() {
            return this.versionInfo;
        }
    }
}

