/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.PowsyblException;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.iidm.network.Connectable;
import com.powsybl.iidm.network.extensions.ConnectablePosition;
import com.powsybl.iidm.network.extensions.ConnectablePositionAdder;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.NetworkSerializerContext;
import com.powsybl.iidm.serde.extensions.AbstractVersionableNetworkExtensionSerDe;
import com.powsybl.iidm.serde.extensions.SerDeVersion;

@AutoService(value={ExtensionSerDe.class})
public class ConnectablePositionSerDe<C extends Connectable<C>>
extends AbstractVersionableNetworkExtensionSerDe<C, ConnectablePosition<C>, Version> {
    public ConnectablePositionSerDe() {
        super("position", ConnectablePosition.class, (SerDeVersion[])Version.values());
    }

    private void writePosition(String connectableId, ConnectablePosition.Feeder feeder, Integer i, NetworkSerializerContext context) {
        context.getWriter().writeStartNode(context.getExtensionVersion("position").map(this::getNamespaceUri).orElseGet(this::getNamespaceUri), "feeder" + String.valueOf(i != null ? i : ""));
        String name = switch (((Version)this.getExtensionVersionToExport(context)).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> feeder.getName().orElse(connectableId);
            case 1 -> feeder.getName().orElse(null);
        };
        context.getWriter().writeStringAttribute("name", name);
        context.getWriter().writeOptionalIntAttribute("order", (Integer)feeder.getOrder().orElse(null));
        context.getWriter().writeEnumAttribute("direction", (Enum)feeder.getDirection());
        context.getWriter().writeEndNode();
    }

    public void write(ConnectablePosition<C> connectablePosition, SerializerContext context) {
        NetworkSerializerContext networkContext = ConnectablePositionSerDe.convertContext(context);
        String connectableId = ((Connectable)connectablePosition.getExtendable()).getId();
        if (connectablePosition.getFeeder() != null) {
            this.writePosition(connectableId, connectablePosition.getFeeder(), null, networkContext);
        }
        if (connectablePosition.getFeeder1() != null) {
            this.writePosition(connectableId, connectablePosition.getFeeder1(), 1, networkContext);
        }
        if (connectablePosition.getFeeder2() != null) {
            this.writePosition(connectableId, connectablePosition.getFeeder2(), 2, networkContext);
        }
        if (connectablePosition.getFeeder3() != null) {
            this.writePosition(connectableId, connectablePosition.getFeeder3(), 3, networkContext);
        }
    }

    private void readPosition(DeserializerContext context, ConnectablePositionAdder.FeederAdder<C> adder) {
        String name = context.getReader().readStringAttribute("name");
        context.getReader().readOptionalIntAttribute("order").ifPresent(arg_0 -> adder.withOrder(arg_0));
        ConnectablePosition.Direction direction = (ConnectablePosition.Direction)context.getReader().readEnumAttribute("direction", ConnectablePosition.Direction.class);
        context.getReader().readEndNode();
        if (name != null) {
            adder.withName(name);
        } else if (((Version)this.getExtensionVersionImported(context)).isLessThan(Version.V_1_1)) {
            throw new PowsyblException("Feeder name is mandatory for version < 1.1");
        }
        adder.withDirection(direction).add();
    }

    public ConnectablePosition<C> read(C connectable, DeserializerContext context) {
        ConnectablePositionAdder adder = (ConnectablePositionAdder)connectable.newExtension(ConnectablePositionAdder.class);
        context.getReader().readChildNodes(elementName -> {
            switch (elementName) {
                case "feeder": {
                    this.readPosition(context, adder.newFeeder());
                    break;
                }
                case "feeder1": {
                    this.readPosition(context, adder.newFeeder1());
                    break;
                }
                case "feeder2": {
                    this.readPosition(context, adder.newFeeder2());
                    break;
                }
                case "feeder3": {
                    this.readPosition(context, adder.newFeeder3());
                    break;
                }
                default: {
                    throw new PowsyblException("Unknown element name '" + elementName + "' in 'position'");
                }
            }
        });
        return (ConnectablePosition)adder.add();
    }

    public static enum Version implements SerDeVersion<Version>
    {
        V_1_0("/xsd/connectablePosition_V1_0.xsd", "http://www.itesla_project.eu/schema/iidm/ext/connectable_position/1_0", new SerDeVersion.VersionNumbers(1, 0), IidmVersion.V_1_0, IidmVersion.V_1_14),
        V_1_1("/xsd/connectablePosition_V1_1.xsd", "http://www.powsybl.org/schema/iidm/ext/connectable_position/1_1", new SerDeVersion.VersionNumbers(1, 1), IidmVersion.V_1_0, null);

        private final SerDeVersion.VersionInfo versionInfo;

        private Version(String xsdResourcePath, String namespaceUri, SerDeVersion.VersionNumbers versionNumbers, IidmVersion minIidmVersionIncluded, IidmVersion maxIidmVersionExcluded) {
            this.versionInfo = new SerDeVersion.VersionInfo(xsdResourcePath, namespaceUri, "cp", versionNumbers, minIidmVersionIncluded, maxIidmVersionExcluded, "position");
        }

        @Override
        public SerDeVersion.VersionInfo getVersionInfo() {
            return this.versionInfo;
        }
    }
}

