/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde.extensions;

import com.google.auto.service.AutoService;
import com.powsybl.commons.extensions.ExtensionSerDe;
import com.powsybl.commons.io.DeserializerContext;
import com.powsybl.commons.io.SerializerContext;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.extensions.GeneratorStartup;
import com.powsybl.iidm.network.extensions.GeneratorStartupAdder;
import com.powsybl.iidm.serde.IidmVersion;
import com.powsybl.iidm.serde.extensions.AbstractVersionableNetworkExtensionSerDe;
import com.powsybl.iidm.serde.extensions.SerDeVersion;

@AutoService(value={ExtensionSerDe.class})
public class GeneratorStartupSerDe
extends AbstractVersionableNetworkExtensionSerDe<Generator, GeneratorStartup, Version> {
    public GeneratorStartupSerDe() {
        super("startup", GeneratorStartup.class, (SerDeVersion[])Version.values());
    }

    public void write(GeneratorStartup startup, SerializerContext context) {
        Version extensionVersionToExport = (Version)this.getExtensionVersionToExport(context);
        context.getWriter().writeDoubleAttribute(GeneratorStartupSerDe.getPlannedActivePowerSetpointName(extensionVersionToExport), startup.getPlannedActivePowerSetpoint());
        context.getWriter().writeDoubleAttribute(GeneratorStartupSerDe.getStartupCostName(extensionVersionToExport), startup.getStartupCost());
        context.getWriter().writeDoubleAttribute("marginalCost", startup.getMarginalCost());
        context.getWriter().writeDoubleAttribute("plannedOutageRate", startup.getPlannedOutageRate());
        context.getWriter().writeDoubleAttribute("forcedOutageRate", startup.getForcedOutageRate());
    }

    public GeneratorStartup read(Generator generator, DeserializerContext context) {
        Version extensionVersionImported = (Version)this.getExtensionVersionImported(context);
        double plannedActivePowerSetpoint = context.getReader().readDoubleAttribute(GeneratorStartupSerDe.getPlannedActivePowerSetpointName(extensionVersionImported));
        double startUpCost = context.getReader().readDoubleAttribute(GeneratorStartupSerDe.getStartupCostName(extensionVersionImported));
        double marginalCost = context.getReader().readDoubleAttribute("marginalCost");
        double plannedOutageRate = context.getReader().readDoubleAttribute("plannedOutageRate");
        double forcedOutageRate = context.getReader().readDoubleAttribute("forcedOutageRate");
        context.getReader().readEndNode();
        return (GeneratorStartup)((GeneratorStartupAdder)generator.newExtension(GeneratorStartupAdder.class)).withPlannedActivePowerSetpoint(plannedActivePowerSetpoint).withStartupCost(startUpCost).withMarginalCost(marginalCost).withPlannedOutageRate(plannedOutageRate).withForcedOutageRate(forcedOutageRate).add();
    }

    private static String getStartupCostName(Version extensionVersionToExport) {
        return switch (extensionVersionToExport.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> "startUpCost";
            case 2 -> "startupCost";
        };
    }

    private static String getPlannedActivePowerSetpointName(Version extensionVersionToExport) {
        return switch (extensionVersionToExport.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> "predefinedActivePowerSetpoint";
            case 2 -> "plannedActivePowerSetpoint";
        };
    }

    public static enum Version implements SerDeVersion<Version>
    {
        ITESLA_1_0("/xsd/generatorStartup_itesla_V1_0.xsd", "http://www.itesla_project.eu/schema/iidm/ext/generator_startup/1_0", new SerDeVersion.VersionNumbers(1, 0, "itesla"), IidmVersion.V_1_0, null),
        V_1_0("/xsd/generatorStartup_V1_0.xsd", "http://www.powsybl.org/schema/iidm/ext/generator_startup/1_0", new SerDeVersion.VersionNumbers(1, 0), IidmVersion.V_1_0, null),
        V_1_1("/xsd/generatorStartup_V1_1.xsd", "http://www.powsybl.org/schema/iidm/ext/generator_startup/1_1", new SerDeVersion.VersionNumbers(1, 1), IidmVersion.V_1_0, null);

        private final SerDeVersion.VersionInfo versionInfo;

        private Version(String xsdResourcePath, String namespaceUri, SerDeVersion.VersionNumbers versionNumbers, IidmVersion minIidmVersionIncluded, IidmVersion maxIidmVersionExcluded) {
            this.versionInfo = new SerDeVersion.VersionInfo(xsdResourcePath, namespaceUri, "gs", versionNumbers, minIidmVersionIncluded, maxIidmVersionExcluded, "startup");
        }

        @Override
        public SerDeVersion.VersionInfo getVersionInfo() {
            return this.versionInfo;
        }
    }
}

