/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.serde.extensions;

import com.powsybl.iidm.serde.IidmVersion;

public interface SerDeVersion<V extends SerDeVersion<V>> {
    public VersionInfo getVersionInfo();

    default public boolean supports(IidmVersion networkVersion) {
        return this.getMinIidmVersionIncluded().compareTo(networkVersion) <= 0 && (this.getMaxIidmVersionExcluded() == null || this.getMaxIidmVersionExcluded().compareTo(networkVersion) > 0);
    }

    default public VersionNumbers getVersionNumbers() {
        return this.getVersionInfo().versionNumbers();
    }

    default public String getNamespaceUri() {
        return this.getVersionInfo().namespaceUri();
    }

    default public IidmVersion getMinIidmVersionIncluded() {
        return this.getVersionInfo().minIncluded();
    }

    default public IidmVersion getMaxIidmVersionExcluded() {
        return this.getVersionInfo().maxExcluded();
    }

    default public String getVersionString() {
        return this.getVersionNumbers().toString();
    }

    default public String getNamespacePrefix() {
        return this.getVersionInfo().namespacePrefix();
    }

    default public String getSerializationName() {
        return this.getVersionInfo().serializationName();
    }

    default public boolean isGreaterThan(V version) {
        return this.getVersionNumbers().compareTo(version.getVersionNumbers()) > 0;
    }

    default public boolean isLessThan(V version) {
        return this.getVersionNumbers().compareTo(version.getVersionNumbers()) < 0;
    }

    default public String getXsdResourcePath() {
        return this.getVersionInfo().xsdResourcePath();
    }

    public record VersionInfo(String xsdResourcePath, String namespaceUri, String namespacePrefix, VersionNumbers versionNumbers, IidmVersion minIncluded, IidmVersion maxExcluded, String serializationName) {
    }

    public record VersionNumbers(int major, int minor, String suffix) implements Comparable<VersionNumbers>
    {
        public VersionNumbers(int major, int minor) {
            this(major, minor, null);
        }

        @Override
        public String toString() {
            return this.major + "." + this.minor + (String)(this.suffix == null ? "" : "-" + this.suffix);
        }

        @Override
        public int compareTo(VersionNumbers other) {
            if (this.major != other.major) {
                return this.major - other.major;
            }
            if (this.minor != other.minor) {
                return this.minor - other.minor;
            }
            if (this.suffix == null && other.suffix == null) {
                return 0;
            }
            if (this.suffix == null || other.suffix == null) {
                return this.suffix != null ? -1 : 1;
            }
            return this.suffix.compareTo(other.suffix);
        }
    }
}

