/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.test;

import com.powsybl.iidm.network.ActivePowerLimitsAdder;
import com.powsybl.iidm.network.BusbarSectionAdder;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.LoadType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoWindingsTransformerAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import java.time.ZonedDateTime;
import java.util.Objects;

public final class SecurityAnalysisTestNetworkFactory {
    private static final String S1VL1 = "S1VL1";
    private static final String S1VL2 = "S1VL2";
    private static final String S2VL1 = "S2VL1";
    private static final String S2VL2 = "S2VL2";
    private static final String LINE_S1S2V1_1 = "LINE_S1S2V1_1";
    private static final String LINE_S1S2V1_2 = "LINE_S1S2V1_2";
    private static final String LINE_S1S2V2 = "LINE_S1S2V2";
    private static final String TWT = "TWT";
    private static final String TWT2 = "TWT2";

    private SecurityAnalysisTestNetworkFactory() {
    }

    public static Network create() {
        return SecurityAnalysisTestNetworkFactory.create(NetworkFactory.findDefault());
    }

    public static Network create(NetworkFactory networkFactory) {
        Objects.requireNonNull(networkFactory);
        Network network = networkFactory.createNetwork("fictitious", "test");
        network.setCaseDate(ZonedDateTime.parse("2022-12-18T16:00:00.000+01:00"));
        network.setForecastDistance(0);
        Substation s1 = ((SubstationAdder)network.newSubstation().setId("S1")).add();
        VoltageLevel s1vl1 = ((VoltageLevelAdder)s1.newVoltageLevel().setId(S1VL1)).setNominalV(400.0).setTopologyKind(TopologyKind.NODE_BREAKER).add();
        ((BusbarSectionAdder)((BusbarSectionAdder)s1vl1.getNodeBreakerView().newBusbarSection().setId("S1VL1_BBS")).setName("S1VL1_BBS")).setNode(0).add();
        VoltageLevel s1vl2 = ((VoltageLevelAdder)s1.newVoltageLevel().setId(S1VL2)).setNominalV(225.0).setTopologyKind(TopologyKind.NODE_BREAKER).add();
        ((BusbarSectionAdder)((BusbarSectionAdder)s1vl2.getNodeBreakerView().newBusbarSection().setId("S1VL2_BBS1")).setName("S1VL2_BBS1")).setNode(0).add();
        Substation s2 = ((SubstationAdder)network.newSubstation().setId("S2")).add();
        VoltageLevel s2vl1 = ((VoltageLevelAdder)s2.newVoltageLevel().setId(S2VL1)).setNominalV(400.0).setTopologyKind(TopologyKind.NODE_BREAKER).add();
        ((BusbarSectionAdder)((BusbarSectionAdder)s2vl1.getNodeBreakerView().newBusbarSection().setId("S2VL1_BBS1")).setName("S2VL1_BBS1")).setNode(0).add();
        VoltageLevel s2vl2 = ((VoltageLevelAdder)s2.newVoltageLevel().setId(S2VL2)).setNominalV(225.0).setTopologyKind(TopologyKind.NODE_BREAKER).add();
        ((BusbarSectionAdder)((BusbarSectionAdder)s2vl2.getNodeBreakerView().newBusbarSection().setId("S2VL2_BBS1")).setName("S2VL2_BBS1")).setNode(0).add();
        SecurityAnalysisTestNetworkFactory.createSwitch(s1vl1, "S1VL1_BBS1_GEN_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 1);
        SecurityAnalysisTestNetworkFactory.createSwitch(s1vl1, "S1VL1_BBS1_GEN_BREAKER", SwitchKind.BREAKER, false, 1, 2);
        ((GeneratorAdder)((GeneratorAdder)s1vl1.newGenerator().setId("GEN")).setEnergySource(EnergySource.OTHER).setMinP(0.0).setMaxP(150.0).setVoltageRegulatorOn(true).setTargetV(400.0).setTargetP(100.0).setNode(2)).add();
        SecurityAnalysisTestNetworkFactory.createSwitch(s1vl2, "S1VL2_BBS1_LD1_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 3);
        SecurityAnalysisTestNetworkFactory.createSwitch(s1vl2, "S1VL2_BBS1_LD1_BREAKER", SwitchKind.BREAKER, false, 3, 4);
        SecurityAnalysisTestNetworkFactory.createSwitch(s2vl2, "S2VL2_BBS1_LD2_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 3);
        SecurityAnalysisTestNetworkFactory.createSwitch(s2vl2, "S2VL2_BBS1_LD2_BREAKER", SwitchKind.BREAKER, false, 3, 4);
        ((LoadAdder)((LoadAdder)s1vl2.newLoad().setId("LD1")).setLoadType(LoadType.UNDEFINED).setP0(50.0).setQ0(4.0).setNode(4)).add();
        ((LoadAdder)((LoadAdder)s2vl2.newLoad().setId("LD2")).setLoadType(LoadType.UNDEFINED).setP0(50.0).setQ0(4.0).setNode(4)).add();
        SecurityAnalysisTestNetworkFactory.createSwitch(s1vl1, "S1VL2_BBS_LINES1S2V1_1_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 16);
        SecurityAnalysisTestNetworkFactory.createSwitch(s1vl1, "S1VL2_LINES1S2V1_1_BREAKER", SwitchKind.BREAKER, false, 16, 17);
        SecurityAnalysisTestNetworkFactory.createSwitch(s2vl1, "S2VL2_BBS_LINES1S2V1_1_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 16);
        SecurityAnalysisTestNetworkFactory.createSwitch(s2vl1, "S2VL2_LINES1S2V1_1_BREAKER", SwitchKind.BREAKER, false, 16, 17);
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId(LINE_S1S2V1_1)).setR(0.01).setX(50.0).setG1(0.0).setB1(0.0).setG2(0.0).setB2(0.0).setNode1(17)).setVoltageLevel1(S1VL1)).setNode2(17)).setVoltageLevel2(S2VL1)).add();
        SecurityAnalysisTestNetworkFactory.createSwitch(s1vl1, "S1VL2_BBS_LINES1S2V1_2_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 14);
        SecurityAnalysisTestNetworkFactory.createSwitch(s1vl1, "S1VL2_LINES1S2V1_2_BREAKER", SwitchKind.BREAKER, false, 14, 15);
        SecurityAnalysisTestNetworkFactory.createSwitch(s2vl1, "S2VL2_BBS_LINES1S2V1_2_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 14);
        SecurityAnalysisTestNetworkFactory.createSwitch(s2vl1, "S2VL2_LINES1S2V1_2_BREAKER", SwitchKind.BREAKER, false, 14, 15);
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId(LINE_S1S2V1_2)).setR(0.01).setX(50.0).setG1(0.0).setB1(0.0).setG2(0.0).setB2(0.0).setNode1(15)).setVoltageLevel1(S1VL1)).setNode2(15)).setVoltageLevel2(S2VL1)).add();
        SecurityAnalysisTestNetworkFactory.createSwitch(s1vl2, "S1VL2_BBS_LINES1S2_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 12);
        SecurityAnalysisTestNetworkFactory.createSwitch(s1vl2, "S1VL2_LINES1S2_BREAKER", SwitchKind.BREAKER, false, 12, 13);
        SecurityAnalysisTestNetworkFactory.createSwitch(s2vl2, "S2VL2_BBS_LINES1S2_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 12);
        SecurityAnalysisTestNetworkFactory.createSwitch(s2vl2, "S2VL2_LINES1S2_BREAKER", SwitchKind.BREAKER, false, 12, 13);
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId(LINE_S1S2V2)).setR(0.01).setX(50.0).setG1(0.0).setB1(0.0).setG2(0.0).setB2(0.0).setNode1(13)).setVoltageLevel1(S1VL2)).setNode2(13)).setVoltageLevel2(S2VL2)).add();
        SecurityAnalysisTestNetworkFactory.createSwitch(s1vl1, "S1VL1_BBS_TWT_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 10);
        SecurityAnalysisTestNetworkFactory.createSwitch(s1vl1, "S1VL1_TWT_BREAKER", SwitchKind.BREAKER, false, 10, 11);
        SecurityAnalysisTestNetworkFactory.createSwitch(s1vl2, "S1VL2_BBS_TWT_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 10);
        SecurityAnalysisTestNetworkFactory.createSwitch(s1vl2, "S1VL2_TWT_BREAKER", SwitchKind.BREAKER, false, 10, 11);
        ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s1.newTwoWindingsTransformer().setId(TWT)).setR(2.0).setX(25.0).setG(0.0).setB(3.2E-5).setRatedU1(400.0).setRatedU2(225.0).setNode1(11)).setVoltageLevel1(S1VL1)).setNode2(11)).setVoltageLevel2(S1VL2)).add();
        SecurityAnalysisTestNetworkFactory.createSwitch(s2vl1, "S2VL1_BBS_TWT_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 10);
        SecurityAnalysisTestNetworkFactory.createSwitch(s2vl1, "S2VL1_TWT_BREAKER", SwitchKind.BREAKER, false, 10, 11);
        SecurityAnalysisTestNetworkFactory.createSwitch(s2vl2, "S2VL2_BBS_TWT_DISCONNECTOR", SwitchKind.DISCONNECTOR, false, 0, 10);
        SecurityAnalysisTestNetworkFactory.createSwitch(s2vl2, "S2VL2_TWT_BREAKER", SwitchKind.BREAKER, false, 10, 11);
        ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s2.newTwoWindingsTransformer().setId(TWT2)).setR(2.0).setX(50.0).setG(0.0).setB(3.2E-5).setRatedU1(400.0).setRatedU2(225.0).setNode1(11)).setVoltageLevel1(S2VL1)).setNode2(11)).setVoltageLevel2(S2VL2)).add();
        return network;
    }

    private static void createSwitch(VoltageLevel vl, String id, SwitchKind kind, boolean open, int node1, int node2) {
        ((VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)((VoltageLevel.NodeBreakerView.SwitchAdder)vl.getNodeBreakerView().newSwitch().setId(id)).setName(id)).setKind(kind).setRetained(kind.equals((Object)SwitchKind.BREAKER)).setOpen(open).setFictitious(false)).setNode1(node1).setNode2(node2).add();
    }

    public static Network createWithFixedCurrentLimits() {
        return SecurityAnalysisTestNetworkFactory.createWithFixedCurrentLimits(NetworkFactory.findDefault());
    }

    public static Network createWithFixedCurrentLimits(NetworkFactory networkFactory) {
        Network network = SecurityAnalysisTestNetworkFactory.create(networkFactory);
        ((CurrentLimitsAdder)network.getLine(LINE_S1S2V1_1).newCurrentLimits2().setPermanentLimit(75.0)).add();
        ((CurrentLimitsAdder)((CurrentLimitsAdder)((CurrentLimitsAdder)((CurrentLimitsAdder)network.getLine(LINE_S1S2V1_1).newCurrentLimits1().setPermanentLimit(75.0)).beginTemporaryLimit().setName("10'").setAcceptableDuration(600).setValue(80.0).endTemporaryLimit()).beginTemporaryLimit().setName("1'").setAcceptableDuration(60).setValue(85.0).endTemporaryLimit()).beginTemporaryLimit().setName("Undefined").setAcceptableDuration(0).setValue(Double.MAX_VALUE).endTemporaryLimit()).add();
        ((CurrentLimitsAdder)network.getLine(LINE_S1S2V1_2).newCurrentLimits2().setPermanentLimit(75.0)).add();
        ((CurrentLimitsAdder)((CurrentLimitsAdder)((CurrentLimitsAdder)((CurrentLimitsAdder)network.getLine(LINE_S1S2V1_2).newCurrentLimits1().setPermanentLimit(75.0)).beginTemporaryLimit().setName("10'").setAcceptableDuration(600).setValue(80.0).endTemporaryLimit()).beginTemporaryLimit().setName("1'").setAcceptableDuration(60).setValue(85.0).endTemporaryLimit()).beginTemporaryLimit().setName("Undefined").setAcceptableDuration(0).setValue(Double.MAX_VALUE).endTemporaryLimit()).add();
        ((CurrentLimitsAdder)((CurrentLimitsAdder)network.getLine(LINE_S1S2V2).newCurrentLimits1().setPermanentLimit(60.0)).beginTemporaryLimit().setName("10'").setAcceptableDuration(600).setValue(80.0).endTemporaryLimit()).add();
        ((CurrentLimitsAdder)((CurrentLimitsAdder)((CurrentLimitsAdder)network.getTwoWindingsTransformer(TWT2).newCurrentLimits1().setPermanentLimit(90.0)).beginTemporaryLimit().setName("10'").setAcceptableDuration(600).setValue(100.0).endTemporaryLimit()).beginTemporaryLimit().setName("1'").setAcceptableDuration(60).setValue(110.0).endTemporaryLimit()).add();
        ((CurrentLimitsAdder)((CurrentLimitsAdder)((CurrentLimitsAdder)network.getTwoWindingsTransformer(TWT).newCurrentLimits1().setPermanentLimit(92.0)).beginTemporaryLimit().setName("10'").setAcceptableDuration(600).setValue(100.0).endTemporaryLimit()).beginTemporaryLimit().setName("1'").setAcceptableDuration(60).setValue(110.0).endTemporaryLimit()).add();
        return network;
    }

    public static Network createWithFixedPowerLimits() {
        return SecurityAnalysisTestNetworkFactory.createWithFixedPowerLimits(NetworkFactory.findDefault());
    }

    public static Network createWithFixedPowerLimits(NetworkFactory networkFactory) {
        Network network = SecurityAnalysisTestNetworkFactory.create(networkFactory);
        ((ActivePowerLimitsAdder)network.getTwoWindingsTransformer(TWT).newActivePowerLimits1().setPermanentLimit(71.0)).add();
        ((ActivePowerLimitsAdder)network.getTwoWindingsTransformer(TWT2).newActivePowerLimits1().setPermanentLimit(55.0)).add();
        ((ActivePowerLimitsAdder)network.getLine(LINE_S1S2V1_1).newActivePowerLimits1().setPermanentLimit(55.0)).add();
        ((ActivePowerLimitsAdder)network.getLine(LINE_S1S2V1_2).newActivePowerLimits1().setPermanentLimit(55.0)).add();
        ((ActivePowerLimitsAdder)network.getLine(LINE_S1S2V2).newActivePowerLimits1().setPermanentLimit(30.0)).add();
        return network;
    }
}

