/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.test;

import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.BusbarSectionAdder;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.GroundAdder;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoWindingsTransformerAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.extensions.BusbarSectionPositionAdder;
import java.time.ZonedDateTime;

public final class TwoVoltageLevelNetworkFactory {
    private TwoVoltageLevelNetworkFactory() {
    }

    public static Network create() {
        return TwoVoltageLevelNetworkFactory.create(NetworkFactory.findDefault());
    }

    public static Network create(NetworkFactory networkFactory) {
        Network network = networkFactory.createNetwork("test", "test");
        network.setCaseDate(ZonedDateTime.parse("2023-12-18T14:49:00.000+01:00"));
        Substation substation = ((SubstationAdder)network.newSubstation().setId("S")).setCountry(Country.FR).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)substation.newVoltageLevel().setId("VL1")).setNominalV(400.0).setTopologyKind(TopologyKind.NODE_BREAKER).add();
        VoltageLevel vl2 = ((VoltageLevelAdder)substation.newVoltageLevel().setId("VL2")).setNominalV(220.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        BusbarSection bbs1 = ((BusbarSectionAdder)vl1.getNodeBreakerView().newBusbarSection().setId("BBS1")).setNode(0).add();
        ((BusbarSectionPositionAdder)bbs1.newExtension(BusbarSectionPositionAdder.class)).withBusbarIndex(1).withSectionIndex(1).add();
        BusbarSection bbs2 = ((BusbarSectionAdder)vl1.getNodeBreakerView().newBusbarSection().setId("BBS2")).setNode(1).add();
        ((BusbarSectionPositionAdder)bbs2.newExtension(BusbarSectionPositionAdder.class)).withBusbarIndex(2).withSectionIndex(1).add();
        ((BusAdder)vl2.getBusBreakerView().newBus().setId("BUS1")).add();
        ((BusAdder)vl2.getBusBreakerView().newBus().setId("BUS2")).add();
        ((LoadAdder)((LoadAdder)vl1.newLoad().setId("L")).setNode(2)).setP0(1.0).setQ0(1.0).add();
        ((GeneratorAdder)((GeneratorAdder)vl2.newGenerator().setId("CB")).setEnergySource(EnergySource.HYDRO).setMinP(0.0).setMaxP(70.0).setVoltageRegulatorOn(false).setTargetP(0.0).setTargetV(0.0).setTargetQ(0.0).setBus("BUS1")).add();
        ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)substation.newTwoWindingsTransformer().setId("TWT")).setR(2.0).setX(14.745).setG(0.0).setB(3.2E-5).setRatedU1(225.0).setRatedU2(225.0).setNode1(3)).setVoltageLevel1("VL1")).setBus2("BUS1")).setVoltageLevel2("VL2")).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)vl1.getNodeBreakerView().newDisconnector().setId("D_0_3")).setKind(SwitchKind.DISCONNECTOR).setOpen(false).setNode1(0).setNode2(4).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)vl1.getNodeBreakerView().newDisconnector().setId("D_1_3")).setKind(SwitchKind.DISCONNECTOR).setOpen(false).setNode1(1).setNode2(4).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)vl1.getNodeBreakerView().newDisconnector().setId("D_0_5")).setKind(SwitchKind.DISCONNECTOR).setOpen(false).setNode1(0).setNode2(5).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)vl1.getNodeBreakerView().newDisconnector().setId("D_1_5")).setKind(SwitchKind.DISCONNECTOR).setOpen(false).setNode1(1).setNode2(5).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)vl1.getNodeBreakerView().newBreaker().setId("BR_LOAD")).setNode1(2).setNode2(4).setOpen(false).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)vl1.getNodeBreakerView().newBreaker().setId("BR_VL1")).setNode1(3).setNode2(5).setOpen(true).add();
        ((VoltageLevel.BusBreakerView.SwitchAdder)vl2.getBusBreakerView().newSwitch().setId("BR_VL2")).setBus1("BUS1").setBus2("BUS2").setOpen(false).add();
        return network;
    }

    public static Network createWithGrounds() {
        return TwoVoltageLevelNetworkFactory.createWithGrounds(NetworkFactory.findDefault());
    }

    public static Network createWithGrounds(NetworkFactory networkFactory) {
        Network network = TwoVoltageLevelNetworkFactory.create(networkFactory);
        VoltageLevel vl1 = network.getVoltageLevel("VL1");
        VoltageLevel vl2 = network.getVoltageLevel("VL2");
        ((VoltageLevel.NodeBreakerView.SwitchAdder)vl1.getNodeBreakerView().newDisconnector().setId("D_1_6")).setKind(SwitchKind.DISCONNECTOR).setOpen(false).setNode1(1).setNode2(6).add();
        ((GroundAdder)((GroundAdder)((GroundAdder)((GroundAdder)vl1.newGround().setId("GroundNB")).setName("GroundNB1")).setNode(6)).setEnsureIdUnicity(true)).add();
        ((GroundAdder)((GroundAdder)((GroundAdder)((GroundAdder)vl2.newGround().setId("GroundBB")).setName("GroundBB1")).setBus("BUS2")).setEnsureIdUnicity(true)).add();
        return network;
    }
}

