/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.test;

import com.powsybl.iidm.network.BusbarSection;
import com.powsybl.iidm.network.BusbarSectionAdder;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import java.util.Objects;

public final class NetworkTest1Factory {
    private NetworkTest1Factory() {
    }

    public static Network create() {
        return NetworkTest1Factory.create(NetworkFactory.findDefault(), null);
    }

    public static Network create(String networkId) {
        return NetworkTest1Factory.create(NetworkFactory.findDefault(), networkId);
    }

    public static Network create(NetworkFactory networkFactory, String nid) {
        Objects.requireNonNull(networkFactory);
        Network network = networkFactory.createNetwork(NetworkTest1Factory.id("network", nid), "test");
        Substation substation1 = ((SubstationAdder)network.newSubstation().setId(NetworkTest1Factory.id("substation1", nid))).setCountry(Country.FR).setTso(NetworkTest1Factory.id("TSO1", nid)).setGeographicalTags(new String[]{NetworkTest1Factory.id("region1", nid)}).add();
        VoltageLevel voltageLevel1 = ((VoltageLevelAdder)substation1.newVoltageLevel().setId(NetworkTest1Factory.id("voltageLevel1", nid))).setNominalV(400.0).setTopologyKind(TopologyKind.NODE_BREAKER).add();
        VoltageLevel.NodeBreakerView topology1 = voltageLevel1.getNodeBreakerView();
        BusbarSection voltageLevel1BusbarSection1 = ((BusbarSectionAdder)topology1.newBusbarSection().setId(NetworkTest1Factory.id("voltageLevel1BusbarSection1", nid))).setNode(0).add();
        BusbarSection voltageLevel1BusbarSection2 = ((BusbarSectionAdder)topology1.newBusbarSection().setId(NetworkTest1Factory.id("voltageLevel1BusbarSection2", nid))).setNode(1).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)topology1.newBreaker().setId(NetworkTest1Factory.id("voltageLevel1Breaker1", nid))).setRetained(true).setOpen(false).setNode1(voltageLevel1BusbarSection1.getTerminal().getNodeBreakerView().getNode()).setNode2(voltageLevel1BusbarSection2.getTerminal().getNodeBreakerView().getNode()).add();
        Load load1 = ((LoadAdder)((LoadAdder)voltageLevel1.newLoad().setId(NetworkTest1Factory.id("load1", nid))).setNode(2)).setP0(10.0).setQ0(3.0).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)topology1.newDisconnector().setId(NetworkTest1Factory.id("load1Disconnector1", nid))).setOpen(false).setNode1(load1.getTerminal().getNodeBreakerView().getNode()).setNode2(3).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)topology1.newDisconnector().setId(NetworkTest1Factory.id("load1Breaker1", nid))).setOpen(false).setNode1(3).setNode2(voltageLevel1BusbarSection1.getTerminal().getNodeBreakerView().getNode()).add();
        Generator generator1 = ((GeneratorAdder)((GeneratorAdder)voltageLevel1.newGenerator().setId(NetworkTest1Factory.id("generator1", nid))).setEnergySource(EnergySource.NUCLEAR).setMinP(200.0).setMaxP(900.0).setVoltageRegulatorOn(true).setTargetP(900.0).setTargetV(380.0).setNode(5)).add();
        generator1.newReactiveCapabilityCurve().beginPoint().setP(200.0).setMinQ(300.0).setMaxQ(500.0).endPoint().beginPoint().setP(900.0).setMinQ(300.0).setMaxQ(500.0).endPoint().add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)topology1.newDisconnector().setId(NetworkTest1Factory.id("generator1Disconnector1", nid))).setOpen(false).setNode1(generator1.getTerminal().getNodeBreakerView().getNode()).setNode2(6).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)topology1.newDisconnector().setId(NetworkTest1Factory.id("generator1Breaker1", nid))).setOpen(false).setNode1(6).setNode2(voltageLevel1BusbarSection2.getTerminal().getNodeBreakerView().getNode()).add();
        return network;
    }

    public static String id(String localId, String networkId) {
        return networkId != null ? "n" + networkId + "_" + localId : localId;
    }
}

