/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.test;

import com.powsybl.iidm.network.BatteryAdder;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineAdder;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.HvdcLine;
import com.powsybl.iidm.network.HvdcLineAdder;
import com.powsybl.iidm.network.LccConverterStation;
import com.powsybl.iidm.network.LccConverterStationAdder;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.PhaseTapChangerAdder;
import com.powsybl.iidm.network.RatioTapChangerAdder;
import com.powsybl.iidm.network.ShuntCompensatorAdder;
import com.powsybl.iidm.network.StaticVarCompensatorAdder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.SwitchKind;
import com.powsybl.iidm.network.ThreeWindingsTransformer;
import com.powsybl.iidm.network.ThreeWindingsTransformerAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformerAdder;
import com.powsybl.iidm.network.ValidationLevel;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.VscConverterStation;
import com.powsybl.iidm.network.VscConverterStationAdder;
import java.time.ZonedDateTime;
import java.util.Objects;

public final class ScadaNetworkFactory {
    public static Network create() {
        return ScadaNetworkFactory.create(NetworkFactory.findDefault());
    }

    public static Network create(NetworkFactory networkFactory) {
        Objects.requireNonNull(networkFactory);
        Network network = Network.create((String)"scada", (String)"test");
        network.setCaseDate(ZonedDateTime.parse("2017-06-25T17:43:00.000+01:00"));
        network.setMinimumAcceptableValidationLevel(ValidationLevel.EQUIPMENT);
        Substation sub = ((SubstationAdder)network.newSubstation().setId("sub")).add();
        VoltageLevel vl = ((VoltageLevelAdder)sub.newVoltageLevel().setNominalV(440.0).setId("vl")).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        String busId = "bus";
        ((BusAdder)vl.getBusBreakerView().newBus().setId(busId)).add();
        ((BatteryAdder)((BatteryAdder)vl.newBattery().setId("battery")).setMinP(0.0).setMaxP(100.0).setBus(busId)).add();
        DanglingLine dl = ((DanglingLineAdder)((DanglingLineAdder)vl.newDanglingLine().setId("dl")).setBus(busId)).setR(1.0).setX(1.0).setG(0.0).setB(0.0).newGeneration().setMinP(100.0).setMaxP(200.0).add().add();
        dl.getGeneration().newMinMaxReactiveLimits().setMinQ(100.0).setMaxQ(200.0).add();
        Generator generator = ((GeneratorAdder)((GeneratorAdder)vl.newGenerator().setVoltageRegulatorOn(true).setId("generator")).setBus(busId)).setMinP(0.0).setMaxP(100.0).add();
        generator.newReactiveCapabilityCurve().beginPoint().setP(0.0).setMinQ(0.0).setMaxQ(0.0).endPoint().beginPoint().setP(10.0).setMinQ(5.0).setMaxQ(15.0).endPoint().add();
        LccConverterStation lcs = ((LccConverterStationAdder)((LccConverterStationAdder)((LccConverterStationAdder)vl.newLccConverterStation().setId("lcs")).setLossFactor(80.0f)).setPowerFactor(0.2f).setBus(busId)).add();
        VoltageLevel vl2 = ((VoltageLevelAdder)sub.newVoltageLevel().setId("vl2")).setNominalV(220.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        String bus2Id = "bus2";
        ((BusAdder)vl2.getBusBreakerView().newBus().setId(bus2Id)).add();
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("line")).setR(1.0).setX(1.0).setG1(0.0).setB1(0.0).setG2(0.0).setB2(0.0).setBus1(busId)).setBus2(bus2Id)).setVoltageLevel1(vl.getId())).setVoltageLevel2(vl2.getId())).add();
        ((LoadAdder)((LoadAdder)vl2.newLoad().setId("load")).setBus(bus2Id)).add();
        ((ShuntCompensatorAdder)((ShuntCompensatorAdder)vl2.newShuntCompensator().setId("shunt")).setBus(bus2Id)).setVoltageRegulatorOn(true).newLinearModel().setBPerSection(10.0).setMaximumSectionCount(1).add().add();
        ((StaticVarCompensatorAdder)((StaticVarCompensatorAdder)vl2.newStaticVarCompensator().setId("svc")).setBmin(1.1).setBmax(3.2).setBus(bus2Id)).add();
        VoltageLevel vl3 = ((VoltageLevelAdder)sub.newVoltageLevel().setId("vl3")).setNominalV(420.0).setTopologyKind(TopologyKind.NODE_BREAKER).add();
        ((VoltageLevel.NodeBreakerView.SwitchAdder)vl3.getNodeBreakerView().newSwitch().setId("switch")).setNode1(0).setNode2(1).setKind(SwitchKind.BREAKER).add();
        ThreeWindingsTransformer t3wt = ((ThreeWindingsTransformerAdder)sub.newThreeWindingsTransformer().setId("t3wt")).newLeg1().setRatedU(400.0).setR(1.0).setX(1.0).setG(0.0).setB(0.0).setBus(busId).setVoltageLevel(vl.getId()).add().newLeg2().setRatedU(220.0).setR(1.0).setX(1.0).setG(0.0).setB(0.0).setBus(bus2Id).setVoltageLevel(vl2.getId()).add().newLeg3().setRatedU(190.0).setR(1.0).setX(1.0).setG(0.0).setB(0.0).setNode(0).setVoltageLevel(vl3.getId()).add().add();
        ((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)t3wt.getLeg1().newRatioTapChanger().setRegulating(true)).beginStep()).setRho(1.0)).setR(1.0)).setX(1.0)).setG(0.0)).setB(0.0)).endStep()).add();
        ((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)t3wt.getLeg2().newPhaseTapChanger().setRegulationMode(null).beginStep()).setAlpha(1.0)).setRho(1.0)).setR(1.0)).setX(1.0)).setG(0.0)).setB(0.0)).endStep()).add();
        TwoWindingsTransformer t2wt = ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)sub.newTwoWindingsTransformer().setId("tw2t")).setR(1.0).setX(1.0).setG(0.0).setB(0.0).setRatedU1(440.0).setRatedU2(220.0).setBus1(busId)).setVoltageLevel1(vl.getId())).setBus2(bus2Id)).setVoltageLevel2(vl2.getId())).add();
        ((RatioTapChangerAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder.StepAdder)((RatioTapChangerAdder)t2wt.newRatioTapChanger().setRegulating(true)).beginStep()).setRho(1.0)).setR(1.0)).setX(1.0)).setG(0.0)).setB(0.0)).endStep()).add();
        ((PhaseTapChangerAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)((PhaseTapChangerAdder.StepAdder)t2wt.newPhaseTapChanger().setRegulationMode(null).beginStep()).setAlpha(1.0)).setRho(1.0)).setR(1.0)).setX(1.0)).setG(0.0)).setB(0.0)).endStep()).add();
        VscConverterStation vcs = ((VscConverterStationAdder)((VscConverterStationAdder)((VscConverterStationAdder)vl2.newVscConverterStation().setId("vcs")).setBus(bus2Id)).setLossFactor(80.0f)).setVoltageRegulatorOn(true).add();
        ((HvdcLineAdder)network.newHvdcLine().setNominalV(400.0).setR(1.0).setMaxP(20.0).setConverterStationId1(lcs.getId()).setConverterStationId2(vcs.getId()).setConvertersMode(HvdcLine.ConvertersMode.SIDE_1_INVERTER_SIDE_2_RECTIFIER).setId("hvdcline")).add();
        return network;
    }

    private ScadaNetworkFactory() {
    }
}

