/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.test;

import com.powsybl.commons.extensions.Extension;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.test.LoadBarExt;
import com.powsybl.iidm.network.test.LoadFooExt;
import java.time.ZonedDateTime;
import java.util.Objects;

public final class MultipleExtensionsTestNetworkFactory {
    private MultipleExtensionsTestNetworkFactory() {
    }

    public static Network create() {
        return MultipleExtensionsTestNetworkFactory.create(NetworkFactory.findDefault());
    }

    public static Network create(NetworkFactory networkFactory) {
        Objects.requireNonNull(networkFactory);
        Network network = networkFactory.createNetwork("test", "test");
        network.setCaseDate(ZonedDateTime.parse("2017-11-17T12:00:00+01:00"));
        Substation s = ((SubstationAdder)network.newSubstation().setId("S")).setCountry(Country.FR).add();
        VoltageLevel vl = ((VoltageLevelAdder)s.newVoltageLevel().setId("VL")).setTopologyKind(TopologyKind.BUS_BREAKER).setNominalV(20.0).setLowVoltageLimit(15.0).setHighVoltageLimit(25.0).add();
        ((BusAdder)vl.getBusBreakerView().newBus().setId("BUS")).add();
        Load load = ((LoadAdder)((LoadAdder)((LoadAdder)vl.newLoad().setId("LOAD")).setP0(0.0).setQ0(0.0).setBus("BUS")).setConnectableBus("BUS")).add();
        Load load2 = ((LoadAdder)((LoadAdder)((LoadAdder)vl.newLoad().setId("LOAD2")).setP0(0.0).setQ0(0.0).setBus("BUS")).setConnectableBus("BUS")).add();
        load.addExtension(LoadFooExt.class, (Extension)new LoadFooExt(load));
        load.addExtension(LoadBarExt.class, (Extension)new LoadBarExt(load));
        load2.addExtension(LoadFooExt.class, (Extension)new LoadFooExt(load2));
        return network;
    }
}

