/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.test;

import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.ShuntCompensator;
import com.powsybl.iidm.network.ShuntCompensatorAdder;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import java.time.ZonedDateTime;
import java.util.Objects;

public final class ShuntTestCaseFactory {
    private static final String SHUNT = "SHUNT";

    private ShuntTestCaseFactory() {
    }

    public static Network create() {
        return ShuntTestCaseFactory.create(NetworkFactory.findDefault());
    }

    public static Network create(double bPerSection) {
        return ShuntTestCaseFactory.create(NetworkFactory.findDefault(), bPerSection);
    }

    public static Network create(NetworkFactory networkFactory) {
        return ShuntTestCaseFactory.create(networkFactory, 1.0E-5);
    }

    public static Network create(NetworkFactory networkFactory, double bPerSection) {
        Network network = ShuntTestCaseFactory.createBase(networkFactory);
        ((ShuntCompensatorAdder)((ShuntCompensatorAdder)((ShuntCompensatorAdder)network.getVoltageLevel("VL1").newShuntCompensator().setId(SHUNT)).setBus("B1")).setConnectableBus("B1")).setSectionCount(1).setVoltageRegulatorOn(true).setRegulatingTerminal(network.getLoad("LOAD").getTerminal()).setTargetV(200.0).setTargetDeadband(5.0).newLinearModel().setMaximumSectionCount(1).setBPerSection(bPerSection).add().add().addAlias("Alias");
        return network;
    }

    public static Network createWithActivePower(NetworkFactory networkFactory) {
        Network network = ShuntTestCaseFactory.create(networkFactory);
        ShuntCompensator s = network.getShuntCompensator(SHUNT);
        s.getTerminal().setP(1.0);
        return network;
    }

    public static Network createWithActivePower() {
        return ShuntTestCaseFactory.createWithActivePower(NetworkFactory.findDefault());
    }

    public static Network createNonLinear() {
        return ShuntTestCaseFactory.createNonLinear(NetworkFactory.findDefault());
    }

    public static Network createNonLinear(NetworkFactory networkFactory) {
        Network network = ShuntTestCaseFactory.createBase(networkFactory);
        ((ShuntCompensatorAdder)((ShuntCompensatorAdder)((ShuntCompensatorAdder)network.getVoltageLevel("VL1").newShuntCompensator().setId(SHUNT)).setBus("B1")).setConnectableBus("B1")).setSectionCount(1).setVoltageRegulatorOn(true).setRegulatingTerminal(network.getLoad("LOAD").getTerminal()).setTargetV(200.0).setTargetDeadband(5.0).newNonLinearModel().beginSection().setB(1.0E-5).setG(0.0).endSection().beginSection().setB(0.02).setG(0.3).endSection().add().add();
        return network;
    }

    private static Network createBase(NetworkFactory networkFactory) {
        Objects.requireNonNull(networkFactory);
        Network network = networkFactory.createNetwork("shuntTestCase", "test").setCaseDate(ZonedDateTime.parse("2019-09-30T16:29:18.263+02:00"));
        Substation s1 = ((SubstationAdder)network.newSubstation().setId("S1")).setCountry(Country.FR).add();
        VoltageLevel vl1 = ((VoltageLevelAdder)s1.newVoltageLevel().setId("VL1")).setNominalV(380.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl1.getBusBreakerView().newBus().setId("B1")).add();
        Substation s2 = ((SubstationAdder)network.newSubstation().setId("S2")).setCountry(Country.FR).add();
        VoltageLevel vl2 = ((VoltageLevelAdder)s2.newVoltageLevel().setId("VL2")).setNominalV(220.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)vl2.getBusBreakerView().newBus().setId("B2")).add();
        ((LoadAdder)((LoadAdder)((LoadAdder)vl2.newLoad().setId("LOAD")).setConnectableBus("B2")).setBus("B2")).setP0(100.0).setQ0(50.0).add();
        return network;
    }

    public static Network createLocalLinear() {
        return ShuntTestCaseFactory.createLocalShunt(ShuntTestCaseFactory.create());
    }

    public static Network createLocalShunt(Network network) {
        network.getShuntCompensator(SHUNT).setRegulatingTerminal(network.getShuntCompensator(SHUNT).getTerminal());
        return network;
    }

    public static Network createDisabledRemoteLinear() {
        return ShuntTestCaseFactory.createDisabledShunt(ShuntTestCaseFactory.create());
    }

    public static Network createDisabledLocalLinear() {
        return ShuntTestCaseFactory.createDisabledShunt(ShuntTestCaseFactory.createLocalLinear());
    }

    public static Network createDisabledRemoteNonLinear() {
        return ShuntTestCaseFactory.createDisabledShunt(ShuntTestCaseFactory.createNonLinear());
    }

    public static Network createDisabledLocalNonLinear() {
        return ShuntTestCaseFactory.createDisabledShunt(ShuntTestCaseFactory.createLocalNonLinear());
    }

    public static Network createDisabledShunt(Network network) {
        network.getShuntCompensator(SHUNT).setVoltageRegulatorOn(false);
        return network;
    }

    private static Network createShuntWithNoTarget(Network network) {
        network.getShuntCompensator(SHUNT).setVoltageRegulatorOn(false).setTargetV(Double.NaN);
        return network;
    }

    public static Network createRemoteLinearNoTarget() {
        return ShuntTestCaseFactory.createShuntWithNoTarget(ShuntTestCaseFactory.create());
    }

    public static Network createRemoteNonLinearNoTarget() {
        return ShuntTestCaseFactory.createShuntWithNoTarget(ShuntTestCaseFactory.createNonLinear());
    }

    public static Network createLocalLinearNoTarget() {
        return ShuntTestCaseFactory.createShuntWithNoTarget(ShuntTestCaseFactory.createLocalLinear());
    }

    public static Network createLocalNonLinearNoTarget() {
        return ShuntTestCaseFactory.createShuntWithNoTarget(ShuntTestCaseFactory.createLocalNonLinear());
    }

    public static Network createLocalNonLinear() {
        return ShuntTestCaseFactory.createLocalShunt(ShuntTestCaseFactory.createNonLinear());
    }
}

