/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.test;

import com.powsybl.iidm.network.AcDcConverter;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.DanglingLineAdder;
import com.powsybl.iidm.network.DcGroundAdder;
import com.powsybl.iidm.network.DcLineAdder;
import com.powsybl.iidm.network.DcNode;
import com.powsybl.iidm.network.DcNodeAdder;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.LineCommutatedConverterAdder;
import com.powsybl.iidm.network.Load;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.Terminal;
import com.powsybl.iidm.network.ThreeWindingsTransformerAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoWindingsTransformerAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.VoltageSourceConverterAdder;
import java.util.Map;
import java.util.Objects;

public final class DcDetailedNetworkFactory {
    public static final String X_NODE_DC_1_FR = "xNodeDc1fr";
    public static final String X_NODE_DC_1_GB = "xNodeDc1gb";
    public static final String DC_NODE_FR_POS = "dcNodeFrPos";
    public static final String DC_NODE_FR_NEG = "dcNodeFrNeg";
    public static final String DC_NODE_GB_POS = "dcNodeGbPos";
    public static final String DC_NODE_GB_NEG = "dcNodeGbNeg";
    public static final String DC_GROUND_FR = "dcGroundFr";
    public static final String DC_GROUND_GB = "dcGroundGb";
    public static final String SUFFIX_NONE = "";
    public static final String SUFFIX_1 = "-1";
    public static final String SUFFIX_2 = "-2";
    public static final String SUFFIX_400 = "-400";
    public static final String SUFFIX_400_I = "-400-I";
    public static final String SUFFIX_150 = "-150";
    public static final String SUFFIX_150_1 = "-150-1";
    public static final String SUFFIX_150_2 = "-150-2";

    private DcDetailedNetworkFactory() {
    }

    public static String getVoltageLevelId(Country country, String xNode, String suffix) {
        return DcDetailedNetworkFactory.getId("VLDC-", country, xNode, suffix);
    }

    public static String getBusId(Country country, String xNode, String suffix) {
        return DcDetailedNetworkFactory.getId("BUSDC-", country, xNode, suffix);
    }

    public static String getTransformerId(Country country, String xNode, String suffix) {
        return DcDetailedNetworkFactory.getId("TRDC-", country, xNode, suffix);
    }

    public static String getLineId(Country country, String xNode, String suffix) {
        return DcDetailedNetworkFactory.getId("LINEDC-", country, xNode, suffix);
    }

    private static String getId(String type, Country country, String xNode, String suffix) {
        return type + country.name() + "-" + xNode + suffix;
    }

    private static Network createSimpleAcNetworkWithDanglingLines(NetworkFactory networkFactory, Country country, Map<String, Double> xNodes) {
        Objects.requireNonNull(networkFactory);
        Network network = networkFactory.createNetwork(country.name(), "test");
        Substation s = ((SubstationAdder)network.newSubstation().setId("S-" + country.name())).setCountry(country).add();
        VoltageLevel vl = ((VoltageLevelAdder)s.newVoltageLevel().setId("VL-" + country.name())).setNominalV(400.0).setLowVoltageLimit(380.0).setHighVoltageLimit(420.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus b = ((BusAdder)vl.getBusBreakerView().newBus().setId("BUS-" + country.name())).add();
        ((GeneratorAdder)((GeneratorAdder)vl.newGenerator().setId("GEN-" + country.name())).setMinP(0.0).setMaxP(4000.0).setVoltageRegulatorOn(true).setTargetV(400.0).setTargetP(2000.0).setTargetQ(0.0).setBus(b.getId())).add();
        Load load = ((LoadAdder)((LoadAdder)vl.newLoad().setId("LOAD-" + country.name())).setP0(2000.0).setQ0(0.0).setBus(b.getId())).add();
        xNodes.forEach((xNode, v) -> {
            load.setP0(load.getP0() - v);
            ((DanglingLineAdder)((DanglingLineAdder)vl.newDanglingLine().setId("DLAC-" + country.name() + "-" + xNode)).setBus(b.getId())).setR(0.3).setX(3.0).setB(0.0).setG(0.0).setP0(v.doubleValue()).setQ0(0.0).setPairingKey(xNode).add();
        });
        return network;
    }

    private static void addDcAcElements(Network network, Country country, String xNode, double exchange, Mode mode) {
        Objects.requireNonNull(network);
        Objects.requireNonNull(country);
        Objects.requireNonNull(xNode);
        Objects.requireNonNull(mode);
        Substation s = ((SubstationAdder)network.newSubstation().setId("SDC-" + country.name() + "-" + xNode)).add();
        VoltageLevel vldc400 = ((VoltageLevelAdder)s.newVoltageLevel().setId(DcDetailedNetworkFactory.getVoltageLevelId(country, xNode, SUFFIX_400))).setNominalV(400.0).setLowVoltageLimit(380.0).setHighVoltageLimit(420.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus bDc400 = ((BusAdder)vldc400.getBusBreakerView().newBus().setId(DcDetailedNetworkFactory.getBusId(country, xNode, SUFFIX_400))).add();
        ((DanglingLineAdder)((DanglingLineAdder)vldc400.newDanglingLine().setId("DLDC-" + country.name() + "-" + xNode)).setBus(bDc400.getId())).setR(0.3).setX(3.0).setB(0.0).setG(0.0).setP0(exchange).setQ0(0.0).setPairingKey(xNode).add();
        VoltageLevel vldc150 = ((VoltageLevelAdder)s.newVoltageLevel().setId(DcDetailedNetworkFactory.getVoltageLevelId(country, xNode, SUFFIX_150))).setNominalV(150.0).setLowVoltageLimit(120.0).setHighVoltageLimit(180.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        if (mode == Mode.ONE_T2WT) {
            Bus bDc1501 = ((BusAdder)vldc150.getBusBreakerView().newBus().setId(DcDetailedNetworkFactory.getBusId(country, xNode, SUFFIX_150))).add();
            ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s.newTwoWindingsTransformer().setId(DcDetailedNetworkFactory.getTransformerId(country, xNode, SUFFIX_NONE))).setVoltageLevel1(vldc400.getId())).setBus1(bDc400.getId())).setConnectableBus1(bDc400.getId())).setRatedU1(400.0).setVoltageLevel2(vldc150.getId())).setBus2(bDc1501.getId())).setConnectableBus2(bDc1501.getId())).setRatedU2(150.0).setR(0.1).setX(5.0).setG(0.0).setB(0.0).add();
        } else if (mode == Mode.TWO_T2WT) {
            Bus bDc1501 = ((BusAdder)vldc150.getBusBreakerView().newBus().setId(DcDetailedNetworkFactory.getBusId(country, xNode, SUFFIX_150_1))).add();
            Bus bDc1502 = ((BusAdder)vldc150.getBusBreakerView().newBus().setId(DcDetailedNetworkFactory.getBusId(country, xNode, SUFFIX_150_2))).add();
            Bus bDc400i = ((BusAdder)vldc400.getBusBreakerView().newBus().setId(DcDetailedNetworkFactory.getBusId(country, xNode, SUFFIX_400_I))).add();
            ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId(DcDetailedNetworkFactory.getLineId(country, xNode, SUFFIX_400_I))).setVoltageLevel1(vldc400.getId())).setBus1(bDc400.getId())).setConnectableBus1(bDc400.getId())).setVoltageLevel2(vldc400.getId())).setBus2(bDc400i.getId())).setConnectableBus2(bDc400i.getId())).setR(0.3).setX(3.0).setG1(0.0).setB1(0.0).setG2(0.0).setB2(0.0).add();
            ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s.newTwoWindingsTransformer().setId(DcDetailedNetworkFactory.getTransformerId(country, xNode, SUFFIX_1))).setVoltageLevel1(vldc400.getId())).setBus1(bDc400i.getId())).setConnectableBus1(bDc400i.getId())).setRatedU1(400.0).setVoltageLevel2(vldc150.getId())).setBus2(bDc1501.getId())).setConnectableBus2(bDc1501.getId())).setRatedU2(150.0).setR(0.1).setX(5.0).setG(0.0).setB(0.0).add();
            ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s.newTwoWindingsTransformer().setId(DcDetailedNetworkFactory.getTransformerId(country, xNode, SUFFIX_2))).setVoltageLevel1(vldc400.getId())).setBus1(bDc400i.getId())).setConnectableBus1(bDc400i.getId())).setRatedU1(400.0).setVoltageLevel2(vldc150.getId())).setBus2(bDc1502.getId())).setConnectableBus2(bDc1502.getId())).setRatedU2(150.0).setR(0.1).setX(5.0).setG(0.0).setB(0.0).add();
        } else if (mode == Mode.T3WT) {
            Bus bDc1501 = ((BusAdder)vldc150.getBusBreakerView().newBus().setId(DcDetailedNetworkFactory.getBusId(country, xNode, SUFFIX_150_1))).add();
            Bus bDc1502 = ((BusAdder)vldc150.getBusBreakerView().newBus().setId(DcDetailedNetworkFactory.getBusId(country, xNode, SUFFIX_150_2))).add();
            ((ThreeWindingsTransformerAdder)s.newThreeWindingsTransformer().setId(DcDetailedNetworkFactory.getTransformerId(country, xNode, SUFFIX_NONE))).setRatedU0(400.0).newLeg1().setR(0.1).setX(0.0).setG(0.0).setB(0.0).setRatedU(400.0).setVoltageLevel(vldc400.getId()).setBus(bDc400.getId()).add().newLeg2().setR(0.1).setX(5.0).setG(0.0).setB(0.0).setRatedU(150.0).setVoltageLevel(vldc150.getId()).setBus(bDc1501.getId()).add().newLeg3().setR(0.1).setX(5.0).setG(0.0).setB(0.0).setRatedU(150.0).setVoltageLevel(vldc150.getId()).setBus(bDc1502.getId()).add().add();
        }
    }

    private static Network createLccMonopoleBase(NetworkFactory networkFactory, String dcNetworkId) {
        Objects.requireNonNull(networkFactory);
        Objects.requireNonNull(dcNetworkId);
        Network dcNetwork = networkFactory.createNetwork(dcNetworkId, "test");
        Network fr = DcDetailedNetworkFactory.createSimpleAcNetworkWithDanglingLines(networkFactory, Country.FR, Map.of(X_NODE_DC_1_FR, 200.0));
        Network gb = DcDetailedNetworkFactory.createSimpleAcNetworkWithDanglingLines(networkFactory, Country.GB, Map.of(X_NODE_DC_1_GB, -200.0));
        DcDetailedNetworkFactory.addDcAcElements(dcNetwork, Country.FR, X_NODE_DC_1_FR, -200.0, Mode.TWO_T2WT);
        DcDetailedNetworkFactory.addDcAcElements(dcNetwork, Country.GB, X_NODE_DC_1_GB, 200.0, Mode.T3WT);
        DcNode dcNodeFrPos = ((DcNodeAdder)dcNetwork.newDcNode().setId(DC_NODE_FR_POS)).setNominalV(500.0).add();
        DcNode dcNodeFrNeg = ((DcNodeAdder)dcNetwork.newDcNode().setId(DC_NODE_FR_NEG)).setNominalV(1.0).add();
        DcNode dcNodeGbPos = ((DcNodeAdder)dcNetwork.newDcNode().setId(DC_NODE_GB_POS)).setNominalV(500.0).add();
        DcNode dcNodeGbNeg = ((DcNodeAdder)dcNetwork.newDcNode().setId(DC_NODE_GB_NEG)).setNominalV(1.0).add();
        ((DcGroundAdder)dcNetwork.newDcGround().setId(DC_GROUND_FR)).setDcNode(dcNodeFrNeg.getId()).setConnected(true).setR(0.0).add();
        ((DcGroundAdder)dcNetwork.newDcGround().setId(DC_GROUND_GB)).setDcNode(dcNodeGbNeg.getId()).setConnected(true).setR(0.0).add();
        ((DcLineAdder)dcNetwork.newDcLine().setId("dcLine1")).setDcNode1(dcNodeFrPos.getId()).setConnected1(true).setDcNode2(dcNodeGbPos.getId()).setConnected2(true).setR(5.0).add();
        ((LineCommutatedConverterAdder)((LineCommutatedConverterAdder)((LineCommutatedConverterAdder)((LineCommutatedConverterAdder)((LineCommutatedConverterAdder)((LineCommutatedConverterAdder)((LineCommutatedConverterAdder)((LineCommutatedConverterAdder)((LineCommutatedConverterAdder)dcNetwork.getVoltageLevel(DcDetailedNetworkFactory.getVoltageLevelId(Country.FR, X_NODE_DC_1_FR, SUFFIX_150)).newLineCommutatedConverter().setId("LccFr")).setBus1(DcDetailedNetworkFactory.getBusId(Country.FR, X_NODE_DC_1_FR, SUFFIX_150_1))).setBus2(DcDetailedNetworkFactory.getBusId(Country.FR, X_NODE_DC_1_FR, SUFFIX_150_2))).setDcNode1(dcNodeFrNeg.getId())).setDcNode2(dcNodeFrPos.getId())).setControlMode(AcDcConverter.ControlMode.V_DC)).setPccTerminal(dcNetwork.getLine(DcDetailedNetworkFactory.getLineId(Country.FR, X_NODE_DC_1_FR, SUFFIX_400_I)).getTerminal1())).setTargetVdc(500.0)).setTargetP(200.0)).add();
        ((LineCommutatedConverterAdder)((LineCommutatedConverterAdder)((LineCommutatedConverterAdder)((LineCommutatedConverterAdder)((LineCommutatedConverterAdder)((LineCommutatedConverterAdder)((LineCommutatedConverterAdder)((LineCommutatedConverterAdder)((LineCommutatedConverterAdder)dcNetwork.getVoltageLevel(DcDetailedNetworkFactory.getVoltageLevelId(Country.GB, X_NODE_DC_1_GB, SUFFIX_150)).newLineCommutatedConverter().setId("LccGb")).setBus1(DcDetailedNetworkFactory.getBusId(Country.GB, X_NODE_DC_1_GB, SUFFIX_150_1))).setBus2(DcDetailedNetworkFactory.getBusId(Country.GB, X_NODE_DC_1_GB, SUFFIX_150_2))).setDcNode1(dcNodeGbNeg.getId())).setDcNode2(dcNodeGbPos.getId())).setControlMode(AcDcConverter.ControlMode.P_PCC)).setPccTerminal(dcNetwork.getThreeWindingsTransformer(DcDetailedNetworkFactory.getTransformerId(Country.GB, X_NODE_DC_1_GB, SUFFIX_NONE)).getLeg1().getTerminal())).setTargetVdc(500.0)).setTargetP(-200.0)).add();
        return Network.merge((Network[])new Network[]{dcNetwork, fr, gb});
    }

    public static Network createLccMonopoleGroundReturn() {
        return DcDetailedNetworkFactory.createLccMonopoleGroundReturn(NetworkFactory.findDefault());
    }

    public static Network createLccMonopoleGroundReturn(NetworkFactory networkFactory) {
        return DcDetailedNetworkFactory.createLccMonopoleBase(networkFactory, "LccMonopoleGroundReturn");
    }

    public static Network createLccMonopoleMetallicReturn() {
        return DcDetailedNetworkFactory.createLccMonopoleMetallicReturn(NetworkFactory.findDefault());
    }

    public static Network createLccMonopoleMetallicReturn(NetworkFactory networkFactory) {
        Network network = DcDetailedNetworkFactory.createLccMonopoleBase(networkFactory, "LccMonopoleMetallicReturn");
        network.getDcGround(DC_GROUND_GB).getDcTerminal().setConnected(false);
        ((DcLineAdder)network.getSubnetwork("LccMonopoleMetallicReturn").newDcLine().setId("dcLine2")).setDcNode1(DC_NODE_FR_NEG).setConnected1(true).setDcNode2(DC_NODE_GB_NEG).setConnected2(true).setR(5.0).add();
        return network;
    }

    private static Network createVscMonopoleBase(NetworkFactory networkFactory, String dcNetworkId) {
        Objects.requireNonNull(networkFactory);
        Objects.requireNonNull(dcNetworkId);
        Network dcNetwork = networkFactory.createNetwork(dcNetworkId, "test");
        Network fr = DcDetailedNetworkFactory.createSimpleAcNetworkWithDanglingLines(networkFactory, Country.FR, Map.of(X_NODE_DC_1_FR, 200.0));
        Network gb = DcDetailedNetworkFactory.createSimpleAcNetworkWithDanglingLines(networkFactory, Country.GB, Map.of(X_NODE_DC_1_GB, -200.0));
        DcDetailedNetworkFactory.addDcAcElements(dcNetwork, Country.FR, X_NODE_DC_1_FR, -200.0, Mode.ONE_T2WT);
        DcDetailedNetworkFactory.addDcAcElements(dcNetwork, Country.GB, X_NODE_DC_1_GB, 200.0, Mode.ONE_T2WT);
        DcNode dcNodeFrPos = ((DcNodeAdder)dcNetwork.newDcNode().setId(DC_NODE_FR_POS)).setNominalV(250.0).add();
        DcNode dcNodeFrNeg = ((DcNodeAdder)dcNetwork.newDcNode().setId(DC_NODE_FR_NEG)).setNominalV(250.0).add();
        DcNode dcNodeGbPos = ((DcNodeAdder)dcNetwork.newDcNode().setId(DC_NODE_GB_POS)).setNominalV(250.0).add();
        DcNode dcNodeGbNeg = ((DcNodeAdder)dcNetwork.newDcNode().setId(DC_NODE_GB_NEG)).setNominalV(250.0).add();
        ((DcLineAdder)dcNetwork.newDcLine().setId("dcLinePos")).setDcNode1(dcNodeFrPos.getId()).setDcNode2(dcNodeGbPos.getId()).setR(5.0).add();
        ((DcLineAdder)dcNetwork.newDcLine().setId("dcLineNeg")).setDcNode1(dcNodeFrNeg.getId()).setDcNode2(dcNodeGbNeg.getId()).setR(5.0).add();
        Terminal frPccTerminal = dcNetwork.getTwoWindingsTransformer(DcDetailedNetworkFactory.getTransformerId(Country.FR, X_NODE_DC_1_FR, SUFFIX_NONE)).getTerminal1();
        ((VoltageSourceConverterAdder)((VoltageSourceConverterAdder)((VoltageSourceConverterAdder)((VoltageSourceConverterAdder)((VoltageSourceConverterAdder)((VoltageSourceConverterAdder)((VoltageSourceConverterAdder)((VoltageSourceConverterAdder)dcNetwork.getVoltageLevel(DcDetailedNetworkFactory.getVoltageLevelId(Country.FR, X_NODE_DC_1_FR, SUFFIX_150)).newVoltageSourceConverter().setId("VscFr")).setBus1(DcDetailedNetworkFactory.getBusId(Country.FR, X_NODE_DC_1_FR, SUFFIX_150))).setDcNode1(dcNodeFrNeg.getId())).setDcNode2(dcNodeFrPos.getId())).setControlMode(AcDcConverter.ControlMode.V_DC)).setPccTerminal(frPccTerminal)).setTargetVdc(500.0)).setTargetP(200.0)).setVoltageRegulatorOn(false).setReactivePowerSetpoint(0.0).setVoltageSetpoint(400.0).add();
        Terminal gbPccTerminal = dcNetwork.getTwoWindingsTransformer(DcDetailedNetworkFactory.getTransformerId(Country.GB, X_NODE_DC_1_GB, SUFFIX_NONE)).getTerminal1();
        ((VoltageSourceConverterAdder)((VoltageSourceConverterAdder)((VoltageSourceConverterAdder)((VoltageSourceConverterAdder)((VoltageSourceConverterAdder)((VoltageSourceConverterAdder)((VoltageSourceConverterAdder)((VoltageSourceConverterAdder)dcNetwork.getVoltageLevel(DcDetailedNetworkFactory.getVoltageLevelId(Country.GB, X_NODE_DC_1_GB, SUFFIX_150)).newVoltageSourceConverter().setId("VscGb")).setBus1(DcDetailedNetworkFactory.getBusId(Country.GB, X_NODE_DC_1_GB, SUFFIX_150))).setDcNode1(dcNodeGbNeg.getId())).setDcNode2(dcNodeGbPos.getId())).setControlMode(AcDcConverter.ControlMode.P_PCC)).setPccTerminal(gbPccTerminal)).setTargetVdc(500.0)).setTargetP(-200.0)).setVoltageRegulatorOn(false).setReactivePowerSetpoint(0.0).setVoltageSetpoint(400.0).add();
        return Network.merge((Network[])new Network[]{dcNetwork, fr, gb});
    }

    public static Network createVscSymmetricalMonopole() {
        return DcDetailedNetworkFactory.createVscSymmetricalMonopole(NetworkFactory.findDefault());
    }

    public static Network createVscSymmetricalMonopole(NetworkFactory networkFactory) {
        return DcDetailedNetworkFactory.createVscMonopoleBase(networkFactory, "VscSymmetricalMonopole");
    }

    public static Network createVscAsymmetricalMonopole() {
        return DcDetailedNetworkFactory.createVscAsymmetricalMonopole(NetworkFactory.findDefault());
    }

    public static Network createVscAsymmetricalMonopole(NetworkFactory networkFactory) {
        Network network = DcDetailedNetworkFactory.createVscMonopoleBase(networkFactory, "VscAsymmetricalMonopole");
        Network dcNetwork = network.getSubnetwork("VscAsymmetricalMonopole");
        dcNetwork.getDcLine("dcLineNeg").remove();
        dcNetwork.getDcNode(DC_NODE_FR_POS).setNominalV(500.0);
        dcNetwork.getDcNode(DC_NODE_GB_POS).setNominalV(500.0);
        dcNetwork.getDcNode(DC_NODE_FR_NEG).setNominalV(1.0);
        dcNetwork.getDcNode(DC_NODE_GB_NEG).setNominalV(1.0);
        ((DcGroundAdder)dcNetwork.newDcGround().setId(DC_GROUND_FR)).setDcNode(DC_NODE_FR_NEG).setConnected(true).setR(0.0).add();
        ((DcGroundAdder)dcNetwork.newDcGround().setId(DC_GROUND_GB)).setDcNode(DC_NODE_GB_NEG).setConnected(true).setR(0.0).add();
        return network;
    }

    static enum Mode {
        ONE_T2WT,
        TWO_T2WT,
        T3WT;

    }
}

