/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.test;

import com.powsybl.iidm.network.Battery;
import com.powsybl.iidm.network.BatteryAdder;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.EnergySource;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.LoadType;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import java.time.ZonedDateTime;
import java.util.Objects;

public final class BatteryNetworkFactory {
    private static final String VLGEN = "VLGEN";
    private static final String VLBAT = "VLBAT";

    private BatteryNetworkFactory() {
    }

    public static Network create() {
        return BatteryNetworkFactory.create(NetworkFactory.findDefault());
    }

    public static Network create(NetworkFactory networkFactory) {
        Objects.requireNonNull(networkFactory);
        Network network = networkFactory.createNetwork("fictitious", "test");
        network.setCaseDate(ZonedDateTime.parse("2017-06-25T17:43:00.000+01:00"));
        network.setForecastDistance(0);
        Substation p1 = ((SubstationAdder)network.newSubstation().setId("P1")).setCountry(Country.FR).setTso("R").setGeographicalTags(new String[]{"A"}).add();
        Substation p2 = ((SubstationAdder)network.newSubstation().setId("P2")).setCountry(Country.FR).setTso("R").setGeographicalTags(new String[]{"B"}).add();
        VoltageLevel vlgen = ((VoltageLevelAdder)p1.newVoltageLevel().setId(VLGEN)).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        VoltageLevel vlbat = ((VoltageLevelAdder)p2.newVoltageLevel().setId(VLBAT)).setNominalV(400.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        Bus ngen = ((BusAdder)vlgen.getBusBreakerView().newBus().setId("NGEN")).add();
        Bus nbat = ((BusAdder)vlbat.getBusBreakerView().newBus().setId("NBAT")).add();
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("NHV1_NHV2_1")).setVoltageLevel1(vlgen.getId())).setBus1(ngen.getId())).setConnectableBus1(ngen.getId())).setVoltageLevel2(vlbat.getId())).setBus2(nbat.getId())).setConnectableBus2(nbat.getId())).setR(3.0).setX(33.0).setG1(0.0).setB1(1.93E-4).setG2(0.0).setB2(1.93E-4).add();
        ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("NHV1_NHV2_2")).setVoltageLevel1(vlgen.getId())).setBus1(ngen.getId())).setConnectableBus1(ngen.getId())).setVoltageLevel2(vlbat.getId())).setBus2(nbat.getId())).setConnectableBus2(nbat.getId())).setR(3.0).setX(33.0).setG1(0.0).setB1(1.93E-4).setG2(0.0).setB2(1.93E-4).add();
        Generator generator = ((GeneratorAdder)((GeneratorAdder)((GeneratorAdder)vlgen.newGenerator().setId("GEN")).setBus(ngen.getId())).setConnectableBus(ngen.getId())).setEnergySource(EnergySource.OTHER).setMinP(-9999.99).setMaxP(9999.99).setVoltageRegulatorOn(true).setTargetV(24.5).setTargetP(607.0).setTargetQ(301.0).add();
        generator.getTerminal().setP(-605.0);
        generator.getTerminal().setQ(-225.0);
        generator.newMinMaxReactiveLimits().setMinQ(-9999.99).setMaxQ(9999.99).add();
        Battery battery = ((BatteryAdder)((BatteryAdder)((BatteryAdder)vlbat.newBattery().setId("BAT")).setBus(nbat.getId())).setConnectableBus(nbat.getId())).setTargetP(9999.99).setTargetQ(9999.99).setMinP(-9999.99).setMaxP(9999.99).add();
        battery.newMinMaxReactiveLimits().setMinQ(-9999.99).setMaxQ(9999.99).add();
        battery.getTerminal().setP(-605.0);
        battery.getTerminal().setQ(-225.0);
        Battery battery2 = ((BatteryAdder)((BatteryAdder)((BatteryAdder)vlbat.newBattery().setId("BAT2")).setBus(nbat.getId())).setConnectableBus(nbat.getId())).setTargetP(100.0).setTargetQ(200.0).setMinP(-200.0).setMaxP(200.0).add();
        battery2.newReactiveCapabilityCurve().beginPoint().setP(0.0).setMinQ(-59.3).setMaxQ(60.0).endPoint().beginPoint().setP(70.0).setMinQ(-54.55).setMaxQ(46.25).endPoint().add();
        battery2.getTerminal().setP(-605.0);
        battery2.getTerminal().setQ(-225.0);
        ((LoadAdder)((LoadAdder)((LoadAdder)vlbat.newLoad().setId("LOAD")).setLoadType(LoadType.UNDEFINED).setBus(nbat.getId())).setConnectableBus(nbat.getId())).setP0(600.0).setQ0(200.0).add();
        return network;
    }
}

