/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.test;

import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.Country;
import com.powsybl.iidm.network.CurrentLimitsAdder;
import com.powsybl.iidm.network.DanglingLine;
import com.powsybl.iidm.network.DanglingLineAdder;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import java.util.Objects;

public final class DanglingLineNetworkFactory {
    private DanglingLineNetworkFactory() {
    }

    public static Network create() {
        return DanglingLineNetworkFactory.create(NetworkFactory.findDefault());
    }

    public static Network create(NetworkFactory networkFactory) {
        Network network = DanglingLineNetworkFactory.createBase(networkFactory);
        DanglingLine danglingLine = ((DanglingLineAdder)((DanglingLineAdder)network.getVoltageLevel("VL").newDanglingLine().setId("DL")).setBus("BUS")).setR(10.0).setX(1.0).setB(1.0E-5).setG(1.0E-4).setP0(50.0).setQ0(30.0).add();
        DanglingLineNetworkFactory.createDanglingLineCurrentLimits(danglingLine);
        return network;
    }

    public static Network createWithGeneration() {
        return DanglingLineNetworkFactory.createWithGeneration(NetworkFactory.findDefault());
    }

    public static Network createWithGeneration(NetworkFactory networkFactory) {
        Network network = DanglingLineNetworkFactory.createBase(networkFactory);
        DanglingLine danglingLine = ((DanglingLineAdder)((DanglingLineAdder)network.getVoltageLevel("VL").newDanglingLine().setId("DL")).setBus("BUS")).setR(10.0).setX(1.0).setB(1.0E-5).setG(1.0E-4).setP0(50.0).setQ0(30.0).newGeneration().setTargetP(440.0).setMaxP(900.0).setMinP(0.0).setTargetV(101.0).setVoltageRegulationOn(true).add().add();
        danglingLine.getGeneration().newReactiveCapabilityCurve().beginPoint().setP(0.0).setMinQ(-59.3).setMaxQ(60.0).endPoint().beginPoint().setP(70.0).setMinQ(-54.55).setMaxQ(46.25).endPoint().add();
        DanglingLineNetworkFactory.createDanglingLineCurrentLimits(danglingLine);
        return network;
    }

    private static Network createBase(NetworkFactory networkFactory) {
        Objects.requireNonNull(networkFactory);
        Network network = networkFactory.createNetwork("dangling-line", "test");
        Substation substation = ((SubstationAdder)network.newSubstation().setId("S")).setCountry(Country.FR).add();
        VoltageLevel voltageLevel = ((VoltageLevelAdder)substation.newVoltageLevel().setId("VL")).setNominalV(100.0).setLowVoltageLimit(80.0).setHighVoltageLimit(120.0).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)voltageLevel.getBusBreakerView().newBus().setId("BUS")).add();
        ((GeneratorAdder)((GeneratorAdder)voltageLevel.newGenerator().setId("G")).setMinP(0.0).setMaxP(100.0).setVoltageRegulatorOn(true).setTargetV(100.0).setTargetP(50.0).setTargetQ(30.0).setBus("BUS")).add();
        return network;
    }

    private static void createDanglingLineCurrentLimits(DanglingLine danglingLine) {
        ((CurrentLimitsAdder)((CurrentLimitsAdder)((CurrentLimitsAdder)danglingLine.getOrCreateSelectedOperationalLimitsGroup().newCurrentLimits().setPermanentLimit(100.0)).beginTemporaryLimit().setName("20'").setValue(120.0).setAcceptableDuration(1200).endTemporaryLimit()).beginTemporaryLimit().setName("10'").setValue(140.0).setAcceptableDuration(600).endTemporaryLimit()).add();
    }
}

