/*
 * Decompiled with CFR 0.152.
 */
package com.powsybl.iidm.network.test;

import com.powsybl.commons.PowsyblException;
import com.powsybl.iidm.network.Bus;
import com.powsybl.iidm.network.BusAdder;
import com.powsybl.iidm.network.Generator;
import com.powsybl.iidm.network.GeneratorAdder;
import com.powsybl.iidm.network.LineAdder;
import com.powsybl.iidm.network.LoadAdder;
import com.powsybl.iidm.network.Network;
import com.powsybl.iidm.network.NetworkFactory;
import com.powsybl.iidm.network.Substation;
import com.powsybl.iidm.network.SubstationAdder;
import com.powsybl.iidm.network.TopologyKind;
import com.powsybl.iidm.network.TwoWindingsTransformer;
import com.powsybl.iidm.network.TwoWindingsTransformerAdder;
import com.powsybl.iidm.network.VoltageLevel;
import com.powsybl.iidm.network.VoltageLevelAdder;
import com.powsybl.iidm.network.extensions.GeneratorFortescueAdder;
import com.powsybl.iidm.network.extensions.LineFortescueAdder;
import com.powsybl.iidm.network.extensions.LoadAsymmetricalAdder;
import com.powsybl.iidm.network.extensions.LoadConnectionType;
import com.powsybl.iidm.network.extensions.SlackTerminalAdder;
import com.powsybl.iidm.network.extensions.TwoWindingsTransformerFortescueAdder;
import com.powsybl.iidm.network.extensions.WindingConnectionType;
import com.univocity.parsers.annotations.Parsed;
import com.univocity.parsers.common.processor.BeanListProcessor;
import com.univocity.parsers.common.processor.core.Processor;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.SubnodeConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;

public final class EuropeanLvTestFeederFactory {
    private EuropeanLvTestFeederFactory() {
    }

    private static void createSource(Transformer transformer, Network network) {
        INIConfiguration iniConfiguration = new INIConfiguration();
        try (InputStreamReader reader = new InputStreamReader(Objects.requireNonNull(EuropeanLvTestFeederFactory.class.getResourceAsStream("/europeanLvTestFeeder/Source.csv")), StandardCharsets.UTF_8);){
            iniConfiguration.read((Reader)reader);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (ConfigurationException e) {
            throw new PowsyblException((Throwable)e);
        }
        SubnodeConfiguration source = iniConfiguration.getSection("Source");
        double voltage = Integer.parseInt(source.getString("Voltage").replace(" kV", ""));
        double pu = Double.parseDouble(source.getString("pu"));
        double isc3 = Integer.parseInt(source.getString("ISC3").replace(" A", ""));
        double isc1 = Integer.parseInt(source.getString("ISC1").replace(" A", ""));
        Substation sourceSubstation = ((SubstationAdder)network.newSubstation().setId(EuropeanLvTestFeederFactory.getSubstationId(transformer.bus2))).add();
        VoltageLevel sourceVoltageLevel = ((VoltageLevelAdder)sourceSubstation.newVoltageLevel().setId("SourceVoltageLevel")).setNominalV(voltage).setTopologyKind(TopologyKind.BUS_BREAKER).add();
        ((BusAdder)sourceVoltageLevel.getBusBreakerView().newBus().setId("SourceBus")).add();
        Generator sourceGenerator = ((GeneratorAdder)((GeneratorAdder)sourceVoltageLevel.newGenerator().setId("SourceGenerator")).setBus("SourceBus")).setMinP(0.0).setMaxP(0.0).setTargetP(0.0).setVoltageRegulatorOn(true).setTargetV(voltage * pu).add();
        ((SlackTerminalAdder)sourceVoltageLevel.newExtension(SlackTerminalAdder.class)).withTerminal(sourceGenerator.getTerminal()).add();
        double zn = pu * voltage / (Math.sqrt(3.0) * isc1);
        double zz = pu * voltage / (Math.sqrt(3.0) * isc3);
        double rn = Math.sqrt(zn * zn / 101.0);
        double xn = 10.0 * rn;
        double rz = Math.sqrt(zz * zz / 101.0);
        double xz = 10.0 * rz;
        ((GeneratorFortescueAdder)sourceGenerator.newExtension(GeneratorFortescueAdder.class)).withRn(rn).withXn(xn).withRz(rz).withXz(xz).add();
    }

    private static <T> List<T> parseCsv(String resourceName, Class<T> clazz) {
        List list;
        InputStreamReader inputReader = new InputStreamReader(Objects.requireNonNull(EuropeanLvTestFeederFactory.class.getResourceAsStream(resourceName)), StandardCharsets.UTF_8);
        try {
            BeanListProcessor rowProcessor = new BeanListProcessor(clazz);
            CsvParserSettings settings = new CsvParserSettings();
            settings.setHeaderExtractionEnabled(true);
            settings.setProcessor((Processor)rowProcessor);
            CsvParser parser = new CsvParser(settings);
            parser.parse((Reader)inputReader);
            list = rowProcessor.getBeans();
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)inputReader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        ((Reader)inputReader).close();
        return list;
    }

    private static String getBusId(int busName) {
        return "Bus-" + busName;
    }

    private static String getVoltageLevelId(int busName) {
        return "VoltageLevel-" + busName;
    }

    private static String getSubstationId(int busName) {
        return "Substation-" + busName;
    }

    private static void createBuses(Network network) {
        for (BusCoord busCoord : EuropeanLvTestFeederFactory.parseCsv("/europeanLvTestFeeder/Buscoords.csv", BusCoord.class)) {
            String substationId = EuropeanLvTestFeederFactory.getSubstationId(busCoord.busName);
            Substation s = network.getSubstation(substationId);
            if (s == null) {
                s = ((SubstationAdder)network.newSubstation().setId(substationId)).add();
            }
            VoltageLevel vl = ((VoltageLevelAdder)s.newVoltageLevel().setId(EuropeanLvTestFeederFactory.getVoltageLevelId(busCoord.busName))).setTopologyKind(TopologyKind.BUS_BREAKER).setNominalV(1.0).add();
            ((BusAdder)vl.getBusBreakerView().newBus().setId(EuropeanLvTestFeederFactory.getBusId(busCoord.busName))).add();
        }
    }

    private static void createLines(Network network) {
        HashMap<String, LineCode> lineCodes = new HashMap<String, LineCode>();
        for (LineCode lineCode : EuropeanLvTestFeederFactory.parseCsv("/europeanLvTestFeeder/LineCodes.csv", LineCode.class)) {
            lineCodes.put(lineCode.name, lineCode);
        }
        for (Line line : EuropeanLvTestFeederFactory.parseCsv("/europeanLvTestFeeder/Lines.csv", Line.class)) {
            LineCode lineCode = (LineCode)lineCodes.get(line.code);
            com.powsybl.iidm.network.Line l = ((LineAdder)((LineAdder)((LineAdder)((LineAdder)((LineAdder)network.newLine().setId("Line-" + line.bus1 + "-" + line.bus2)).setVoltageLevel1(EuropeanLvTestFeederFactory.getVoltageLevelId(line.bus1))).setBus1(EuropeanLvTestFeederFactory.getBusId(line.bus1))).setVoltageLevel2(EuropeanLvTestFeederFactory.getVoltageLevelId(line.bus2))).setBus2(EuropeanLvTestFeederFactory.getBusId(line.bus2))).setR(lineCode.r1 * line.length).setX(lineCode.x1 * line.length).add();
            ((LineFortescueAdder)l.newExtension(LineFortescueAdder.class)).withRz(lineCode.r0 * line.length).withXz(lineCode.x0 * line.length).add();
        }
    }

    private static LoadConnectionType getConnectionType(Load load) {
        if (load.connection.equals("wye")) {
            return LoadConnectionType.Y;
        }
        throw new PowsyblException("Unknown load connection: " + load.connection);
    }

    private static void createLoads(Network network) {
        for (Load load : EuropeanLvTestFeederFactory.parseCsv("/europeanLvTestFeeder/Loads.csv", Load.class)) {
            VoltageLevel vl = network.getVoltageLevel(EuropeanLvTestFeederFactory.getVoltageLevelId(load.bus));
            double p0 = load.kW / 1000.0;
            double q0 = p0 * load.pf;
            com.powsybl.iidm.network.Load l = ((LoadAdder)((LoadAdder)vl.newLoad().setId("Load-" + load.bus)).setBus(EuropeanLvTestFeederFactory.getBusId(load.bus))).setP0(p0).setQ0(q0).add();
            double deltaPa = 0.0;
            double deltaQa = 0.0;
            double deltaPb = 0.0;
            double deltaQb = 0.0;
            double deltaPc = 0.0;
            double deltaQc = 0.0;
            switch (load.phases) {
                case 'A': {
                    deltaPb = -p0;
                    deltaQb = -q0;
                    deltaPc = -p0;
                    deltaQc = -q0;
                    break;
                }
                case 'B': {
                    deltaPa = -p0;
                    deltaQa = -q0;
                    deltaPc = -p0;
                    deltaQc = -q0;
                    break;
                }
                case 'C': {
                    deltaPa = -p0;
                    deltaQa = -q0;
                    deltaPb = -p0;
                    deltaQb = -q0;
                    break;
                }
                default: {
                    throw new PowsyblException("Unknown phase: " + load.phases);
                }
            }
            ((LoadAsymmetricalAdder)l.newExtension(LoadAsymmetricalAdder.class)).withConnectionType(EuropeanLvTestFeederFactory.getConnectionType(load)).withDeltaPa(deltaPa).withDeltaQa(deltaQa).withDeltaPb(deltaPb).withDeltaQb(deltaQb).withDeltaPc(deltaPc).withDeltaQc(deltaQc).add();
        }
    }

    private static WindingConnectionType getConnectionType(String conn) {
        switch (conn) {
            case "Delta": {
                return WindingConnectionType.DELTA;
            }
            case "Wye": {
                return WindingConnectionType.Y;
            }
        }
        throw new PowsyblException("Connection type not supported: " + conn);
    }

    private static void createTransformer(Transformer transformer, Network network) {
        String busId1 = transformer.bus1;
        String busId2 = EuropeanLvTestFeederFactory.getBusId(transformer.bus2);
        Bus bus1 = network.getBusBreakerView().getBus(busId1);
        Bus bus2 = network.getBusBreakerView().getBus(busId2);
        Substation s = (Substation)bus1.getVoltageLevel().getSubstation().orElseThrow();
        double sb = 1.0;
        double zb = transformer.kvPri * transformer.kvPri / sb;
        double r = transformer.resistance / 100.0 / transformer.mva * zb;
        double x = transformer.xhl / 100.0 / transformer.mva * zb;
        TwoWindingsTransformer twt = ((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)((TwoWindingsTransformerAdder)s.newTwoWindingsTransformer().setId("Transformer-" + transformer.bus1 + "-" + transformer.bus2)).setBus1(busId1)).setVoltageLevel1(bus1.getVoltageLevel().getId())).setBus2(busId2)).setVoltageLevel2(bus2.getVoltageLevel().getId())).setRatedU1(transformer.kvPri).setRatedU2(transformer.kvSec).setRatedS(transformer.mva).setR(r).setX(x).add();
        ((TwoWindingsTransformerFortescueAdder)twt.newExtension(TwoWindingsTransformerFortescueAdder.class)).withConnectionType1(EuropeanLvTestFeederFactory.getConnectionType(transformer.connPri)).withConnectionType2(EuropeanLvTestFeederFactory.getConnectionType(transformer.connSec)).add();
    }

    public static Network create() {
        return EuropeanLvTestFeederFactory.create(NetworkFactory.findDefault());
    }

    public static Network create(NetworkFactory networkFactory) {
        Network network = networkFactory.createNetwork("EuropeanLvTestFeeder", "csv");
        network.setCaseDate(ZonedDateTime.parse("2023-04-11T23:59:00.000+01:00"));
        Transformer transformer = EuropeanLvTestFeederFactory.parseCsv("/europeanLvTestFeeder/Transformer.csv", Transformer.class).get(0);
        EuropeanLvTestFeederFactory.createSource(transformer, network);
        EuropeanLvTestFeederFactory.createBuses(network);
        EuropeanLvTestFeederFactory.createLines(network);
        EuropeanLvTestFeederFactory.createLoads(network);
        EuropeanLvTestFeederFactory.createTransformer(transformer, network);
        return network;
    }

    public static class Transformer {
        @Parsed(field={"Name"})
        String name;
        @Parsed
        int phases;
        @Parsed
        String bus1;
        @Parsed
        int bus2;
        @Parsed(field={"kV_pri"})
        double kvPri;
        @Parsed(field={"kV_sec"})
        double kvSec;
        @Parsed(field={"MVA"})
        double mva;
        @Parsed(field={"Conn_pri"})
        String connPri;
        @Parsed(field={"Conn_sec"})
        String connSec;
        @Parsed(field={"%XHL"})
        double xhl;
        @Parsed(field={"% resistance"})
        double resistance;
    }

    public static class BusCoord {
        @Parsed(field={"Busname"})
        int busName;
        @Parsed
        double x;
        @Parsed
        double y;
    }

    public static class LineCode {
        @Parsed(field={"Name"})
        String name;
        @Parsed
        int nphases;
        @Parsed(field={"R1"})
        double r1;
        @Parsed(field={"X1"})
        double x1;
        @Parsed(field={"R0"})
        double r0;
        @Parsed(field={"X0"})
        double x0;
        @Parsed(field={"C1"})
        double c1;
        @Parsed(field={"C0"})
        double c0;
        @Parsed(field={"Units"})
        String units;
    }

    public static class Line {
        @Parsed(field={"Name"})
        String name;
        @Parsed(field={"Bus1"})
        int bus1;
        @Parsed(field={"Bus2"})
        int bus2;
        @Parsed(field={"Phases"})
        String phases;
        @Parsed(field={"Length"})
        double length;
        @Parsed(field={"Units"})
        String units;
        @Parsed(field={"LineCode"})
        String code;
    }

    public static class Load {
        @Parsed(field={"Name"})
        String name;
        @Parsed
        int numPhases;
        @Parsed(field={"Bus"})
        int bus;
        @Parsed
        char phases;
        @Parsed
        double kV;
        @Parsed(field={"Model"})
        int model;
        @Parsed(field={"Connection"})
        String connection;
        @Parsed
        double kW;
        @Parsed(field={"PF"})
        double pf;
        @Parsed(field={"Yearly"})
        String yearly;
    }
}

